/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGlobal;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyJava;
import org.jruby.RubyJavaInterface;
import org.jruby.RubyJavaObject;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.runtime.CallbackFactory;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;

public class RubyClasses {
    private Ruby ruby;
    private RubyClass arrayClass;
    private RubyClass bignumClass;
    private RubyClass bindingClass;
    private RubyClass classClass;
    private RubyClass continuationClass;
    private RubyClass dirClass;
    private RubyClass exceptionClass;
    private RubyClass falseClass;
    private RubyClass fileClass;
    private RubyClass fileStatClass;
    private RubyClass fixnumClass;
    private RubyClass floatClass;
    private RubyClass hashClass;
    private RubyClass integerClass;
    private RubyClass ioClass;
    private RubyClass javaInterfaceClass;
    private RubyClass javaObjectClass;
    private RubyClass matchDataClass;
    private RubyClass methodClass;
    private RubyClass moduleClass;
    private RubyClass nilClass;
    private RubyClass numericClass;
    private RubyClass objectClass;
    private RubyClass procClass;
    private RubyClass rangeClass;
    private RubyClass regExpClass;
    private RubyClass stringClass;
    private RubyClass structClass;
    private RubyClass structTmsClass;
    private RubyClass symbolClass;
    private RubyClass threadClass;
    private RubyClass threadGroupClass;
    private RubyClass timeClass;
    private RubyClass trueClass;
    private RubyModule comparableModule;
    private RubyModule enumerableModule;
    private RubyModule gcModule;
    private RubyModule javaModule;
    private RubyModule kernelModule;
    private RubyModule marshalModule;
    private RubyModule mathModule;
    private RubyModule objectSpaceModule;
    private RubyModule processModule;
    private RubyMap classMap;

    public RubyClasses(Ruby ruby) {
        this.ruby = ruby;
        this.classMap = new RubyHashMap();
    }

    private RubyClass defineBootClass(String name, RubyClass superClass) {
        RubyClass bootClass = RubyClass.newClass(this.ruby, superClass);
        bootClass.setName(name);
        this.classMap.put(name, bootClass);
        return bootClass;
    }

    public void initCoreClasses() {
        this.objectClass = this.defineBootClass("Object", null);
        this.moduleClass = this.defineBootClass("Module", this.objectClass);
        this.classClass = this.defineBootClass("Class", this.moduleClass);
        RubyClass metaClass = this.classClass.newSingletonClass();
        this.objectClass.setRubyClass(metaClass);
        metaClass.attachSingletonClass(this.objectClass);
        metaClass = metaClass.newSingletonClass();
        this.moduleClass.setRubyClass(metaClass);
        metaClass.attachSingletonClass(this.moduleClass);
        metaClass = metaClass.newSingletonClass();
        this.classClass.setRubyClass(metaClass);
        metaClass.attachSingletonClass(this.classClass);
        this.kernelModule = this.ruby.defineModule("Kernel");
        this.objectClass.includeModule(this.kernelModule);
        this.objectClass.definePrivateMethod("initialize", CallbackFactory.getNilMethod());
        this.classClass.definePrivateMethod("inherited", CallbackFactory.getNilMethod());
        RubyObject.createObjectClass(this.kernelModule);
        RubyClass.createClassClass(this.classClass);
        RubyModule.createModuleClass(this.moduleClass);
        this.symbolClass = RubySymbol.createSymbolClass(this.ruby);
        this.nilClass = RubyNil.createNilClass(this.ruby);
        this.falseClass = RubyBoolean.createFalseClass(this.ruby);
        this.trueClass = RubyBoolean.createTrueClass(this.ruby);
        this.comparableModule = RubyComparable.createComparable(this.ruby);
        this.enumerableModule = RubyEnumerable.createEnumerableModule(this.ruby);
        this.numericClass = RubyNumeric.createNumericClass(this.ruby);
        this.integerClass = RubyInteger.createIntegerClass(this.ruby);
        this.fixnumClass = RubyFixnum.createFixnumClass(this.ruby);
        this.bignumClass = RubyBignum.createBignumClass(this.ruby);
        this.floatClass = RubyFloat.createFloatClass(this.ruby);
        this.stringClass = RubyString.createStringClass(this.ruby);
        this.regExpClass = RubyRegexp.createRegexpClass(this.ruby);
        this.matchDataClass = RubyMatchData.createMatchDataClass(this.ruby);
        this.arrayClass = RubyArray.createArrayClass(this.ruby);
        this.hashClass = RubyHash.createHashClass(this.ruby);
        this.rangeClass = RubyRange.createRangeClass(this.ruby);
        this.javaModule = RubyJava.createJavaModule(this.ruby);
        this.javaObjectClass = RubyJavaObject.createJavaObjectClass(this.ruby);
        this.javaInterfaceClass = RubyJavaInterface.createJavaInterfaceClass(this.ruby);
        this.ioClass = RubyIO.createIOClass(this.ruby);
        this.fileClass = RubyFile.createFileClass(this.ruby);
        this.exceptionClass = RubyException.createExceptionClass(this.ruby);
        this.methodClass = RubyMethod.createMethodClass(this.ruby);
        this.procClass = RubyProc.createProcClass(this.ruby);
        this.objectSpaceModule = RubyObjectSpace.createObjectSpaceModule(this.ruby);
        this.mathModule = RubyMath.createMathModule(this.ruby);
        this.timeClass = RubyTime.createTimeClass(this.ruby);
        this.structClass = RubyStruct.createStructClass(this.ruby);
        RubyGlobal.createGlobals(this.ruby);
    }

    public RubyClass getBindingClass() {
        return this.bindingClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyClass getModuleClass() {
        return this.moduleClass;
    }

    public RubyClass getStructClass() {
        return this.structClass;
    }

    public RubyModule getComparableModule() {
        return this.comparableModule;
    }

    public RubyClass getHashClass() {
        return this.hashClass;
    }

    public RubyModule getMathModule() {
        return this.mathModule;
    }

    public RubyClass getRegExpClass() {
        return this.regExpClass;
    }

    public RubyModule getProcessModule() {
        return this.processModule;
    }

    public RubyClass getIoClass() {
        return this.ioClass;
    }

    public RubyClass getThreadGroupClass() {
        return this.threadGroupClass;
    }

    public RubyClass getBignumClass() {
        return this.bignumClass;
    }

    public RubyClass getStructTmsClass() {
        return this.structTmsClass;
    }

    public RubyClass getRangeClass() {
        return this.rangeClass;
    }

    public RubyModule getGcModule() {
        return this.gcModule;
    }

    public RubyClass getSymbolClass() {
        return this.symbolClass;
    }

    public RubyClass getProcClass() {
        return this.procClass;
    }

    public RubyClass getContinuationClass() {
        return this.continuationClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    public RubyClass getFloatClass() {
        return this.floatClass;
    }

    public RubyClass getMethodClass() {
        return this.methodClass;
    }

    public RubyClass getMatchDataClass() {
        return this.matchDataClass;
    }

    public RubyModule getMarshalModule() {
        return this.marshalModule;
    }

    public RubyClass getFixnumClass() {
        return this.fixnumClass;
    }

    public RubyClass getObjectClass() {
        return this.objectClass;
    }

    public RubyModule getObjectSpaceModule() {
        return this.objectSpaceModule;
    }

    public RubyClass getDirClass() {
        return this.dirClass;
    }

    public RubyClass getExceptionClass() {
        return this.exceptionClass;
    }

    public RubyClass getStringClass() {
        return this.stringClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    public RubyClass getIntegerClass() {
        return this.integerClass;
    }

    public RubyModule getKernelModule() {
        return this.kernelModule;
    }

    public RubyClass getThreadClass() {
        return this.threadClass;
    }

    public RubyClass getFileClass() {
        return this.fileClass;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    public RubyClass getArrayClass() {
        return this.arrayClass;
    }

    public RubyClass getFileStatClass() {
        return this.fileStatClass;
    }

    public RubyModule getEnumerableModule() {
        return this.enumerableModule;
    }

    public RubyClass getJavaObjectClass() {
        return this.javaObjectClass;
    }

    public RubyModule getJavaModule() {
        return this.javaModule;
    }

    public RubyClass getJavaInterfaceClass() {
        return this.javaInterfaceClass;
    }

    public RubyClass getNumericClass() {
        return this.numericClass;
    }

    public RubyClass getTimeClass() {
        return this.timeClass;
    }

    public RubyMap getClassMap() {
        return this.classMap;
    }
}

