/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.nodes.BlockNode;
import org.jruby.nodes.Node;
import org.jruby.runtime.ReflectionCallbackMethod;
import org.jruby.util.RubyPointer;

public class RubyMethod
extends RubyObject {
    private RubyClass receiverClass;
    private RubyObject receiver;
    private String methodId;
    private Node bodyNode;
    private RubyClass originalClass;
    private String originalId;
    static /* synthetic */ Class class$org$jruby$RubyMethod;

    public RubyMethod(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createMethodClass(Ruby ruby) {
        ReflectionCallbackMethod arity = new ReflectionCallbackMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "arity");
        ReflectionCallbackMethod call = new ReflectionCallbackMethod(class$org$jruby$RubyMethod == null ? (class$org$jruby$RubyMethod = RubyMethod.class$("org.jruby.RubyMethod")) : class$org$jruby$RubyMethod, "call", true);
        RubyClass methodClass = ruby.defineClass("Method", ruby.getClasses().getObjectClass());
        methodClass.defineMethod("arity", arity);
        methodClass.defineMethod("[]", call);
        methodClass.defineMethod("call", call);
        return methodClass;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public void setBodyNode(Node bodyNode) {
        this.bodyNode = bodyNode;
    }

    public String getMethodId() {
        return this.methodId;
    }

    public void setMethodId(String methodId) {
        this.methodId = methodId;
    }

    public RubyClass getOriginalClass() {
        return this.originalClass;
    }

    public void setOriginalClass(RubyClass originalClass) {
        this.originalClass = originalClass;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public RubyObject getReceiver() {
        return this.receiver;
    }

    public void setReceiver(RubyObject receiver) {
        this.receiver = receiver;
    }

    public RubyClass getReceiverClass() {
        return this.receiverClass;
    }

    public void setReceiverClass(RubyClass receiverClass) {
        this.receiverClass = receiverClass;
    }

    public RubyObject call(RubyObject[] args) {
        this.getRuby().getIter().push(this.getRuby().isBlockGiven() ? 1 : 0);
        RubyObject result = this.getReceiverClass().call0(this.getReceiver(), this.getMethodId(), new RubyPointer(args), this.getBodyNode(), false);
        this.getRuby().getIter().pop();
        return result;
    }

    public RubyFixnum arity() {
        switch (this.bodyNode.getType()) {
            case 2: {
                return RubyFixnum.newFixnum(this.getRuby(), -1L);
            }
            case 41: {
                return RubyFixnum.newFixnum(this.getRuby(), -1L);
            }
            case 90: {
                return RubyFixnum.one(this.getRuby());
            }
            case 50: {
                return RubyFixnum.zero(this.getRuby());
            }
        }
        Node body = this.bodyNode.getNextNode();
        if (body instanceof BlockNode) {
            body = body.getHeadNode();
        }
        if (body == null) {
            return RubyFixnum.zero(this.getRuby());
        }
        int n = body.getCount();
        if (body.getOptNode() != null || body.getRest() != -1) {
            n = -n - 1;
        }
        return RubyFixnum.newFixnum(this.getRuby(), n);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Nil
    extends RubyMethod {
        public Nil(Ruby ruby) {
            super(ruby, ruby.getClasses().getNilClass());
        }
    }
}

