/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIncludedClass;
import org.jruby.RubyMethod;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RubyBugException;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.nodes.CRefNode;
import org.jruby.nodes.FBodyNode;
import org.jruby.nodes.MethodNode;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeFactory;
import org.jruby.nodes.ZSuperNode;
import org.jruby.nodes.types.CallableNode;
import org.jruby.runtime.CacheEntry;
import org.jruby.runtime.Callback;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ReflectionCallbackMethod;
import org.jruby.runtime.RubyFrame;
import org.jruby.runtime.RubyIter;
import org.jruby.util.IdUtil;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyMapMethod;
import org.jruby.util.RubyPointer;

public class RubyModule
extends RubyObject {
    private RubyClass superClass;
    private RubyMap methods = new RubyHashMap();
    static /* synthetic */ Class class$org$jruby$RubyModule;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyModule(Ruby ruby) {
        this(ruby, null);
    }

    public RubyModule(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, null);
    }

    public RubyModule(Ruby ruby, RubyClass rubyClass, RubyClass superClass) {
        super(ruby, rubyClass);
        this.superClass = superClass;
    }

    public RubyClass getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(RubyClass superClass) {
        this.superClass = superClass;
    }

    public RubyMap getMethods() {
        return this.methods;
    }

    public void setMethods(RubyMap methods) {
        this.methods = methods;
    }

    public boolean isModule() {
        return true;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isIncluded() {
        return false;
    }

    public static void createModuleClass(RubyClass moduleClass) {
        ReflectionCallbackMethod op_eqq = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_eqq", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod op_cmp = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_cmp", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod op_lt = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_lt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod op_le = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_le", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod op_gt = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_gt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod op_ge = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "op_ge", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod clone = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbClone");
        ReflectionCallbackMethod dup = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "dup");
        ReflectionCallbackMethod to_s = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "to_s");
        ReflectionCallbackMethod included_modules = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "included_modules");
        ReflectionCallbackMethod name = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "name");
        ReflectionCallbackMethod ancestors = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "ancestors");
        ReflectionCallbackMethod attr = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, true);
        ReflectionCallbackMethod attr_reader = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr_reader", true);
        ReflectionCallbackMethod attr_writer = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr_writer", true);
        ReflectionCallbackMethod attr_accessor = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "attr_accessor", true);
        ReflectionCallbackMethod newModule = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "newModule", false, true);
        ReflectionCallbackMethod initialize = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "initialize", true);
        ReflectionCallbackMethod instance_methods = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "instance_methods", true);
        ReflectionCallbackMethod public_instance_methods = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "instance_methods", true);
        ReflectionCallbackMethod protected_instance_methods = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "protected_instance_methods", true);
        ReflectionCallbackMethod private_instance_methods = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "private_instance_methods", true);
        ReflectionCallbackMethod constants = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "constants");
        ReflectionCallbackMethod const_get = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "const_get", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod const_set = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "const_set", new Class[]{class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject});
        ReflectionCallbackMethod const_defined = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "const_defined", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod class_variables = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "class_variables");
        ReflectionCallbackMethod remove_class_variable = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "remove_class_variable", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod append_features = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "append_features", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule);
        ReflectionCallbackMethod extend_object = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "extend_object", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod include = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "include", true);
        ReflectionCallbackMethod rbPublic = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbPublic", true);
        ReflectionCallbackMethod rbProtected = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbProtected", true);
        ReflectionCallbackMethod rbPrivate = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "rbPrivate", true);
        ReflectionCallbackMethod module_function = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "module_function", true);
        ReflectionCallbackMethod method_defined = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "method_defined", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod public_class_method = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "public_class_method", true);
        ReflectionCallbackMethod private_class_method = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "private_class_method", true);
        ReflectionCallbackMethod module_eval = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "module_eval", true);
        ReflectionCallbackMethod remove_method = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "remove_method", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod undef_method = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "undef_method", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject);
        ReflectionCallbackMethod alias_method = new ReflectionCallbackMethod(class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyModule.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule, "alias_method", new Class[]{class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyModule.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject});
        moduleClass.defineMethod("===", op_eqq);
        moduleClass.defineMethod("<=>", op_cmp);
        moduleClass.defineMethod("<", op_lt);
        moduleClass.defineMethod("<=", op_le);
        moduleClass.defineMethod(">", op_gt);
        moduleClass.defineMethod(">=", op_ge);
        moduleClass.defineMethod("clone", clone);
        moduleClass.defineMethod("dup", dup);
        moduleClass.defineMethod("to_s", to_s);
        moduleClass.defineMethod("included_modules", included_modules);
        moduleClass.defineMethod("name", name);
        moduleClass.defineMethod("ancestors", ancestors);
        moduleClass.definePrivateMethod("attr", attr);
        moduleClass.definePrivateMethod("attr_reader", attr_reader);
        moduleClass.definePrivateMethod("attr_writer", attr_writer);
        moduleClass.definePrivateMethod("attr_accessor", attr_accessor);
        moduleClass.defineSingletonMethod("new", newModule);
        moduleClass.defineMethod("initialize", initialize);
        moduleClass.defineMethod("instance_methods", instance_methods);
        moduleClass.defineMethod("public_instance_methods", public_instance_methods);
        moduleClass.defineMethod("protected_instance_methods", protected_instance_methods);
        moduleClass.defineMethod("private_instance_methods", private_instance_methods);
        moduleClass.defineMethod("constants", constants);
        moduleClass.defineMethod("const_get", const_get);
        moduleClass.defineMethod("const_set", const_set);
        moduleClass.defineMethod("const_defined?", const_defined);
        moduleClass.definePrivateMethod("method_added", CallbackFactory.getNilMethod());
        moduleClass.defineMethod("class_variables", class_variables);
        moduleClass.definePrivateMethod("remove_class_variable", remove_class_variable);
        moduleClass.definePrivateMethod("append_features", append_features);
        moduleClass.definePrivateMethod("extend_object", extend_object);
        moduleClass.definePrivateMethod("include", include);
        moduleClass.definePrivateMethod("public", rbPublic);
        moduleClass.definePrivateMethod("protected", rbProtected);
        moduleClass.definePrivateMethod("private", rbPrivate);
        moduleClass.definePrivateMethod("module_function", module_function);
        moduleClass.defineMethod("method_defined?", method_defined);
        moduleClass.defineMethod("public_class_method", public_class_method);
        moduleClass.defineMethod("private_class_method", private_class_method);
        moduleClass.defineMethod("module_eval", module_eval);
        moduleClass.defineMethod("class_eval", module_eval);
        moduleClass.defineMethod("remove_method", remove_method);
        moduleClass.defineMethod("undef_method", undef_method);
        moduleClass.defineMethod("alias_method", alias_method);
    }

    public RubyString getClassname() {
        RubyString path = null;
        RubyModule module = this;
        while (module.isIncluded() || module.isSingleton()) {
            module = module.getSuperClass();
        }
        if (module == null) {
            module = this.getRuby().getClasses().getObjectClass();
        }
        if ((path = (RubyString)this.getInstanceVariables().get("__classpath__")) == null && this.getInstanceVariables().get("__classid__") != null) {
            path = RubyString.newString(this.getRuby(), (String)this.getInstanceVariables().get("__classid__"));
            this.getInstanceVariables().put("__classpath__", path);
            this.getInstanceVariables().remove("__classid__");
        }
        if (path == null) {
            return module.findClassPath();
        }
        return path;
    }

    public RubyString findClassPath() {
        FindClassPathResult arg = new FindClassPathResult();
        arg.klass = this;
        arg.track = this.getRuby().getClasses().getObjectClass();
        arg.prev = null;
        if (this.getRuby().getClasses().getObjectClass().getInstanceVariables() != null) {
            this.getRuby().getClasses().getObjectClass().getInstanceVariables().foreach(new FindClassPathMapMethod(), arg);
        }
        if (arg.name == null) {
            this.getRuby().getClasses().getClassMap().foreach(new FindClassPathMapMethod(), arg);
        }
        if (arg.name != null) {
            this.getInstanceVariables().put("__classpath__", arg.path);
            return arg.path;
        }
        return RubyString.nilString(this.getRuby());
    }

    public RubyIncludedClass newIncludeClass(RubyClass superClass) {
        return new RubyIncludedClass(this.getRuby(), superClass, this);
    }

    public void setName(String name) {
        this.getInstanceVariables().put("__classid__", name);
    }

    public void setClassPath(RubyModule under, String name) {
        RubyString value = null;
        if (under == this.getRuby().getClasses().getObjectClass()) {
            value = RubyString.newString(this.getRuby(), name);
        } else {
            value = (RubyString)under.getClassPath().dup();
            value.cat("::");
            value.cat(name);
        }
        this.getInstanceVariables().put("__classpath__", value);
    }

    public RubyString getClassPath() {
        RubyString path = this.getClassname();
        if (path != null) {
            return path;
        }
        String s = "Module";
        if (this.isClass()) {
            s = "Class";
        }
        return RubyString.newString(this.getRuby(), "<" + s + " 01x" + Integer.toHexString(System.identityHashCode(this)) + ">");
    }

    public RubyModule getClassVarSingleton() {
        return this;
    }

    public void setClassVar(String name, RubyObject value) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                if (tmp.isTaint() && this.getRuby().getSafeLevel() >= 4) {
                    throw new RubySecurityException(this.getRuby(), "Insecure: can't modify class variable");
                }
                tmp.getInstanceVariables().put(name, value);
            }
            tmp = tmp.getSuperClass();
        }
        throw new NameError(this.getRuby(), "uninitialized class variable " + name + " in " + this.toName());
    }

    public void declareClassVar(String name, RubyObject value) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                if (tmp.isTaint() && this.getRuby().getSafeLevel() >= 4) {
                    throw new RubySecurityException(this.getRuby(), "Insecure: can't modify class variable");
                }
                tmp.getInstanceVariables().put(name, value);
            }
            tmp = tmp.getSuperClass();
        }
        this.setAv(name, value, false);
    }

    public RubyObject getClassVar(String name) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                return (RubyObject)tmp.getInstanceVariables().get(name);
            }
            tmp = tmp.getSuperClass();
        }
        throw new NameError(this.getRuby(), "uninitialized class variable " + name + " in " + this.toName());
    }

    public boolean isClassVarDefined(String name) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                return true;
            }
            tmp = tmp.getSuperClass();
        }
        return false;
    }

    public void setConstant(String name, RubyObject value) {
        this.setAv(name, value, true);
    }

    public RubyObject getConstant(String name) {
        boolean mod_retry = false;
        RubyModule tmp = this;
        while (true) {
            if (tmp != null) {
                if (tmp.getInstanceVariables().get(name) != null) {
                    return (RubyObject)tmp.getInstanceVariables().get(name);
                }
                if (tmp == this.getRuby().getClasses().getObjectClass() && this.getRuby().getTopConstant(name) != null) {
                    return this.getRuby().getTopConstant(name);
                }
                tmp = tmp.getSuperClass();
                continue;
            }
            if (mod_retry || !this.isModule()) break;
            mod_retry = true;
            tmp = this.getRuby().getClasses().getObjectClass();
        }
        String javaClassName = (String)this.getRuby().getJavaSupport().getRenamedJavaClasses().get(name);
        if (javaClassName == null) {
            javaClassName = name;
        }
        try {
            Class javaClass = this.getRuby().getJavaSupport().loadJavaClass(RubyString.newString(this.getRuby(), javaClassName));
            return this.getRuby().getJavaSupport().loadClass(javaClass, null);
        }
        catch (NameError excptn) {
            if (this != this.getRuby().getClasses().getObjectClass()) {
                throw new NameError(this.getRuby(), "uninitialized constant " + name + " at " + this.getClassPath().getValue());
            }
            throw new NameError(this.getRuby(), "uninitialized constant " + name);
        }
    }

    public void includeModule(RubyModule module) {
        if (module == null || module == this) {
            return;
        }
        RubyModule type = this;
        block0: while (module != null) {
            RubyClass includedModule = type.getSuperClass();
            while (includedModule != null) {
                if (includedModule.isIncluded() && includedModule.getMethods() == module.getMethods()) {
                    module = module.getSuperClass();
                    continue block0;
                }
                includedModule = includedModule.getSuperClass();
            }
            type.setSuperClass(module.newIncludeClass(type.getSuperClass()));
            type = type.getSuperClass();
            module = module.getSuperClass();
        }
    }

    protected void setAv(String name, RubyObject value, boolean constant) {
        String dest;
        String string = dest = constant ? "constant" : "class variable";
        if (!this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't set " + dest);
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "class/module");
        }
        if (!constant || this.getInstanceVariables().get(name) != null) {
            // empty if block
        }
        if (this.getInstanceVariables() == null) {
            this.setInstanceVariables(new RubyHashMap());
        }
        this.getInstanceVariables().put(name, value);
    }

    public void addMethod(String name, Node node, int noex) {
        if (this == this.getRuby().getClasses().getObjectClass()) {
            this.getRuby().secure(4);
        }
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't define method");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "class/module");
        }
        Node body = new NodeFactory(this.getRuby()).newMethod(node, noex);
        this.getMethods().put(name, body);
    }

    public void defineMethod(String name, Callback method) {
        int noex = name.equals("initialize") ? 2 : 0;
        this.addMethod(name, new NodeFactory(this.getRuby()).newCFunc(method), noex | 1);
    }

    public void defineMethodId(String name, Callback method) {
        this.addMethod(name, new NodeFactory(this.getRuby()).newCFunc(method), 1);
    }

    public void defineProtectedMethod(String name, Callback method) {
        this.addMethod(name, new NodeFactory(this.getRuby()).newCFunc(method), 5);
    }

    public void definePrivateMethod(String name, Callback method) {
        this.addMethod(name, new NodeFactory(this.getRuby()).newCFunc(method), 3);
    }

    public void undefMethod(String name) {
        this.addMethod(name, null, 1);
    }

    protected void testFrozen() {
        String desc = "something(?!)";
        if (this.isFrozen()) {
            if (this.isSingleton()) {
                desc = "object";
            } else if (this.isIncluded() || this.isModule()) {
                desc = "module";
            } else if (this.isClass()) {
                desc = "class";
            }
            throw new RubyFrozenException(this.getRuby(), desc);
        }
    }

    public void undef(String name) {
        MethodNode methodNode;
        Ruby ruby = this.getRuby();
        if (this == ruby.getClasses().getObjectClass()) {
            ruby.secure(4);
        }
        if (ruby.getSafeLevel() >= 4 && !this.isTaint()) {
            throw new SecurityException("Insecure: can't undef");
        }
        this.testFrozen();
        if (name.equals("__id__") || name.equals("__send__")) {
            // empty if block
        }
        if ((methodNode = this.searchMethod(name)) == null || methodNode.getBodyNode() == null) {
            String s0 = " class";
            RubyModule c = this;
            if (c.isSingleton()) {
                RubyObject obj = this.getInstanceVar("__attached__");
                if (obj instanceof RubyModule) {
                    c = (RubyModule)obj;
                    s0 = "";
                }
            } else if (c.isModule()) {
                s0 = " module";
            }
            throw new NameError(ruby, ruby.getSourceFile() + ":" + ruby.getSourceLine() + " undefined method " + name + " for" + s0 + " '" + c.toName() + "'");
        }
        this.getRuby().getMethodCache().clearByName(name);
        this.addMethod(name, null, 0);
    }

    public void defineModuleFunction(String name, Callback method) {
        this.definePrivateMethod(name, method);
        this.defineSingletonMethod(name, method);
    }

    public void defineAlias(String newName, String oldName) {
        this.aliasMethod(newName, oldName);
    }

    public void defineAttribute(String name, boolean read, boolean write) {
        this.addAttribute(name, read, write, true);
    }

    public boolean isConstantDefined(String name) {
        RubyModule tmp = this;
        while (tmp != null) {
            if (tmp.getInstanceVariables() != null && tmp.getInstanceVariables().get(name) != null) {
                return true;
            }
            tmp = tmp.getSuperClass();
        }
        if (this.isModule()) {
            return this.getRuby().getClasses().getObjectClass().isConstantDefined(name);
        }
        if (this.getRuby().isClassDefined(name)) {
            return true;
        }
        return this.getRuby().isAutoloadDefined(name);
    }

    public MethodNode searchMethod(String name) {
        MethodNode body = (MethodNode)this.getMethods().get(name);
        if (body == null) {
            if (this.getSuperClass() != null) {
                return this.getSuperClass().searchMethod(name);
            }
            return null;
        }
        body.setMethodOrigin(this);
        return body;
    }

    public GetMethodBodyResult getMethodBody(String name, int noex) {
        GetMethodBodyResult result = new GetMethodBodyResult(this, name, noex);
        MethodNode methodNode = this.searchMethod(name);
        if (methodNode == null || methodNode.getBodyNode() == null) {
            this.getRuby().getMethodCache().saveUndefinedEntry(this, name);
            return null;
        }
        CacheEntry ent = new CacheEntry(this, methodNode.getNoex());
        Node body = methodNode.getBodyNode();
        if (body instanceof FBodyNode) {
            FBodyNode fbody = (FBodyNode)body;
            ent.setName(name);
            ent.setOrigin((RubyModule)fbody.getOrigin());
            ent.setOriginalName(fbody.getMId());
            ent.setMethod(fbody.getHeadNode());
            result.setRecvClass((RubyModule)fbody.getOrigin());
            result.setId(fbody.getMId());
            body = fbody.getHeadNode();
        } else {
            ent.setName(name);
            ent.setOriginalName(name);
            ent.setOrigin(methodNode.getMethodOrigin());
            ent.setMethod(body);
            result.setRecvClass(methodNode.getMethodOrigin());
        }
        this.getRuby().getMethodCache().saveEntry(this, name, ent);
        result.setNoex(ent.getNoex());
        result.setBody(body);
        return result;
    }

    public RubyObject call(RubyObject recv, String name, RubyPointer args, int scope) {
        Node body;
        CacheEntry ent = this.getRuby().getMethodCache().getEntry(this, name);
        RubyModule klass = this;
        if (ent != null) {
            if (ent.getMethod() == null) {
                RubyPointer newArgs = new RubyPointer();
                newArgs.add(RubySymbol.newSymbol(this.getRuby(), name));
                if (args != null) {
                    newArgs.addAll(args);
                }
                return recv.funcall("method_missing", newArgs);
            }
            klass = ent.getOrigin();
            name = ent.getOriginalName();
            int noex = ent.getNoex();
            body = ent.getMethod();
        } else {
            GetMethodBodyResult gmbr = this.getMethodBody(name, 0);
            if (gmbr == null || gmbr.getBody() == null) {
                if (scope == 3) {
                    throw new NameError(this.getRuby(), "super: no superclass method '" + name + "'");
                }
                RubyPointer newArgs = new RubyPointer();
                newArgs.add(RubySymbol.newSymbol(this.getRuby(), name));
                if (args != null) {
                    newArgs.addAll(args);
                }
                return recv.funcall("method_missing", newArgs);
            }
            klass = gmbr.getRecvClass();
            name = gmbr.getId();
            int noex = gmbr.getNoex();
            body = gmbr.getBody();
        }
        return klass.call0(recv, name, args, body, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject call0(RubyObject recv, String name, RubyPointer args, Node body, boolean noSuper) {
        Ruby ruby = this.getRuby();
        RubyIter lIter = ruby.getIter();
        if (lIter.getIter() == 1) {
            lIter.push(2);
        } else {
            lIter.push(0);
        }
        RubyFrame frame = ruby.getRubyFrame();
        frame.push();
        frame.setLastFunc(name);
        frame.setLastClass(noSuper ? null : this);
        frame.setSelf(recv);
        frame.setArgs(args);
        try {
            RubyObject rubyObject = ((CallableNode)((Object)body)).call(ruby, recv, name, args, noSuper);
            Object var11_10 = null;
            ruby.getRubyFrame().pop();
            lIter.pop();
            return rubyObject;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            ruby.getRubyFrame().pop();
            lIter.pop();
            throw throwable;
        }
    }

    public void aliasMethod(String name, String oldName) {
        this.testFrozen();
        if (oldName.equals(name)) {
            return;
        }
        if (this == this.getRuby().getClasses().getObjectClass()) {
            this.getRuby().secure(4);
        }
        MethodNode methodNode = this.searchMethod(oldName);
        RubyModule origin = null;
        if ((methodNode == null || methodNode.getBodyNode() == null) && this.isModule()) {
            methodNode = this.getRuby().getClasses().getObjectClass().searchMethod(oldName);
            origin = methodNode.getMethodOrigin();
        }
        if (methodNode == null || methodNode.getBodyNode() == null) {
            return;
        }
        origin = methodNode.getMethodOrigin();
        Node body = methodNode.getBodyNode();
        if (body instanceof FBodyNode) {
            oldName = body.getMId();
            origin = (RubyModule)body.getOrigin();
            body = body.getBodyNode();
        }
        NodeFactory nf = new NodeFactory(this.getRuby());
        this.getRuby().getMethodCache().clearByName(name);
        this.getMethods().put(name, nf.newMethod(nf.newFBody(body, oldName, origin), methodNode.getNoex()));
    }

    public void removeMethod(String name) {
        if (this == this.getRuby().getClasses().getObjectClass()) {
            this.getRuby().secure(4);
        }
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't remove method");
        }
        if (this.isFrozen()) {
            // empty if block
        }
        if (this.getMethods().remove(name) == null) {
            throw new NameError(this.getRuby(), "method '" + name + "' not defined in " + this.toName());
        }
        this.getRuby().getMethodCache().clearByName(name);
    }

    public RubyClass defineClassUnder(String name, RubyClass superClass) {
        RubyClass newClass = this.getRuby().defineClass(name, superClass);
        this.setConstant(name, newClass);
        newClass.setClassPath(this, name);
        return newClass;
    }

    public RubyModule defineModuleUnder(String name) {
        RubyModule newModule = this.getRuby().defineModule(name);
        this.setConstant(name, newModule);
        newModule.setClassPath(this, name);
        return newModule;
    }

    public String toName() {
        if (this == this.getRuby().getClasses().getNilClass()) {
            return "NilClass";
        }
        if (this == this.getRuby().getClasses().getTrueClass()) {
            return "TrueClass";
        }
        if (this == this.getRuby().getClasses().getFalseClass()) {
            return "FalseClass";
        }
        return this.getClassPath().getValue();
    }

    public void defineConstant(String name, RubyObject value) {
        if (this == this.getRuby().getClasses().getClassClass()) {
            this.getRuby().secure(4);
        }
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuby(), "bad constant name " + name);
        }
        this.setConstant(name, value);
    }

    public RubyObject removeCvar(RubyObject name) {
        if (!IdUtil.isClassVariable(name.toId())) {
            throw new NameError(this.getRuby(), "wrong class variable name " + name.toId());
        }
        if (!this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't remove class variable");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "class/module");
        }
        RubyObject value = (RubyObject)this.getInstanceVariables().remove(name.toId());
        if (value != null) {
            return value;
        }
        if (this.isClassVarDefined(name.toId())) {
            throw new NameError(this.getRuby(), "cannot remove " + name.toId() + " for " + this.toName());
        }
        throw new NameError(this.getRuby(), "class variable " + name.toId() + " not defined for " + this.toName());
    }

    public void defineClassVariable(String name, RubyObject value) {
        if (!IdUtil.isClassVariable(name)) {
            throw new NameError(this.getRuby(), "wrong class variable name " + name);
        }
        this.declareClassVar(name, value);
    }

    public void addAttribute(String name, boolean read, boolean write, boolean ex) {
        int noex = 0;
        if (ex) {
            noex = this.getRuby().getActMethodScope() == 1 ? 2 : (this.getRuby().getActMethodScope() == 2 ? 4 : 0);
        }
        String attrIV = "@" + name;
        if (read) {
            this.getRuby().getMethodCache().clearByName(name);
            this.addMethod(name, new NodeFactory(this.getRuby()).newIVar(attrIV), noex);
            this.funcall("method_added", RubySymbol.newSymbol(this.getRuby(), name));
        }
        if (write) {
            name = name + "=";
            this.getRuby().getMethodCache().clearByName(name);
            this.addMethod(name, new NodeFactory(this.getRuby()).newAttrSet(attrIV), noex);
            this.funcall("method_added", RubySymbol.newSymbol(this.getRuby(), name));
        }
    }

    public RubyArray methodList(boolean option, RubyMapMethod method) {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyModule klass = this;
        while (klass != null) {
            klass.getMethods().foreach(method, ary);
            if (!option) break;
            klass = klass.getSuperClass();
        }
        Iterator iter = ary.getList().iterator();
        while (iter.hasNext()) {
            if (this.getRuby().getNil() != iter.next()) continue;
            iter.remove();
            iter.next();
        }
        return ary;
    }

    public RubyArray getConstOf(RubyArray ary) {
        RubyModule klass = this;
        while (klass != null) {
            klass.getConstAt(ary);
            klass = klass.getSuperClass();
        }
        return ary;
    }

    public RubyArray getConstAt(RubyArray ary) {
        this.constantNamesToArray(ary, this.getInstanceVariables());
        if (this == this.getRuby().getClasses().getObjectClass()) {
            this.constantNamesToArray(ary, this.getRuby().getClasses().getClassMap());
        }
        return ary;
    }

    private void constantNamesToArray(RubyArray ary, Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            RubyString name;
            String key = (String)iter.next();
            if (!IdUtil.isConstant(key) || !ary.includes(name = RubyString.newString(this.getRuby(), key)).isFalse()) continue;
            ary.push(name);
        }
    }

    public void setMethodVisibility(RubyObject[] methods, int noex) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        int i = 0;
        while (i < methods.length) {
            this.exportMethod(methods[i].toId(), noex);
            ++i;
        }
    }

    public void exportMethod(String name, int noex) {
        if (this == this.getRuby().getClasses().getObjectClass()) {
            this.getRuby().secure(4);
        }
        MethodNode body = this.searchMethod(name);
        RubyModule origin = body.getMethodOrigin();
        if (body == null && this.isModule()) {
            body = this.getRuby().getClasses().getObjectClass().searchMethod(name);
            origin = body.getMethodOrigin();
        }
        if (body == null) {
            // empty if block
        }
        if (body.getNoex() != noex) {
            if (this == origin) {
                body.setNoex(noex);
            } else {
                this.getRuby().getMethodCache().clearByName(name);
                this.addMethod(name, new NodeFactory(this.getRuby()).newZSuper(), noex);
            }
        }
    }

    private boolean isMethodBound(String name, int ex) {
        CacheEntry entry = this.getRuby().getMethodCache().getEntry(this, name);
        if (entry != null) {
            if (ex != 0 && (entry.getNoex() & 2) != 0) {
                return false;
            }
            return entry.getMethod() != null;
        }
        GetMethodBodyResult gmbr = this.getMethodBody(name, ex);
        if (gmbr != null) {
            return ex == 0 || (gmbr.getNoex() & 2) == 0;
        }
        return false;
    }

    public boolean isMethodDefined(String name) {
        return this.isMethodBound(name, 1);
    }

    /*
     * Unable to fully structure code
     */
    public RubyObject newMethod(RubyObject recv, String name, RubyClass methodClass) {
        originalClass = (RubyClass)this;
        originalName = name;
        gmbr = this.getMethodBody(name, 0);
        if (gmbr != null) ** GOTO lbl8
        return this.getRuby().getNil();
lbl-1000:
        // 1 sources

        {
            if ((gmbr = gmbr.getRecvClass().getSuperClass().getMethodBody(gmbr.getId(), 0)) != null) continue;
            return this.getRuby().getNil();
lbl8:
            // 2 sources

            ** while (gmbr.getBody() instanceof ZSuperNode)
        }
lbl9:
        // 1 sources

        newMethod = new RubyMethod(this.getRuby(), methodClass);
        newMethod.setReceiverClass((RubyClass)gmbr.getRecvClass());
        newMethod.setReceiver(recv);
        newMethod.setMethodId(gmbr.getId());
        newMethod.setBodyNode(gmbr.getBody());
        newMethod.setOriginalClass(originalClass);
        newMethod.setOriginalId(originalName);
        return newMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject executeUnder(Callback method, RubyObject[] args) {
        this.getRuby().pushClass();
        this.getRuby().setRubyClass(this);
        this.getRuby().getRubyFrame().push();
        RubyFrame frame = this.getRuby().getRubyFrame().getPrev();
        this.getRuby().getRubyFrame().setLastFunc(frame.getLastFunc());
        this.getRuby().getRubyFrame().setLastClass(frame.getLastClass());
        this.getRuby().getRubyFrame().setArgs(frame.getArgs());
        if (this.getRuby().getCBase() != this) {
            this.getRuby().getRubyFrame().setCbase(new CRefNode(this, this.getRuby().getRubyFrame().getCbase()));
        }
        this.getRuby().getCRef().push(this);
        RubyObject result = null;
        try {
            result = method.execute(this, args, this.getRuby());
            Object var6_5 = null;
            this.getRuby().getCRef().pop();
            this.getRuby().getRubyFrame().pop();
            this.getRuby().popClass();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.getRuby().getCRef().pop();
            this.getRuby().getRubyFrame().pop();
            this.getRuby().popClass();
            throw throwable;
        }
        return result;
    }

    public static RubyModule newModule(Ruby ruby) {
        RubyModule newModule = new RubyModule(ruby, ruby.getClasses().getModuleClass());
        return newModule;
    }

    public RubyString name() {
        RubyString path = this.getClassname();
        if (path != null) {
            return (RubyString)path.dup();
        }
        return RubyString.newString(this.getRuby(), "");
    }

    public RubyArray class_variables() {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyModule rbModule = this;
        if (this.isSingleton()) {
            rbModule = rbModule.getInstanceVar("__atached__").getClassVarSingleton();
        }
        while (rbModule != null) {
            if (rbModule.getInstanceVariables() != null) {
                Iterator iter = rbModule.getInstanceVariables().keySet().iterator();
                while (iter.hasNext()) {
                    RubyString kval;
                    String id = (String)iter.next();
                    if (!IdUtil.isClassVariable(id) || !ary.includes(kval = RubyString.newString(this.getRuby(), id)).isFalse()) continue;
                    ary.push(kval);
                }
            }
            rbModule = rbModule.getSuperClass();
        }
        return ary;
    }

    public RubyObject rbClone() {
        RubyModule clone = new RubyModule(this.getRuby(), this.getRubyClass(), this.getSuperClass());
        clone.setupClone(this);
        if (this.getInstanceVariables() != null) {
            clone.setInstanceVariables(this.getInstanceVariables().cloneRubyMap());
        }
        if (this.getMethods() != null) {
            clone.setMethods(new RubyHashMap());
            this.getMethods().foreach(new RubyMapMethod(){
                NodeFactory nf;
                {
                    this.nf = new NodeFactory(RubyModule.this.getRuby());
                }

                public int execute(Object key, Object value, Object arg) {
                    MethodNode methodNode = (MethodNode)value;
                    ((RubyMap)arg).put(key, this.nf.newMethod(methodNode.getBodyNode(), methodNode.getNoex()));
                    return 0;
                }
            }, clone.getMethods());
        }
        return clone;
    }

    public RubyObject dup() {
        RubyModule dup = (RubyModule)this.rbClone();
        dup.setRubyClass(this.getRubyClass());
        return dup;
    }

    public RubyArray included_modules() {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyClass p = this.getSuperClass();
        while (p != null) {
            if (p.isIncluded()) {
                ary.push(((RubyObject)p).getRubyClass());
            }
            p = p.getSuperClass();
        }
        return ary;
    }

    public RubyArray ancestors() {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        RubyModule p = this;
        while (p != null) {
            if (!p.isSingleton()) {
                if (p.isIncluded()) {
                    ary.push(((RubyIncludedClass)p).getDelegate());
                } else {
                    ary.push(p);
                }
            }
            p = p.getSuperClass();
        }
        return ary;
    }

    public RubyString to_s() {
        return (RubyString)this.getClassPath().dup();
    }

    public RubyBoolean op_eqq(RubyObject obj) {
        return obj.kind_of(this);
    }

    public RubyBoolean op_le(RubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw new TypeError(this.getRuby(), "compared with non class/module");
        }
        RubyModule mod = this;
        while (mod != null) {
            if (mod.getMethods() == ((RubyModule)obj).getMethods()) {
                return this.getRuby().getTrue();
            }
            mod = mod.getSuperClass();
        }
        return this.getRuby().getFalse();
    }

    public RubyBoolean op_lt(RubyObject obj) {
        if (obj == this) {
            return this.getRuby().getFalse();
        }
        return this.op_le(obj);
    }

    public RubyBoolean op_ge(RubyObject obj) {
        if (!(obj instanceof RubyModule)) {
            throw new TypeError(this.getRuby(), "compared with non class/module");
        }
        return ((RubyModule)obj).op_le(this);
    }

    public RubyBoolean op_gt(RubyObject obj) {
        if (this == obj) {
            return this.getRuby().getFalse();
        }
        return this.op_ge(obj);
    }

    public RubyFixnum op_cmp(RubyObject obj) {
        if (this == obj) {
            return RubyFixnum.newFixnum(this.getRuby(), 0L);
        }
        if (!(obj instanceof RubyModule)) {
            throw new TypeError(this.getRuby(), "<=> requires Class or Module (" + this.getRubyClass().toName() + " given)");
        }
        if (this.op_le(obj).isTrue()) {
            return RubyFixnum.newFixnum(this.getRuby(), -1L);
        }
        return RubyFixnum.newFixnum(this.getRuby(), 1L);
    }

    public RubyObject initialize(RubyObject[] args) {
        return this.getRuby().getNil();
    }

    public static RubyModule newModule(Ruby ruby, RubyObject recv) {
        RubyModule mod = RubyModule.newModule(ruby);
        mod.setRubyClass((RubyClass)recv);
        ruby.getClasses().getModuleClass().callInit(null);
        return mod;
    }

    public RubyObject attr(RubyObject symbol, RubyObject[] args) {
        boolean writeable = false;
        if (args.length > 0) {
            writeable = args[0].isTrue();
        }
        this.addAttribute(symbol.toId(), true, writeable, true);
        return this.getRuby().getNil();
    }

    public RubyObject attr_reader(RubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            this.addAttribute(((RubySymbol)args[i]).toId(), true, false, true);
            ++i;
        }
        return this.getRuby().getNil();
    }

    public RubyObject attr_writer(RubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            this.addAttribute(((RubySymbol)args[i]).toId(), false, true, true);
            ++i;
        }
        return this.getRuby().getNil();
    }

    public RubyObject attr_accessor(RubyObject[] args) {
        int i = 0;
        while (i < args.length) {
            this.addAttribute(((RubySymbol)args[i]).toId(), true, true, true);
            ++i;
        }
        return this.getRuby().getNil();
    }

    public RubyObject const_get(RubySymbol symbol) {
        String name = symbol.toId();
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuby(), "wrong constant name " + name);
        }
        return this.getConstant(name);
    }

    public RubyObject const_set(RubySymbol symbol, RubyObject value) {
        String name = symbol.toId();
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuby(), "wrong constant name " + name);
        }
        this.setConstant(name, value);
        return value;
    }

    public RubyBoolean const_defined(RubySymbol symbol) {
        String name = symbol.toId();
        if (!IdUtil.isConstant(name)) {
            throw new NameError(this.getRuby(), "wrong constant name " + name);
        }
        return RubyBoolean.newBoolean(this.getRuby(), this.isConstantDefined(name));
    }

    public RubyArray instance_methods(RubyObject[] args) {
        boolean includeSuper = false;
        if (args.length > 0) {
            includeSuper = args[0].isTrue();
        }
        return this.methodList(includeSuper, new RubyMapMethod(){

            public int execute(Object key, Object value, Object arg) {
                String id = (String)key;
                MethodNode body = (MethodNode)value;
                RubyArray ary = (RubyArray)arg;
                if ((body.getNoex() & 6) == 0) {
                    RubyString name = RubyString.newString(RubyModule.this.getRuby(), id);
                    if (ary.includes(name).isFalse()) {
                        if (body.getBodyNode() == null) {
                            ary.push(RubyModule.this.getRuby().getNil());
                        }
                        ary.push(name);
                    }
                } else if (body.getBodyNode() != null && body.getBodyNode() instanceof ZSuperNode) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                }
                return 0;
            }
        });
    }

    public RubyArray protected_instance_methods(RubyObject[] args) {
        boolean includeSuper = false;
        if (args.length > 0) {
            includeSuper = args[0].isTrue();
        }
        return this.methodList(includeSuper, new RubyMapMethod(){

            public int execute(Object key, Object value, Object arg) {
                String id = (String)key;
                MethodNode body = (MethodNode)value;
                RubyArray ary = (RubyArray)arg;
                if (body.getBodyNode() == null) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                } else if ((body.getNoex() & 4) != 0) {
                    RubyString name = RubyString.newString(RubyModule.this.getRuby(), id);
                    if (ary.includes(name).isFalse()) {
                        ary.push(name);
                    }
                } else if (body.getBodyNode() instanceof ZSuperNode) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                }
                return 0;
            }
        });
    }

    public RubyArray private_instance_methods(RubyObject[] args) {
        boolean includeSuper = false;
        if (args.length > 0) {
            includeSuper = args[0].isTrue();
        }
        return this.methodList(includeSuper, new RubyMapMethod(){

            public int execute(Object key, Object value, Object arg) {
                String id = (String)key;
                MethodNode body = (MethodNode)value;
                RubyArray ary = (RubyArray)arg;
                if (body.getBodyNode() == null) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                } else if ((body.getNoex() & 2) != 0) {
                    RubyString name = RubyString.newString(RubyModule.this.getRuby(), id);
                    if (ary.includes(name).isFalse()) {
                        ary.push(name);
                    }
                } else if (body.getBodyNode() instanceof ZSuperNode) {
                    ary.push(RubyModule.this.getRuby().getNil());
                    ary.push(RubyString.newString(RubyModule.this.getRuby(), id));
                }
                return 0;
            }
        });
    }

    public RubyArray constants() {
        RubyArray ary = RubyArray.newArray(this.getRuby());
        return this.getConstOf(ary);
    }

    public RubyObject remove_class_variable(RubyObject name) {
        Object value;
        String id = name.toId();
        if (!IdUtil.isClassVariable(id)) {
            throw new NameError(this.getRuby(), "wrong class variable name " + id);
        }
        if (!this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't remove class variable");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "class/module");
        }
        if (this.getInstanceVariables() != null && (value = this.getInstanceVariables().remove(id)) != null) {
            return (RubyObject)value;
        }
        if (this.isClassVarDefined(id)) {
            throw new NameError(this.getRuby(), "cannot remove " + id + " for " + this.toName());
        }
        throw new NameError(this.getRuby(), "class variable " + id + " not defined for " + this.toName());
    }

    public RubyModule append_features(RubyModule module) {
        module.includeModule(this);
        return this;
    }

    public RubyObject extend_object(RubyObject obj) {
        obj.extendObject(this);
        return obj;
    }

    public RubyModule include(RubyObject[] modules) {
        int i = 0;
        while (i < modules.length) {
            modules[i].funcall("append_features", this);
            ++i;
        }
        return this;
    }

    public RubyModule rbPublic(RubyObject[] args) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuby().setActMethodScope(0);
        } else {
            this.setMethodVisibility(args, 0);
        }
        return this;
    }

    public RubyModule rbProtected(RubyObject[] args) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuby().setActMethodScope(2);
        } else {
            this.setMethodVisibility(args, 4);
        }
        return this;
    }

    public RubyModule rbPrivate(RubyObject[] args) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuby().setActMethodScope(1);
        } else {
            this.setMethodVisibility(args, 2);
        }
        return this;
    }

    public RubyModule module_function(RubyObject[] args) {
        if (this.getRuby().getSafeLevel() >= 4 && !this.isTaint()) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't change method visibility");
        }
        if (args.length == 0) {
            this.getRuby().setActMethodScope(5);
        } else {
            this.setMethodVisibility(args, 2);
            int i = 0;
            while (i < args.length) {
                String name = args[i].toId();
                MethodNode body = this.searchMethod(name);
                if (body == null || body.getBodyNode() == null) {
                    throw new RubyBugException("undefined method '" + name + "'; can't happen");
                }
                this.getRuby().getMethodCache().clearByName(name);
                this.getSingletonClass().addMethod(name, body.getBodyNode(), 0);
                this.funcall("singleton_added", RubySymbol.newSymbol(this.getRuby(), name));
                ++i;
            }
        }
        return this;
    }

    public RubyBoolean method_defined(RubyObject symbol) {
        return this.isMethodBound(symbol.toId(), 1) ? this.getRuby().getTrue() : this.getRuby().getFalse();
    }

    public RubyModule public_class_method(RubyObject[] args) {
        this.getRubyClass().setMethodVisibility(args, 0);
        return this;
    }

    public RubyModule private_class_method(RubyObject[] args) {
        this.getRubyClass().setMethodVisibility(args, 2);
        return this;
    }

    public RubyModule alias_method(RubyObject newId, RubyObject oldId) {
        this.aliasMethod(newId.toId(), oldId.toId());
        return this;
    }

    public RubyModule undef_method(RubyObject name) {
        this.undef(name.toId());
        return this;
    }

    public RubyObject module_eval(RubyObject[] args) {
        return this.specificEval(this, args);
    }

    public RubyModule remove_method(RubyObject name) {
        this.removeMethod(name.toId());
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class GetMethodBodyResult {
        private Node body;
        private RubyModule recvClass;
        private String id;
        private int noex;

        public GetMethodBodyResult(RubyModule recvClass, String id, int noex) {
            this.recvClass = recvClass;
            this.id = id;
            this.noex = noex;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public RubyModule getRecvClass() {
            return this.recvClass;
        }

        public void setRecvClass(RubyModule recvClass) {
            this.recvClass = recvClass;
        }

        public Node getBody() {
            return this.body;
        }

        public void setBody(Node body) {
            this.body = body;
        }

        public int getNoex() {
            return this.noex;
        }

        public void setNoex(int noex) {
            this.noex = noex;
        }
    }

    private class FindClassPathMapMethod
    implements RubyMapMethod {
        private FindClassPathMapMethod() {
        }

        public int execute(Object _key, Object _value, Object _res) {
            String key = (String)_key;
            if (_value instanceof String || _value == null) {
                return 0;
            }
            RubyObject value = (RubyObject)_value;
            FindClassPathResult res = (FindClassPathResult)_res;
            RubyString path = null;
            if (!IdUtil.isConstant(key)) {
                return 0;
            }
            if (res.path != null) {
                path = (RubyString)res.path.dup();
                path.cat("::");
                path.cat(key);
            } else {
                path = RubyString.newString(RubyModule.this.getRuby(), key);
            }
            if (value == res.klass) {
                res.name = key;
                res.path = path;
                return 1;
            }
            if (value.kind_of(RubyModule.this.getRuby().getClasses().getModuleClass()).isTrue()) {
                if (value.getInstanceVariables() == null) {
                    return 0;
                }
                FindClassPathResult list = res;
                while (list != null) {
                    if (list.track == value) {
                        return 0;
                    }
                    list = list.prev;
                }
                FindClassPathResult arg = new FindClassPathResult();
                arg.name = null;
                arg.path = path;
                arg.klass = res.klass;
                arg.track = value;
                arg.prev = res;
                value.getInstanceVariables().foreach(this, arg);
                if (arg.name != null) {
                    res.name = arg.name;
                    res.path = arg.path;
                    return 1;
                }
            }
            return 0;
        }
    }

    private static class FindClassPathResult {
        public String name;
        public RubyModule klass;
        public RubyString path;
        public RubyObject track;
        public FindClassPathResult prev;

        private FindClassPathResult() {
        }
    }
}

