/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.exceptions.RubyIndexException;
import org.jruby.runtime.CallbackFactory;

public class RubyRange
extends RubyObject {
    static /* synthetic */ Class class$org$jruby$RubyRange;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyRange(Ruby ruby) {
        super(ruby, ruby.getRubyClass("Range"));
    }

    public void init(RubyObject begin, RubyObject end, RubyBoolean exclusive) {
        if (!(begin instanceof RubyFixnum) || !(end instanceof RubyFixnum)) {
            try {
                begin.funcall("<=>", end);
            }
            catch (RaiseException rExcptn) {
                throw new RubyArgumentException(this.getRuby(), "bad value for range");
            }
        }
        this.setInstanceVar("begin", begin);
        this.setInstanceVar("end", end);
        this.setInstanceVar("excl", exclusive);
    }

    public static RubyClass createRangeClass(Ruby ruby) {
        RubyClass rangeClass = ruby.defineClass("Range", ruby.getClasses().getObjectClass());
        rangeClass.includeModule(ruby.getClasses().getEnumerableModule());
        rangeClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyRange.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        rangeClass.defineMethod("===", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "op_eqq", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyRange.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        rangeClass.defineMethod("first", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "first"));
        rangeClass.defineMethod("begin", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "first"));
        rangeClass.defineMethod("last", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "last"));
        rangeClass.defineMethod("end", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "last"));
        rangeClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "inspect"));
        rangeClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "inspect"));
        rangeClass.defineMethod("exclude_end?", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "exclude_end_p"));
        rangeClass.defineMethod("length", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "length"));
        rangeClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "length"));
        rangeClass.defineMethod("each", CallbackFactory.getMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "each"));
        rangeClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyRange == null ? (class$org$jruby$RubyRange = RubyRange.class$("org.jruby.RubyRange")) : class$org$jruby$RubyRange, "initialize"));
        return rangeClass;
    }

    public long[] getBeginLength(long limit, boolean truncate, boolean strict) {
        long begin = RubyNumeric.num2long(this.getInstanceVar("begin"));
        long end = RubyNumeric.num2long(this.getInstanceVar("end"));
        boolean excl = this.getInstanceVar("excl").isTrue();
        end += excl ? 0L : 1L;
        if (begin < 0L && (begin += limit) < 0L) {
            if (strict) {
                throw new RubyIndexException(this.getRuby(), "Index out of bounds: " + begin);
            }
            return null;
        }
        if (truncate && begin > limit) {
            if (strict) {
                throw new RubyIndexException(this.getRuby(), "Index out of bounds: " + begin);
            }
            return null;
        }
        if (truncate && end > limit) {
            end = limit;
        }
        if (end < 0L && (end += limit) < 0L) {
            if (strict) {
                throw new RubyIndexException(this.getRuby(), "Index out of bounds: " + end);
            }
            end = begin;
        }
        if (begin > end) {
            if (strict) {
                throw new RubyIndexException(this.getRuby(), "Malformed range");
            }
            end = begin;
        }
        return new long[]{begin, end - begin};
    }

    public static RubyRange newRange(Ruby ruby, RubyObject begin, RubyObject end, boolean exclusive) {
        RubyRange range = new RubyRange(ruby);
        range.init(begin, end, exclusive ? ruby.getTrue() : ruby.getFalse());
        return range;
    }

    public RubyObject initialize(RubyObject[] args) {
        if (this.isInstanceVarDefined("begin")) {
            throw new NameError(this.getRuby(), "'initialize' called twice.");
        }
        if (args.length == 3) {
            this.init(args[0], args[1], (RubyBoolean)args[2]);
        } else if (args.length == 2) {
            this.init(args[0], args[1], this.getRuby().getFalse());
        } else {
            throw new RubyArgumentException(this.getRuby(), "Wrong arguments. (anObject, anObject, aBoolean = false) excepted");
        }
        return this.getRuby().getNil();
    }

    public RubyObject first() {
        return this.getInstanceVar("begin");
    }

    public RubyObject last() {
        return this.getInstanceVar("end");
    }

    public RubyString inspect() {
        RubyString begStr = (RubyString)this.getInstanceVar("begin").funcall("to_s");
        RubyString endStr = (RubyString)this.getInstanceVar("end").funcall("to_s");
        begStr.cat(this.getInstanceVar("excl").isTrue() ? "..." : "..");
        begStr.concat(endStr);
        return begStr;
    }

    public RubyBoolean exclude_end_p() {
        if (this.getInstanceVar("excl").isTrue()) {
            return this.getRuby().getTrue();
        }
        return this.getRuby().getFalse();
    }

    public RubyObject length() {
        RubyObject begin = this.getInstanceVar("begin");
        RubyObject end = this.getInstanceVar("end");
        boolean exclusive = this.getInstanceVar("excl").isTrue();
        long size = 0L;
        if (begin.funcall(">", end).isTrue()) {
            return new RubyFixnum(this.getRuby(), 0L);
        }
        if (begin instanceof RubyFixnum && end instanceof RubyFixnum) {
            size = ((RubyNumeric)end).getLongValue() - ((RubyNumeric)begin).getLongValue();
            if (!exclusive) {
                ++size;
            }
        }
        return new RubyFixnum(this.getRuby(), size);
    }

    public RubyBoolean equal(RubyObject obj) {
        if (!(obj instanceof RubyRange)) {
            return this.getRuby().getFalse();
        }
        boolean result = this.getInstanceVar("begin").equals(obj.getInstanceVar("begin")) && this.getInstanceVar("end").equals(obj.getInstanceVar("end")) && this.getInstanceVar("excl").isTrue() == obj.getInstanceVar("excl").isTrue();
        return RubyBoolean.newBoolean(this.getRuby(), result);
    }

    public RubyBoolean op_eqq(RubyObject obj) {
        RubyObject beg = this.getInstanceVar("begin");
        RubyObject end = this.getInstanceVar("end");
        boolean excl = this.getInstanceVar("excl").isTrue();
        if (beg instanceof RubyFixnum && obj instanceof RubyFixnum && end instanceof RubyFixnum) {
            long o;
            long b = RubyNumeric.fix2long(beg);
            if (b <= (o = RubyNumeric.fix2long(obj))) {
                long e = RubyNumeric.fix2long(end);
                if (excl ? o < e : o <= e) {
                    return this.getRuby().getTrue();
                }
            }
            return this.getRuby().getFalse();
        }
        if (beg.funcall("<=", obj).isTrue() && (excl ? end.funcall(">", obj).isTrue() : end.funcall(">=", obj).isTrue())) {
            return this.getRuby().getTrue();
        }
        return this.getRuby().getFalse();
    }

    /*
     * Unable to fully structure code
     */
    public RubyObject each() {
        block7: {
            block10: {
                block9: {
                    block8: {
                        begin = this.getInstanceVar("begin");
                        end = this.getInstanceVar("end");
                        exclusive = this.getInstanceVar("excl").isTrue();
                        if (!(begin instanceof RubyFixnum) || !(end instanceof RubyFixnum)) break block8;
                        endLong = ((RubyNumeric)end).getLongValue();
                        i = ((RubyNumeric)begin).getLongValue();
                        if (!exclusive) {
                            ++endLong;
                        }
                        while (i < endLong) {
                            this.getRuby().yield(RubyFixnum.newFixnum(this.getRuby(), i));
                            ++i;
                        }
                        break block7;
                    }
                    if (!(begin instanceof RubyString)) break block9;
                    ((RubyString)begin).upto(end, exclusive);
                    break block7;
                }
                if (!begin.kind_of(this.getRuby().getClasses().getNumericClass()).isTrue()) break block10;
                if (!exclusive) {
                    end = end.funcall("+", RubyFixnum.one(this.getRuby()));
                }
                while (begin.funcall("<", end).isTrue()) {
                    this.getRuby().yield(begin);
                    begin = begin.funcall("+", RubyFixnum.one(this.getRuby()));
                }
                break block7;
            }
            v = begin;
            if (!exclusive) ** GOTO lbl45
            while (v.funcall("<", end).isTrue()) {
                if (!v.equals(end)) {
                    this.getRuby().yield(v);
                    v = v.funcall("succ");
                    continue;
                }
                break block7;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                this.getRuby().yield(v);
                if (v.equals(end)) break;
                v = v.funcall("succ");
lbl45:
                // 2 sources

                ** while (v.funcall((String)"<=", (RubyObject)end).isTrue())
            }
        }
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

