/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.exceptions.RubyBugException;
import org.jruby.exceptions.RubyIndexException;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.util.PrintfFormat;

public class RubyString
extends RubyObject {
    private static RubyModule pfClass;
    private String value;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jruby$RubyString;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyInteger;

    public RubyString(Ruby ruby) {
        this(ruby, (String)null);
    }

    public RubyString(Ruby ruby, String str) {
        this(ruby, ruby.getClasses().getStringClass(), str);
    }

    public RubyString(Ruby ruby, RubyClass rubyClass, String str) {
        super(ruby, rubyClass);
        this.value = str;
    }

    public static RubyString nilString(Ruby ruby) {
        return new RubyString(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    public Class getJavaClass() {
        return class$java$lang$String == null ? (class$java$lang$String = RubyString.class$("java.lang.String")) : class$java$lang$String;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String toString() {
        return this.getValue();
    }

    public static RubyClass createStringClass(Ruby ruby) {
        RubyClass stringClass = ruby.defineClass("String", ruby.getClasses().getObjectClass());
        stringClass.includeModule(ruby.getClasses().getComparableModule());
        stringClass.includeModule(ruby.getClasses().getEnumerableModule());
        stringClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "newInstance"));
        stringClass.defineMethod("initialize", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "replace", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "rbClone"));
        stringClass.defineMethod("dup", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "dup"));
        stringClass.defineMethod("<=>", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "op_cmp", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("===", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("eql?", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "hash"));
        stringClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "op_plus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "op_mul", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyString.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        stringClass.defineMethod("%", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "format", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("[]", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "aref"));
        stringClass.defineMethod("[]=", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "aset"));
        stringClass.defineMethod("length", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "length"));
        stringClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "length"));
        stringClass.defineMethod("empty?", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "empty"));
        stringClass.defineMethod("=~", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "match", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("~", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "match2"));
        stringClass.defineMethod("succ", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "succ"));
        stringClass.defineMethod("succ!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "succ_bang"));
        stringClass.defineMethod("next", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "succ"));
        stringClass.defineMethod("next!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "succ_bang"));
        stringClass.defineMethod("upto", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "upto", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("index", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "index"));
        stringClass.defineMethod("rindex", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "rindex"));
        stringClass.defineMethod("replace", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "replace", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("to_i", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "to_i"));
        stringClass.defineMethod("to_f", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "to_f"));
        stringClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "to_s"));
        stringClass.defineMethod("to_str", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "to_s"));
        stringClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "inspect"));
        stringClass.defineMethod("dump", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "dump"));
        stringClass.defineMethod("upcase", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "upcase"));
        stringClass.defineMethod("downcase", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "downcase"));
        stringClass.defineMethod("capitalize", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "capitalize"));
        stringClass.defineMethod("swapcase", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "swapcase"));
        stringClass.defineMethod("upcase!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "upcase_bang"));
        stringClass.defineMethod("downcase!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "downcase_bang"));
        stringClass.defineMethod("capitalize!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "capitalize_bang"));
        stringClass.defineMethod("swapcase!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "swapcase_bang"));
        stringClass.defineMethod("hex", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "hex"));
        stringClass.defineMethod("oct", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "oct"));
        stringClass.defineMethod("split", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "split"));
        stringClass.defineMethod("reverse", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "reverse"));
        stringClass.defineMethod("reverse!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "reverse_bang"));
        stringClass.defineMethod("concat", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "concat", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("<<", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "concat", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("intern", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "intern"));
        stringClass.defineMethod("include?", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "include", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("scan", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "scan", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("ljust", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "ljust", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("rjust", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "rjust", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("center", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "center", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyString.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        stringClass.defineMethod("sub", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "sub"));
        stringClass.defineMethod("gsub", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "gsub"));
        stringClass.defineMethod("chop", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "chop"));
        stringClass.defineMethod("chomp", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "chomp"));
        stringClass.defineMethod("strip", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "strip"));
        stringClass.defineMethod("sub!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "sub_bang"));
        stringClass.defineMethod("gsub!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "gsub_bang"));
        stringClass.defineMethod("chop!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "chop_bang"));
        stringClass.defineMethod("chomp!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "chomp_bang"));
        stringClass.defineMethod("strip!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "strip_bang"));
        stringClass.defineMethod("tr", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "tr"));
        stringClass.defineMethod("tr_s", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "tr_s"));
        stringClass.defineMethod("delete", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "delete"));
        stringClass.defineMethod("squeeze", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "squeeze"));
        stringClass.defineMethod("count", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "count"));
        stringClass.defineMethod("tr!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "tr_bang"));
        stringClass.defineMethod("tr_s!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "tr_s_bang"));
        stringClass.defineMethod("delete!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "delete_bang"));
        stringClass.defineMethod("squeeze!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "squeeze_bang"));
        stringClass.defineMethod("each_line", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "each_line"));
        stringClass.defineMethod("each", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "each_line"));
        stringClass.defineMethod("slice", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "aref"));
        stringClass.defineMethod("slice!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "slice_bang"));
        return stringClass;
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isLetter(char c) {
        return RubyString.isUpper(c) || RubyString.isLower(c);
    }

    public static boolean isAlnum(char c) {
        return RubyString.isUpper(c) || RubyString.isLower(c) || RubyString.isDigit(c);
    }

    public static boolean isPrint(char c) {
        return c >= ' ' && c <= '~';
    }

    public static RubyString objAsString(Ruby ruby, RubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        return (RubyString)obj.funcall("to_s");
    }

    public int cmp(RubyString other) {
        return this.getValue().compareTo(other.getValue());
    }

    public String toId() {
        return this.getValue();
    }

    public RubyString newString(String s) {
        RubyClass type = this.getRubyClass();
        while (type.isIncluded() || type.isSingleton()) {
            type = type.getSuperClass();
        }
        return new RubyString(this.getRuby(), type, s);
    }

    public static RubyString newString(Ruby ruby, String str) {
        return new RubyString(ruby, str);
    }

    public static RubyString newString(Ruby ruby, String str, int len) {
        return new RubyString(ruby, str.substring(0, len));
    }

    public RubyObject dup() {
        RubyString newStr = this.newString(this.getValue());
        newStr.infectObject(this);
        return newStr;
    }

    public RubyObject rbClone() {
        RubyObject newObject = this.dup();
        newObject.setupClone(this);
        return newObject;
    }

    public RubyString cat(String str) {
        this.value = this.value + str;
        return this;
    }

    public RubyString to_s() {
        return this;
    }

    public RubyString replace(RubyObject other) {
        RubyString str = RubyString.stringValue(other);
        if (this == other || this.getValue().equals(str.getValue())) {
            return this;
        }
        this.setValue(str.getValue());
        this.infectObject(str);
        return this;
    }

    public RubyString reverse() {
        StringBuffer sb = new StringBuffer(this.getValue().length());
        int i = this.getValue().length() - 1;
        while (i >= 0) {
            sb.append(this.getValue().charAt(i));
            --i;
        }
        return this.newString(sb.toString());
    }

    public RubyString reverse_bang() {
        StringBuffer sb = new StringBuffer(this.getValue().length());
        int i = this.getValue().length() - 1;
        while (i >= 0) {
            sb.append(this.getValue().charAt(i));
            --i;
        }
        this.setValue(sb.toString());
        return this;
    }

    public static RubyString newInstance(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyString newString = RubyString.newString(ruby, "");
        newString.setRubyClass((RubyClass)recv);
        newString.callInit(args);
        return newString;
    }

    public RubyFixnum op_cmp(RubyObject other) {
        return RubyFixnum.newFixnum(this.getRuby(), this.cmp(RubyString.stringValue(other)));
    }

    public RubyBoolean equal(RubyObject other) {
        if (other == this) {
            return this.getRuby().getTrue();
        }
        if (!(other instanceof RubyString)) {
            return this.getRuby().getFalse();
        }
        return this.getValue().equals(((RubyString)other).getValue()) ? this.getRuby().getTrue() : this.getRuby().getFalse();
    }

    public RubyObject match(RubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).match(this);
        }
        if (other instanceof RubyString) {
            return RubyRegexp.newRegexp(this.getRuby(), (RubyString)other, 0).match(this);
        }
        return other.funcall("=~", this);
    }

    public RubyObject match2() {
        return RubyRegexp.newRegexp(this.getRuby(), this, 0).match2();
    }

    public RubyString capitalize() {
        int length = this.getValue().length();
        StringBuffer sb = new StringBuffer(length);
        if (length > 0) {
            sb.append(Character.toUpperCase(this.getValue().charAt(0)));
        }
        if (length > 1) {
            sb.append(this.getValue().toLowerCase().substring(1));
        }
        return this.newString(sb.toString());
    }

    public RubyString capitalize_bang() {
        int length = this.getValue().length();
        StringBuffer sb = new StringBuffer(length);
        if (length > 0) {
            sb.append(Character.toUpperCase(this.getValue().charAt(0)));
        }
        if (length > 1) {
            sb.append(this.getValue().toLowerCase().substring(1));
        }
        this.setValue(sb.toString());
        return this;
    }

    public RubyString upcase() {
        return this.newString(this.getValue().toUpperCase());
    }

    public RubyString upcase_bang() {
        this.setValue(this.getValue().toUpperCase());
        return this;
    }

    public RubyString downcase() {
        return this.newString(this.getValue().toLowerCase());
    }

    public RubyString downcase_bang() {
        this.setValue(this.getValue().toLowerCase());
        return this;
    }

    public RubyString swapcase() {
        RubyString newString = this.newString(this.getValue());
        return newString.swapcase_bang();
    }

    public RubyString swapcase_bang() {
        char[] chars = this.getValue().toCharArray();
        StringBuffer sb = new StringBuffer(chars.length);
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetter(chars[i])) {
                sb.append(chars[i]);
            } else if (Character.isLowerCase(chars[i])) {
                sb.append(Character.toUpperCase(chars[i]));
            } else {
                sb.append(Character.toLowerCase(chars[i]));
            }
            ++i;
        }
        this.setValue(this.getValue().toLowerCase());
        return this;
    }

    public RubyString dump() {
        return this.inspect(true);
    }

    public RubyString inspect() {
        return this.inspect(false);
    }

    private RubyString inspect(boolean dump) {
        int length = this.getValue().length();
        StringBuffer sb = new StringBuffer(length + 2 + length / 100);
        sb.append('\"');
        int i = 0;
        while (i < length) {
            char c = this.getValue().charAt(i);
            if (RubyString.isAlnum(c)) {
                sb.append(c);
            } else if (c == '\"' || c == '\\') {
                sb.append('\\').append(c);
            } else if (dump && c == '#') {
                sb.append('\\').append(c);
            } else if (RubyString.isPrint(c)) {
                sb.append(c);
            } else if (c == '\n') {
                sb.append('\\').append('n');
            } else if (c == '\r') {
                sb.append('\\').append('r');
            } else if (c == '\t') {
                sb.append('\\').append('t');
            } else if (c == '\f') {
                sb.append('\\').append('f');
            } else if (c == '\u000b') {
                sb.append('\\').append('v');
            } else if (c == '\u0007') {
                sb.append('\\').append('a');
            } else if (c == '\u001b') {
                sb.append('\\').append('e');
            } else {
                sb.append(new PrintfFormat("\\%.3o").sprintf(c));
            }
            ++i;
        }
        sb.append('\"');
        return RubyString.newString(this.getRuby(), sb.toString());
    }

    public RubyString op_plus(RubyObject other) {
        RubyString str = RubyString.stringValue(other);
        RubyString newString = this.newString(this.getValue() + str.getValue());
        newString.infectObject(str);
        return newString;
    }

    public RubyString op_mul(RubyInteger other) {
        long len = other.getLongValue();
        if (len < 0L) {
            throw new RubyArgumentException(this.getRuby(), "negative argument");
        }
        if (len > 0L && Long.MAX_VALUE / len < (long)this.getValue().length()) {
            throw new RubyArgumentException(this.getRuby(), "argument too big");
        }
        StringBuffer sb = new StringBuffer((int)((long)this.getValue().length() * len));
        int i = 0;
        while ((long)i < len) {
            sb.append(this.getValue());
            ++i;
        }
        RubyString newString = this.newString(sb.toString());
        newString.setTaint(this.isTaint());
        return newString;
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.getRuby(), this.getValue().hashCode());
    }

    public RubyFixnum length() {
        return new RubyFixnum(this.getRuby(), this.getValue().length());
    }

    public RubyBoolean empty() {
        return new RubyBoolean(this.getRuby(), this.getValue().length() == 0);
    }

    public RubyString append(RubyObject other) {
        this.infectObject(other);
        return this.cat(RubyString.stringValue(other).getValue());
    }

    public RubyString concat(RubyObject other) {
        if (other instanceof RubyFixnum && ((RubyFixnum)other).getLongValue() < 256L) {
            char c = (char)((RubyFixnum)other).getLongValue();
            return this.cat("" + c);
        }
        return this.append(other);
    }

    public static RubyString stringValue(RubyObject other) {
        if (other instanceof RubyString) {
            return (RubyString)other;
        }
        try {
            return (RubyString)other.convertType(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "String", "to_str");
        }
        catch (Exception ex) {
            throw new RubyArgumentException(other.getRuby(), "can't convert arg to String: " + ex.getMessage());
        }
    }

    public RubyObject sub(RubyObject[] args) {
        return this.sub(args, false);
    }

    public RubyObject sub_bang(RubyObject[] args) {
        return this.sub(args, true);
    }

    private RubyObject sub(RubyObject[] args, boolean bang) {
        RubyObject repl = this.getRuby().getNil();
        boolean iter = false;
        if (args.length == 1 && this.getRuby().isBlockGiven()) {
            iter = true;
        } else if (args.length == 2) {
            repl = args[1];
        } else {
            throw new RubyArgumentException(this.getRuby(), "wrong number of arguments");
        }
        RubyRegexp pat = RubyRegexp.regexpValue(args[0]);
        if (pat.search(this, 0) >= 0) {
            RubyMatchData match = (RubyMatchData)this.getRuby().getParserHelper().getBackref();
            RubyString newStr = match.pre_match();
            newStr.append((RubyString)(iter ? this.getRuby().yield(match.group(0L)) : pat.regsub(repl, match)));
            newStr.append(match.post_match());
            if (bang) {
                this.replace(newStr);
                return this;
            }
            return newStr;
        }
        if (bang) {
            return this.getRuby().getNil();
        }
        return this;
    }

    public RubyObject gsub(RubyObject[] args) {
        return this.gsub(args, false);
    }

    public RubyObject gsub_bang(RubyObject[] args) {
        return this.gsub(args, true);
    }

    private RubyObject gsub(RubyObject[] args, boolean bang) {
        RubyObject repl = this.getRuby().getNil();
        boolean iter = false;
        if (args.length == 1 && this.getRuby().isBlockGiven()) {
            iter = true;
        } else if (args.length == 2) {
            repl = args[1];
        } else {
            throw new RubyArgumentException(this.getRuby(), "wrong number of arguments");
        }
        boolean taint = repl.isTaint();
        RubyRegexp pat = RubyRegexp.regexpValue(args[0]);
        int beg = pat.search(this, 0);
        if (beg < 0) {
            return bang ? this.getRuby().getNil() : this.dup();
        }
        StringBuffer sbuf = new StringBuffer();
        String str = this.getValue();
        int offset = 0;
        while (beg >= 0) {
            RubyMatchData match = (RubyMatchData)this.getRuby().getParserHelper().getBackref();
            sbuf.append(str.substring(offset, beg));
            RubyObject newStr = iter ? this.getRuby().yield(match.group(0L)) : pat.regsub(repl, match);
            taint |= newStr.isTaint();
            sbuf.append(((RubyString)newStr).getValue());
            offset = match.matchEndPosition();
            beg = pat.search(this, offset == beg ? beg + 1 : offset);
        }
        sbuf.append(str.substring(offset, str.length()));
        if (bang) {
            this.setTaint(this.isTaint() || taint);
            this.setValue(sbuf.toString());
            return this;
        }
        RubyString result = this.newString(sbuf.toString());
        result.setTaint(taint);
        return result;
    }

    public RubyObject index(RubyObject[] args) {
        return this.index(args, false);
    }

    public RubyObject rindex(RubyObject[] args) {
        return this.index(args, true);
    }

    private RubyObject index(RubyObject[] args, boolean reverse) {
        int pos = 0;
        if (reverse) {
            pos = this.getValue().length();
        }
        if (this.argCount(args, 1, 2) == 2) {
            pos = RubyNumeric.fix2int(args[1]);
        }
        if (pos < 0 && (pos += this.getValue().length()) < 0) {
            return this.getRuby().getNil();
        }
        if (args[0] instanceof RubyRegexp) {
            int dummy = pos = ((RubyRegexp)args[0]).search(this, pos);
            while (reverse && dummy > -1) {
                pos = dummy;
                dummy = ((RubyRegexp)args[0]).search(this, pos + 1);
            }
        } else if (args[0] instanceof RubyString) {
            String sub = ((RubyString)args[0]).getValue();
            pos = reverse ? this.getValue().lastIndexOf(sub, pos) : this.getValue().indexOf(sub, pos);
        } else if (args[0] instanceof RubyFixnum) {
            char c = (char)((RubyFixnum)args[0]).getLongValue();
            pos = reverse ? this.getValue().lastIndexOf(c, pos) : this.getValue().indexOf(c, pos);
        } else {
            throw new RubyArgumentException(this.getRuby(), "wrong type of argument");
        }
        if (pos == -1) {
            return this.getRuby().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuby(), pos);
    }

    private RubyObject substr(int beg, int len) {
        int strLen = this.getValue().length();
        if (len < 0 || beg > strLen) {
            return this.getRuby().getNil();
        }
        if (beg < 0 && (beg += strLen) < 0) {
            return this.getRuby().getNil();
        }
        int end = Math.min(strLen, beg + len);
        RubyString newStr = this.newString(this.getValue().substring(beg, end));
        newStr.infectObject(this);
        return newStr;
    }

    private RubyObject replace(int beg, int len, RubyString repl) {
        int strLen = this.getValue().length();
        if (beg + len >= strLen) {
            len = strLen - beg;
        }
        this.setValue(this.getValue().substring(0, beg) + repl.getValue() + this.getValue().substring(beg + len));
        this.infectObject(repl);
        return this;
    }

    public RubyObject aref(RubyObject[] args) {
        if (this.argCount(args, 1, 2) == 2) {
            int beg = RubyNumeric.fix2int(args[0]);
            int len = RubyNumeric.fix2int(args[1]);
            return this.substr(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            int idx = RubyNumeric.fix2int(args[0]);
            if (idx < 0) {
                idx += this.getValue().length();
            }
            if (idx < 0 || idx >= this.getValue().length()) {
                return this.getRuby().getNil();
            }
            return new RubyFixnum(this.getRuby(), this.getValue().charAt(idx));
        }
        if (args[0] instanceof RubyRegexp) {
            if (RubyRegexp.regexpValue(args[0]).search(this, 0) >= 0) {
                return RubyRegexp.last_match(this.getRuby().getParserHelper().getBackref());
            }
            return this.getRuby().getNil();
        }
        if (args[0] instanceof RubyString) {
            if (this.getValue().indexOf(RubyString.stringValue(args[0]).getValue()) != -1) {
                return args[0];
            }
            return this.getRuby().getNil();
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getValue().length(), true, false);
            if (begLen == null) {
                return this.getRuby().getNil();
            }
            return this.substr((int)begLen[0], (int)begLen[1]);
        }
        int idx = (int)RubyNumeric.num2long(args[0]);
        if (idx < 0) {
            idx += this.getValue().length();
        }
        if (idx < 0 || idx >= this.getValue().length()) {
            return this.getRuby().getNil();
        }
        return new RubyFixnum(this.getRuby(), this.getValue().charAt(idx));
    }

    public RubyObject aset(RubyObject[] args) {
        int strLen = this.getValue().length();
        if (this.argCount(args, 2, 3) == 3) {
            RubyString repl = RubyString.stringValue(args[2]);
            int beg = RubyNumeric.fix2int(args[0]);
            int len = RubyNumeric.fix2int(args[1]);
            if (len < 0) {
                throw new RubyIndexException(this.getRuby(), "negative length");
            }
            if (beg < 0) {
                beg += strLen;
            }
            if (beg < 0 || beg >= strLen) {
                throw new RubyIndexException(this.getRuby(), "string index out of bounds");
            }
            if (beg + len > strLen) {
                len = strLen - beg;
            }
            this.replace(beg, len, repl);
            return repl;
        }
        if (args[0] instanceof RubyFixnum) {
            int idx = RubyNumeric.fix2int(args[0]);
            if (idx < 0) {
                idx += this.getValue().length();
            }
            if (idx < 0 || idx >= this.getValue().length()) {
                throw new RubyIndexException(this.getRuby(), "string index out of bounds");
            }
            if (args[1] instanceof RubyFixnum) {
                char c = (char)RubyNumeric.fix2int(args[1]);
                this.setValue(this.getValue().substring(0, idx) + c + this.getValue().substring(idx + 1));
            } else {
                this.replace(idx, 1, RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRegexp) {
            this.sub_bang(args);
            return args[1];
        }
        if (args[0] instanceof RubyString) {
            RubyString orig = RubyString.stringValue(args[0]);
            int beg = this.getValue().indexOf(orig.getValue());
            if (beg != -1) {
                this.replace(beg, orig.getValue().length(), RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRange) {
            long[] idxs = ((RubyRange)args[0]).getBeginLength(this.getValue().length(), false, true);
            this.replace((int)idxs[0], (int)idxs[1], RubyString.stringValue(args[1]));
            return args[1];
        }
        throw new TypeError(this.getRuby(), "wrong argument type");
    }

    public RubyObject slice_bang(RubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        RubyObject[] newArgs = new RubyObject[argc + 1];
        newArgs[0] = args[0];
        if (argc > 1) {
            newArgs[1] = args[1];
        }
        newArgs[argc] = this.newString("");
        RubyObject result = this.aref(args);
        this.aset(newArgs);
        return result;
    }

    public RubyObject format(RubyObject arg) {
        if (pfClass == null) {
            try {
                pfClass = this.getRuby().getJavaSupport().loadClass(Class.forName("org.jruby.util.PrintfFormat"), null);
            }
            catch (ClassNotFoundException ex) {
                throw new RubyBugException("couldn't find PrintfFormat class");
            }
        }
        return pfClass.funcall("new", this).funcall("sprintf", arg);
    }

    public RubyObject succ() {
        return this.succ(false);
    }

    public RubyObject succ_bang() {
        return this.succ(true);
    }

    private RubyString succ(boolean bang) {
        if (this.getValue().length() == 0) {
            return bang ? this : (RubyString)this.dup();
        }
        StringBuffer sbuf = new StringBuffer(this.getValue());
        boolean alnumSeen = false;
        int pos = -1;
        char c = '\u0000';
        char n = '\u0000';
        int i = sbuf.length() - 1;
        while (i >= 0) {
            c = sbuf.charAt(i);
            if (RubyString.isAlnum(c)) {
                alnumSeen = true;
                if (RubyString.isDigit(c) && c < '9' || RubyString.isLower(c) && c < 'z' || RubyString.isUpper(c) && c < 'Z') {
                    sbuf.setCharAt(i, (char)(c + '\u0001'));
                    pos = -1;
                    break;
                }
                pos = i;
                n = RubyString.isDigit(c) ? (char)'0' : (RubyString.isLower(c) ? (char)'a' : 'A');
                sbuf.setCharAt(i, n);
            }
            --i;
        }
        if (!alnumSeen) {
            int i2 = sbuf.length() - 1;
            while (i2 >= 0) {
                c = sbuf.charAt(i2);
                if (c < '\u00ff') {
                    sbuf.setCharAt(i2, (char)(c + '\u0001'));
                    pos = -1;
                    break;
                }
                pos = i2;
                n = '\u0001';
                sbuf.setCharAt(i2, '\u0000');
                --i2;
            }
        }
        if (pos > -1) {
            sbuf.insert(pos, n);
        }
        if (bang) {
            this.setValue(sbuf.toString());
            return this;
        }
        RubyString newStr = (RubyString)this.dup();
        newStr.setValue(sbuf.toString());
        return newStr;
    }

    public RubyObject upto(RubyObject str) {
        return this.upto(str, false);
    }

    RubyObject upto(RubyObject str, boolean excl) {
        RubyString current = this;
        RubyString end = RubyString.stringValue(str);
        while (current.cmp(end) <= 0) {
            this.getRuby().yield(current);
            if (current.cmp(end) == 0) break;
            current = current.succ(false);
            if (excl && current.cmp(end) == 0 || current.getValue().length() > end.getValue().length()) break;
        }
        return this;
    }

    public RubyBoolean include(RubyObject obj) {
        if (obj instanceof RubyFixnum) {
            char c = (char)RubyNumeric.fix2int(obj);
            return this.getValue().indexOf(c) == -1 ? this.getRuby().getFalse() : this.getRuby().getTrue();
        }
        String str = RubyString.stringValue(obj).getValue();
        return this.getValue().indexOf(str) == -1 ? this.getRuby().getFalse() : this.getRuby().getTrue();
    }

    public RubyObject to_i() {
        return RubyNumeric.str2inum(this.getRuby(), this, 10);
    }

    public RubyObject oct() {
        int pos;
        int base = 8;
        String str = this.getValue().trim();
        int n = pos = str.charAt(0) == '-' || str.charAt(0) == '+' ? 1 : 0;
        if (str.indexOf("0x") == pos || str.indexOf("0X") == pos) {
            base = 16;
        } else if (str.indexOf("0b") == pos || str.indexOf("0B") == pos) {
            base = 2;
        }
        return RubyNumeric.str2inum(this.getRuby(), this, base);
    }

    public RubyObject hex() {
        return RubyNumeric.str2inum(this.getRuby(), this, 16);
    }

    public RubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuby(), this);
    }

    /*
     * Unable to fully structure code
     */
    public RubyArray split(RubyObject[] args) {
        block16: {
            limit = 0;
            pat = null;
            str = null;
            argc = this.argCount(args, 0, 2);
            if (argc == 2 && (limit = RubyNumeric.fix2int(args[1])) == 1) {
                return RubyArray.newArray(this.getRuby(), this.dup());
            }
            result = RubyArray.newArray(this.getRuby(), 0L);
            pos = 0;
            beg = 0;
            hits = 0;
            len = this.getValue().length();
            if (argc > 0) {
                if (args[0] instanceof RubyRegexp) {
                    pat = RubyRegexp.regexpValue(args[0]);
                } else {
                    str = RubyString.stringValue(args[0]);
                    if (str.getValue().equals(" ")) {
                        pat = RubyRegexp.newRegexp(this.getRuby(), "\\s+", 0);
                    } else if (str.getValue().length() != 1) {
                        pat = RubyRegexp.newRegexp(this.getRuby(), str, 0);
                    }
                }
            } else {
                pat = RubyRegexp.newRegexp(this.getRuby(), "\\s+", 0);
            }
            if (pat == null) ** GOTO lbl38
            while ((beg = pat.search(this, pos)) > -1) {
                end = ((RubyMatchData)this.getRuby().getParserHelper().getBackref()).matchEndPosition();
                result.push(this.substr(pos, beg == pos && end == beg ? 1 : beg - pos));
                v0 = pos = end == beg ? beg + 1 : end;
                if (++hits + 1 != limit) {
                    continue;
                }
                break block16;
            }
            break block16;
lbl-1000:
            // 1 sources

            {
                result.push(this.substr(pos, beg - pos));
                if (++hits + 1 == limit) break;
                pos = beg + 1;
lbl38:
                // 2 sources

                ** while ((beg = this.getValue().indexOf((String)str.getValue(), (int)pos)) > -1)
            }
        }
        if (hits == 0) {
            result.push(this.dup());
        } else if (pos <= len) {
            result.push(this.substr(pos, len - pos));
        }
        if (limit == 0) {
            while (((RubyString)result.entry(result.getLength() - 1)).empty().isTrue()) {
                result.pop();
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public RubyObject scan(RubyObject arg) {
        pat = RubyRegexp.regexpValue(arg);
        start = 0;
        if (this.getRuby().isBlockGiven()) ** GOTO lbl30
        ary = RubyArray.newArray(this.getRuby());
        while (pat.search(this, start) != -1) {
            md = (RubyMatchData)this.getRuby().getParserHelper().getBackref();
            if (md.getSize() == 1L) {
                ary.push(md.group(0L));
            } else {
                ary.push(md.subseq(1L, md.getSize()));
            }
            if (md.matchEndPosition() == md.matchStartPosition()) {
                ++start;
                continue;
            }
            start = md.matchEndPosition();
        }
        return ary;
lbl-1000:
        // 1 sources

        {
            md = (RubyMatchData)this.getRuby().getParserHelper().getBackref();
            if (md.getSize() == 1L) {
                this.getRuby().yield(md.group(0L));
            } else {
                this.getRuby().yield(md.subseq(1L, md.getSize()));
            }
            if (md.matchEndPosition() == md.matchStartPosition()) {
                ++start;
                continue;
            }
            start = md.matchEndPosition();
lbl30:
            // 3 sources

            ** while (pat.search((RubyObject)this, (int)start) != -1)
        }
lbl31:
        // 1 sources

        return this;
    }

    public RubyObject ljust(RubyObject arg) {
        int len = RubyNumeric.fix2int(arg);
        if (len <= this.getValue().length()) {
            return this.dup();
        }
        Object[] args = new Object[]{this.getValue(), new Integer(-len)};
        return this.newString(new PrintfFormat("%*2$s").sprintf(args));
    }

    public RubyObject rjust(RubyObject arg) {
        int len = RubyNumeric.fix2int(arg);
        if (len <= this.getValue().length()) {
            return this.dup();
        }
        Object[] args = new Object[]{this.getValue(), new Integer(len)};
        return this.newString(new PrintfFormat("%*2$s").sprintf(args));
    }

    public RubyObject center(RubyObject arg) {
        int strLen;
        int len = RubyNumeric.fix2int(arg);
        if (len <= (strLen = this.getValue().length())) {
            return this.dup();
        }
        StringBuffer sbuf = new StringBuffer(len);
        int lead = (len - strLen) / 2;
        int pos = 0;
        while (pos < len) {
            if (pos == lead) {
                sbuf.append(this.getValue());
                pos += strLen;
                continue;
            }
            sbuf.append(' ');
            ++pos;
        }
        return this.newString(sbuf.toString());
    }

    private String getChop() {
        if (this.getValue().length() == 0) {
            return null;
        }
        int end = this.getValue().length() - 1;
        if (this.getValue().charAt(end) == '\n' && end > 0 && this.getValue().charAt(end - 1) == '\r') {
            --end;
        }
        return this.getValue().substring(0, end);
    }

    public RubyObject chop() {
        String newStr = this.getChop();
        if (newStr == null) {
            return this.dup();
        }
        return this.newString(newStr);
    }

    public RubyObject chop_bang() {
        String newStr = this.getChop();
        if (newStr == null) {
            return this.getRuby().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    protected String getChomp(RubyObject[] args) {
        if (this.getValue().length() == 0) {
            return null;
        }
        String sep = null;
        if (this.argCount(args, 0, 1) == 1) {
            sep = RubyString.stringValue(args[0]).getValue();
        }
        int end = -1;
        if (sep != null && this.getValue().endsWith(sep)) {
            return this.getValue().substring(0, this.getValue().lastIndexOf(sep));
        }
        if (this.getValue().endsWith("\r\n")) {
            end = this.getValue().length() - 2;
        } else if (this.getValue().endsWith("\n") || this.getValue().endsWith("\r")) {
            end = this.getValue().length() - 1;
        }
        return end == -1 ? null : this.getValue().substring(0, end);
    }

    public RubyObject chomp(RubyObject[] args) {
        String newStr = this.getChomp(args);
        if (newStr == null) {
            return this.dup();
        }
        return this.newString(newStr);
    }

    public RubyObject chomp_bang(RubyObject[] args) {
        String newStr = this.getChomp(args);
        if (newStr == null) {
            return this.getRuby().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    public RubyObject strip() {
        if (this.getValue().length() == 0) {
            return this.dup();
        }
        return this.newString(this.getValue().trim());
    }

    public RubyObject strip_bang() {
        if (this.getValue().length() == 0) {
            return this.getRuby().getNil();
        }
        String newStr = this.getValue().trim();
        if (newStr.equals(this.getValue())) {
            return this.getRuby().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    private String expandTemplate(String spec, boolean invertOK) {
        int len = spec.length();
        if (len <= 1) {
            return spec;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = invertOK && spec.startsWith("^") ? 1 : 0;
        while (pos < len) {
            int c1 = spec.charAt(pos);
            if (pos + 2 < len && spec.charAt(pos + 1) == '-') {
                char c2 = spec.charAt(pos + 2);
                if (c2 > c1) {
                    int i = c1;
                    while (i <= c2) {
                        sbuf.append((char)i);
                        ++i;
                    }
                }
                pos += 3;
                continue;
            }
            sbuf.append((char)c1);
            ++pos;
        }
        return sbuf.toString();
    }

    private String setupTable(String[] specs) {
        int[] table = new int[256];
        int numSets = 0;
        int i = 0;
        while (i < specs.length) {
            String template = this.expandTemplate(specs[i], true);
            boolean invert = specs[i].length() > 1 && specs[i].startsWith("^");
            int j = 0;
            while (j < 256) {
                if (template.indexOf((char)j) != -1) {
                    int n = j;
                    table[n] = table[n] + (invert ? -1 : 1);
                }
                ++j;
            }
            numSets += invert ? 0 : 1;
            ++i;
        }
        StringBuffer sbuf = new StringBuffer();
        int k = 0;
        while (k < 256) {
            if (table[k] == numSets) {
                sbuf.append((char)k);
            }
            ++k;
        }
        return sbuf.toString();
    }

    public RubyObject count(RubyObject[] args) {
        int argc = this.argCount(args, 1, -1);
        String[] specs = new String[argc];
        int i = 0;
        while (i < argc) {
            specs[i] = RubyString.stringValue(args[i]).getValue();
            ++i;
        }
        String table = this.setupTable(specs);
        int count = 0;
        int j = 0;
        while (j < this.getValue().length()) {
            if (table.indexOf(this.getValue().charAt(j)) != -1) {
                ++count;
            }
            ++j;
        }
        return RubyFixnum.newFixnum(this.getRuby(), count);
    }

    private String getDelete(RubyObject[] args) {
        int argc = this.argCount(args, 1, -1);
        String[] specs = new String[argc];
        int i = 0;
        while (i < argc) {
            specs[i] = RubyString.stringValue(args[i]).getValue();
            ++i;
        }
        String table = this.setupTable(specs);
        int strLen = this.getValue().length();
        StringBuffer sbuf = new StringBuffer(strLen);
        int j = 0;
        while (j < strLen) {
            char c = this.getValue().charAt(j);
            if (table.indexOf(c) == -1) {
                sbuf.append(c);
            }
            ++j;
        }
        return sbuf.toString();
    }

    public RubyObject delete(RubyObject[] args) {
        RubyString newStr = this.newString(this.getDelete(args));
        newStr.infectObject(this);
        return newStr;
    }

    public RubyObject delete_bang(RubyObject[] args) {
        String newStr = this.getDelete(args);
        if (newStr.equals(this.getValue())) {
            return this.getRuby().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    private String getSqueeze(RubyObject[] args) {
        int argc = args.length;
        String[] specs = null;
        if (argc > 0) {
            specs = new String[argc];
            int i = 0;
            while (i < argc) {
                specs[i] = RubyString.stringValue(args[i]).getValue();
                ++i;
            }
        }
        String table = specs == null ? null : this.setupTable(specs);
        int strLen = this.getValue().length();
        if (strLen <= 1) {
            return this.getValue();
        }
        StringBuffer sbuf = new StringBuffer(strLen);
        char c1 = this.getValue().charAt(0);
        sbuf.append(c1);
        int j = 1;
        while (j < strLen) {
            char c2 = this.getValue().charAt(j);
            if (c2 != c1 || table != null && table.indexOf(c2) == -1) {
                sbuf.append(c2);
                c1 = c2;
            }
            ++j;
        }
        return sbuf.toString();
    }

    public RubyObject squeeze(RubyObject[] args) {
        RubyString newStr = this.newString(this.getSqueeze(args));
        newStr.infectObject(this);
        return newStr;
    }

    public RubyObject squeeze_bang(RubyObject[] args) {
        String newStr = this.getSqueeze(args);
        if (newStr.equals(this.getValue())) {
            return this.getRuby().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    private String tr(RubyObject[] args, boolean squeeze) {
        if (args.length != 2) {
            throw new RubyArgumentException(this.getRuby(), "wrong number of arguments");
        }
        String srchSpec = RubyString.stringValue(args[0]).getValue();
        String srch = this.expandTemplate(srchSpec, true);
        if (srchSpec.startsWith("^")) {
            StringBuffer sbuf = new StringBuffer(256);
            int i = 0;
            while (i < 256) {
                char c = (char)i;
                if (srch.indexOf(c) == -1) {
                    sbuf.append(c);
                }
                ++i;
            }
            srch = sbuf.toString();
        }
        String repl = this.expandTemplate(RubyString.stringValue(args[1]).getValue(), false);
        int strLen = this.getValue().length();
        if (strLen == 0 || srch.length() == 0) {
            return this.getValue();
        }
        int repLen = repl.length();
        StringBuffer sbuf = new StringBuffer(strLen);
        int n = -1;
        int i = 0;
        while (i < strLen) {
            char c;
            char cs = this.getValue().charAt(i);
            int pos = srch.indexOf(cs);
            if (pos == -1) {
                sbuf.append(cs);
                c = '\uffffffff';
            } else if (repLen > 0) {
                char cr = repl.charAt(Math.min(pos, repLen - 1));
                if (!squeeze || cr != c) {
                    sbuf.append(cr);
                    c = cr;
                }
            }
            ++i;
        }
        return sbuf.toString();
    }

    public RubyObject tr(RubyObject[] args) {
        RubyString newStr = this.newString(this.tr(args, false));
        newStr.infectObject(this);
        return newStr;
    }

    public RubyObject tr_bang(RubyObject[] args) {
        String newStr = this.tr(args, false);
        if (newStr.equals(this.getValue())) {
            return this.getRuby().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    public RubyObject tr_s(RubyObject[] args) {
        RubyString newStr = this.newString(this.tr(args, true));
        newStr.infectObject(this);
        return newStr;
    }

    public RubyObject tr_s_bang(RubyObject[] args) {
        String newStr = this.tr(args, true);
        if (newStr.equals(this.getValue())) {
            return this.getRuby().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    public RubyObject each_line(RubyObject[] args) {
        int strLen = this.getValue().length();
        if (strLen == 0) {
            return this;
        }
        String sep = null;
        if (this.argCount(args, 0, 1) == 1) {
            sep = RubyRegexp.quote(RubyString.stringValue(args[0]).getValue());
        }
        if (sep == null) {
            sep = "(?:\\n|\\r\\n?)";
        } else if (sep.length() == 0) {
            sep = "(?:\\n|\\r\\n?){2,}";
        }
        RubyRegexp pat = RubyRegexp.newRegexp(this.getRuby(), ".*?" + sep, 4);
        int start = 0;
        while (pat.search(this, start) != -1) {
            RubyMatchData md = (RubyMatchData)this.getRuby().getParserHelper().getBackref();
            this.getRuby().yield(md.group(0L));
            start = md.matchEndPosition();
        }
        if (start < strLen) {
            this.getRuby().yield(this.substr(start, strLen - start));
        }
        return this;
    }

    public RubySymbol intern() {
        return RubySymbol.newSymbol(this.getRuby(), this.getValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

