/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Method;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyJavaInterface;
import org.jruby.RubyMethod;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.runtime.Callback;

public class JavaInterfaceMethod
implements Callback {
    private String methodName;
    private Set methodList;

    public JavaInterfaceMethod(String methodName, Set methodList) {
        this.methodName = methodName;
        this.methodList = methodList;
    }

    public RubyObject execute(RubyObject recv, RubyObject[] args, Ruby ruby) {
        RubyProc proc = null;
        RubyMethod method = null;
        RubyObject sendRecv = null;
        RubyString sendMethod = null;
        if (ruby.isBlockGiven()) {
            proc = RubyProc.newProc(ruby, ruby.getClasses().getProcClass());
        } else if (args.length == 2) {
            sendRecv = args[0];
            sendMethod = (RubyString)args[1];
        } else if (args.length == 1) {
            if (args[0] instanceof RubyProc) {
                proc = (RubyProc)args[0];
            } else if (args[0] instanceof RubyMethod) {
                method = (RubyMethod)args[0];
            } else {
                sendRecv = args[0];
                sendMethod = RubyString.newString(ruby, this.methodName);
            }
        }
        Method interfaceMethod = (Method)this.methodList.iterator().next();
        if (this.methodList.size() <= 1 || proc != null || method != null) {
            // empty if block
        }
        if (proc != null) {
            return RubyJavaInterface.newJavaInterface(ruby, interfaceMethod, proc);
        }
        if (method != null) {
            return RubyJavaInterface.newJavaInterface(ruby, interfaceMethod, method);
        }
        return RubyJavaInterface.newJavaInterface(ruby, interfaceMethod, sendRecv, sendMethod);
    }
}

