/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.exceptions.TypeError;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;
import org.jruby.nodes.types.AssignableNode;

public class CVDeclNode
extends Node
implements AssignableNode {
    public CVDeclNode(String vId, Node valueNode) {
        super(32, (Object)vId, (Object)valueNode, null);
    }

    public void assign(Ruby ruby, RubyObject self, RubyObject value, boolean check) {
        if (ruby.getCBase().isSingleton()) {
            ruby.getCBase().getInstanceVar("__attached__").getClassVarSingleton().setClassVar(this.getVId(), value);
        } else {
            ruby.getCBase().declareClassVar(this.getVId(), value);
        }
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        if (ruby.getCBase() == null) {
            throw new TypeError(ruby, "no class/module to define class variable");
        }
        RubyObject result = this.getValueNode().eval(ruby, self);
        if (ruby.getCBase().isSingleton()) {
            ruby.getCBase().getInstanceVar("__attached__").getClassVarSingleton().declareClassVar(this.getVId(), result);
        } else {
            ruby.getCBase().declareClassVar(this.getVId(), result);
        }
        return result;
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitCVDeclNode(this);
    }
}

