/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;
import org.jruby.nodes.types.AssignableNode;
import org.jruby.nodes.util.ArgsUtil;
import org.jruby.runtime.RubyBlock;
import org.jruby.util.RubyPointer;

public class CallNode
extends Node
implements AssignableNode {
    public CallNode(Node recvNode, String mId, Node argsNode) {
        super(37, (Object)recvNode, (Object)mId, (Object)argsNode);
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        RubyBlock tmpBlock = ArgsUtil.beginCallArgs(ruby);
        RubyObject recv = this.getRecvNode().eval(ruby, self);
        RubyPointer args = ArgsUtil.setupArgs(ruby, self, this.getArgsNode());
        ArgsUtil.endCallArgs(ruby, tmpBlock);
        return recv.getRubyClass().call(recv, this.getMId(), args, 0);
    }

    public void assign(Ruby ruby, RubyObject self, RubyObject value, boolean check) {
        RubyObject recv = this.getRecvNode().eval(ruby, self);
        if (this.getArgsNode() == null) {
            recv.getRubyClass().call(recv, this.getMId(), new RubyPointer(new RubyObject[]{value}), 0);
        } else {
            RubyArray args = (RubyArray)this.getArgsNode().eval(ruby, self);
            args.push(value);
            recv.getRubyClass().call(recv, this.getMId(), new RubyPointer(args.getList()), 0);
        }
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitCallNode(this);
    }
}

