/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.nodes.CRefNode;
import org.jruby.nodes.NodeVisitor;
import org.jruby.nodes.ScopeNode;
import org.jruby.runtime.Callback;
import org.jruby.runtime.RubyGlobalEntry;

public class Node {
    public static final Node ONE = new Node(-1);
    public static final Node MINUS_ONE = new Node(-1);
    private int line;
    private String file;
    private int type;
    private Object u1;
    private Object u2;
    private Object u3;

    protected String stringOrNull(Object io) {
        if (io == null) {
            return "null";
        }
        return io.toString();
    }

    protected Node(int type) {
        this(type, null, null, null);
    }

    protected Node(int type, int u1, Object u2, Object u3) {
        this(type, (Object)new Integer(u1), u2, u3);
    }

    protected Node(int type, Object u1, int u2, Object u3) {
        this(type, u1, (Object)new Integer(u2), u3);
    }

    protected Node(int type, Object u1, Object u2, int u3) {
        this(type, u1, u2, (Object)new Integer(u3));
    }

    protected Node(int type, Object u1, int u2, int u3) {
        this(type, u1, (Object)new Integer(u2), (Object)new Integer(u3));
    }

    protected Node(int type, Object u1, Object u2, Object u3) {
        this.type = type;
        this.u1 = u1;
        this.u2 = u2;
        this.u3 = u3;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public int getType() {
        return this.type;
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        ruby.getRuntime().getErrorStream().println(this.file + ":" + this.line + " Unsupported feature, node class is" + this.getClass());
        throw new UnsupportedOperationException();
    }

    public Node copyNodeScope(CRefNode refValue) {
        ScopeNode copy = new ScopeNode(null, refValue.cloneCRefNode(), this.getNextNode());
        if (this.getTable() != null) {
            ArrayList newTable = new ArrayList(this.getTable().size());
            newTable.addAll(this.getTable());
            copy.setTable(newTable);
        }
        return copy;
    }

    public Node getHeadNode() {
        return (Node)this.u1;
    }

    public void setHeadNode(Node headNode) {
        this.u1 = headNode;
    }

    public int getALength() {
        return this.u2 == null ? 0 : (Integer)this.u2;
    }

    public void setALength(int alength) {
        this.u2 = new Integer(alength);
    }

    public Node getNextNode() {
        return (Node)this.u3;
    }

    public void setNextNode(Node nextNode) {
        this.u3 = nextNode;
    }

    public Node getConditionNode() {
        return (Node)this.u1;
    }

    public Node getBodyNode() {
        return (Node)this.u2;
    }

    public Node getElseNode() {
        return (Node)this.u3;
    }

    public RubyObject getOrigin() {
        return (RubyObject)this.u3;
    }

    public Node getResqNode() {
        return (Node)this.u2;
    }

    public Node getEnsureNode() {
        return (Node)this.u3;
    }

    public Node getFirstNode() {
        return (Node)this.u1;
    }

    public Node getSecondNode() {
        return (Node)this.u2;
    }

    public Node getSttsNode() {
        return (Node)this.u1;
    }

    public RubyGlobalEntry getEntry() {
        return (RubyGlobalEntry)this.u3;
    }

    public String getVId() {
        return (String)this.u1;
    }

    public int getCFlag() {
        return this.u2 == null ? 0 : (Integer)this.u2;
    }

    public void setCFlag(int cflag) {
        this.u2 = cflag == 0 ? null : new Integer(cflag);
    }

    public RubyObject getCValue() {
        return (RubyObject)this.u3;
    }

    public int getCount() {
        return this.u3 == null ? 0 : (Integer)this.u3;
    }

    public void setCount(int newCount) {
        this.u3 = newCount == 0 ? null : new Integer(newCount);
    }

    public List getTable() {
        return (List)this.u1;
    }

    public void setTable(List newTable) {
        this.u1 = newTable;
    }

    public Node getVarNode() {
        return (Node)this.u1;
    }

    public Node getIBodyNode() {
        return (Node)this.u2;
    }

    public Node getIterNode() {
        return (Node)this.u3;
    }

    public void setIterNode(Node newIterNode) {
        this.u3 = newIterNode;
    }

    public Node getValueNode() {
        return (Node)this.u2;
    }

    public void setValueNode(Node newValueNode) {
        this.u2 = newValueNode;
    }

    public String getAId() {
        return (String)this.u3;
    }

    public void setAId(String newAid) {
        this.u3 = newAid;
    }

    public RubyObject getLiteral() {
        return (RubyObject)this.u1;
    }

    public void setLiteral(RubyObject newLiteral) {
        this.u1 = newLiteral;
    }

    public Node getFrmlNode() {
        return (Node)this.u1;
    }

    public int getRest() {
        return this.u2 == null ? 0 : (Integer)this.u2;
    }

    public Node getOptNode() {
        return (Node)this.u1;
    }

    public Node getRecvNode() {
        return (Node)this.u1;
    }

    public String getMId() {
        return (String)this.u2;
    }

    public Node getArgsNode() {
        return (Node)this.u3;
    }

    public void setArgsNode(Node newArgsNode) {
        this.u3 = newArgsNode;
    }

    public int getNoex() {
        return this.u1 == null ? 0 : (Integer)this.u1;
    }

    public void setNoex(int newNoex) {
        this.u1 = newNoex == 0 ? null : new Integer(newNoex);
    }

    public Node getDefnNode() {
        return (Node)this.u3;
    }

    public String getOldId() {
        return (String)this.u1;
    }

    public String getNewId() {
        return (String)this.u2;
    }

    public Callback getCallbackMethod() {
        return (Callback)this.u1;
    }

    public int getArgsCount() {
        return this.u2 == null ? 0 : (Integer)this.u2;
    }

    public String getClassNameId() {
        return (String)this.u1;
    }

    public Node getSuperNode() {
        return (Node)this.u3;
    }

    public String getModlId() {
        return (String)this.u1;
    }

    public RubyObject getClassValue() {
        return (RubyObject)this.u1;
    }

    public void setClassValue(RubyObject newClassValue) {
        this.u1 = newClassValue;
    }

    public Node getBeginNode() {
        return (Node)this.u1;
    }

    public void setBeginNode(Node newBeginNode) {
        this.u1 = newBeginNode;
    }

    public Node getEndNode() {
        return (Node)this.u2;
    }

    public void setEndNode(Node newEndNode) {
        this.u2 = newEndNode;
    }

    public int getState() {
        return this.u3 == null ? 0 : (Integer)this.u3;
    }

    public CRefNode getRefValue() {
        return (CRefNode)this.u2;
    }

    public void setRefValue(CRefNode newRefValue) {
        this.u2 = newRefValue;
    }

    public int getNth() {
        return this.u2 == null ? 0 : (Integer)this.u2;
    }

    public void setNth(int newNth) {
        this.u2 = newNth == 0 ? null : new Integer(newNth);
    }

    public String getTagId() {
        return (String)this.u1;
    }

    public RubyObject getTValue() {
        return (RubyObject)this.u2;
    }

    public void accept(NodeVisitor iVisitor) {
    }
}

