/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.nodes.AliasNode;
import org.jruby.nodes.ArgsCatNode;
import org.jruby.nodes.ArgsNode;
import org.jruby.nodes.ArgsPushNode;
import org.jruby.nodes.ArrayNode;
import org.jruby.nodes.AttrSetNode;
import org.jruby.nodes.BackRefNode;
import org.jruby.nodes.BeginNode;
import org.jruby.nodes.BlockArgNode;
import org.jruby.nodes.BlockNode;
import org.jruby.nodes.BlockPassNode;
import org.jruby.nodes.BreakNode;
import org.jruby.nodes.CDeclNode;
import org.jruby.nodes.CFuncNode;
import org.jruby.nodes.CVAsgnNode;
import org.jruby.nodes.CVDeclNode;
import org.jruby.nodes.CVar2Node;
import org.jruby.nodes.CVarNode;
import org.jruby.nodes.CallNode;
import org.jruby.nodes.CaseNode;
import org.jruby.nodes.ClassNode;
import org.jruby.nodes.Colon2Node;
import org.jruby.nodes.Colon3Node;
import org.jruby.nodes.ConstNode;
import org.jruby.nodes.DAsgnCurrNode;
import org.jruby.nodes.DAsgnNode;
import org.jruby.nodes.DStrNode;
import org.jruby.nodes.DVarNode;
import org.jruby.nodes.DXStrNode;
import org.jruby.nodes.DefinedNode;
import org.jruby.nodes.DefnNode;
import org.jruby.nodes.DefsNode;
import org.jruby.nodes.DotNode;
import org.jruby.nodes.EnsureNode;
import org.jruby.nodes.EvStrNode;
import org.jruby.nodes.FBodyNode;
import org.jruby.nodes.FCallNode;
import org.jruby.nodes.FalseNode;
import org.jruby.nodes.ForNode;
import org.jruby.nodes.GAsgnNode;
import org.jruby.nodes.GVarNode;
import org.jruby.nodes.HashNode;
import org.jruby.nodes.IAsgnNode;
import org.jruby.nodes.IFuncNode;
import org.jruby.nodes.IVarNode;
import org.jruby.nodes.IfNode;
import org.jruby.nodes.IterNode;
import org.jruby.nodes.LAsgnNode;
import org.jruby.nodes.LVarNode;
import org.jruby.nodes.LitNode;
import org.jruby.nodes.MAsgnNode;
import org.jruby.nodes.Match2Node;
import org.jruby.nodes.Match3Node;
import org.jruby.nodes.MatchNode;
import org.jruby.nodes.MethodNode;
import org.jruby.nodes.ModuleNode;
import org.jruby.nodes.NewlineNode;
import org.jruby.nodes.NextNode;
import org.jruby.nodes.NilNode;
import org.jruby.nodes.Node;
import org.jruby.nodes.NotNode;
import org.jruby.nodes.NthRefNode;
import org.jruby.nodes.OpAsgn1Node;
import org.jruby.nodes.OpAsgn2Node;
import org.jruby.nodes.OpAsgnAndNode;
import org.jruby.nodes.OpAsgnOrNode;
import org.jruby.nodes.OptNNode;
import org.jruby.nodes.PostExeNode;
import org.jruby.nodes.RedoNode;
import org.jruby.nodes.RescueBodyNode;
import org.jruby.nodes.RescueNode;
import org.jruby.nodes.RestArgsNode;
import org.jruby.nodes.RetryNode;
import org.jruby.nodes.ReturnNode;
import org.jruby.nodes.SClassNode;
import org.jruby.nodes.ScopeNode;
import org.jruby.nodes.SelfNode;
import org.jruby.nodes.StrNode;
import org.jruby.nodes.SuperNode;
import org.jruby.nodes.TrueNode;
import org.jruby.nodes.UndefNode;
import org.jruby.nodes.UntilNode;
import org.jruby.nodes.VAliasNode;
import org.jruby.nodes.VCallNode;
import org.jruby.nodes.WhenNode;
import org.jruby.nodes.WhileNode;
import org.jruby.nodes.XStrNode;
import org.jruby.nodes.YieldNode;
import org.jruby.nodes.ZArrayNode;
import org.jruby.nodes.ZSuperNode;
import org.jruby.parser.ParserHelper;
import org.jruby.runtime.Callback;

public class NodeFactory {
    private Ruby ruby;
    private ParserHelper ph;

    public NodeFactory(Ruby ruby) {
        this.ruby = ruby;
        this.ph = ruby.getParserHelper();
    }

    private Node setFileNLine(Node iNode) {
        iNode.setLine(this.ph.getLine());
        iNode.setFile(this.ruby.getSourceFile());
        return iNode;
    }

    public Node newMethod(Node body, int noex) {
        return this.setFileNLine(new MethodNode(body, noex));
    }

    public Node newFBody(Node bodyNode, String id, RubyModule origin) {
        return this.setFileNLine(new FBodyNode(bodyNode, id, origin));
    }

    public Node newDefn(String mid, Node args, Node body, int noex) {
        return this.setFileNLine(new DefnNode(noex, mid, this.newRFunc(args, body)));
    }

    public Node newDefs(Node recvNode, String mid, Node a, Node d) {
        return this.setFileNLine(new DefsNode(recvNode, mid, this.newRFunc(a, d)));
    }

    public Node newCFunc(Callback cfunc) {
        return this.setFileNLine(new CFuncNode(cfunc));
    }

    public Node newIFunc(Callback cfunc, RubyObject tval) {
        return this.setFileNLine(new IFuncNode(cfunc, tval));
    }

    public ScopeNode newRFunc(Node b1, Node b2) {
        return this.newScope(this.ph.block_append(b1, b2));
    }

    public ScopeNode newScope(Node body) {
        return (ScopeNode)this.setFileNLine(new ScopeNode(this.ph.local_tbl(), null, body));
    }

    public BlockNode newBlock(Node head) {
        return (BlockNode)this.setFileNLine(new BlockNode(head));
    }

    public Node newIf(Node condition, Node body, Node elseBody) {
        return this.setFileNLine(new IfNode(condition, body, elseBody));
    }

    public Node newUnless(Node condition, Node body, Node elseBody) {
        return this.setFileNLine(this.newIf(condition, elseBody, body));
    }

    public Node newCase(Node head, Node body) {
        return this.setFileNLine(new CaseNode(head, body));
    }

    public Node newWhen(Node head, Node body, Node next) {
        return this.setFileNLine(new WhenNode(head, body, next));
    }

    public Node newOptN(Node body) {
        return this.setFileNLine(new OptNNode(body));
    }

    public Node newWhile(Node condition, Node body) {
        return this.setFileNLine(new WhileNode(condition, body));
    }

    public Node newUntil(Node condition, Node body) {
        return this.setFileNLine(new UntilNode(condition, body));
    }

    public Node newFor(Node var, Node iter, Node body) {
        return this.setFileNLine(new ForNode(var, body, iter));
    }

    public Node newIter(Node var, Node iter, Node body) {
        return this.setFileNLine(new IterNode(var, body, iter));
    }

    public Node newBreak() {
        return this.setFileNLine(new BreakNode());
    }

    public Node newNext() {
        return this.setFileNLine(new NextNode());
    }

    public Node newRedo() {
        return this.setFileNLine(new RedoNode());
    }

    public Node newRetry() {
        return this.setFileNLine(new RetryNode());
    }

    public Node newBegin(Node body) {
        return this.setFileNLine(new BeginNode(body));
    }

    public Node newRescue(Node headNode, Node rescueNode, Node elseNode) {
        return this.setFileNLine(new RescueNode(headNode, rescueNode, elseNode));
    }

    public RescueBodyNode newResBody(Node args, Node body, Node head) {
        return (RescueBodyNode)this.setFileNLine(new RescueBodyNode(head, body, args));
    }

    public Node newEnsure(Node head, Node ensure) {
        return this.setFileNLine(new EnsureNode(head, ensure));
    }

    public Node newReturn(Node stts) {
        return this.setFileNLine(new ReturnNode(stts));
    }

    public Node newYield(Node stts) {
        return this.setFileNLine(new YieldNode(stts));
    }

    public ArrayNode newList(Node head) {
        return this.newArray(head);
    }

    public ArrayNode newArray(Node head) {
        return (ArrayNode)this.setFileNLine(new ArrayNode(head, 1, null));
    }

    public ZArrayNode newZArray() {
        return (ZArrayNode)this.setFileNLine(new ZArrayNode());
    }

    public Node newHash(Node head) {
        return (HashNode)this.setFileNLine(new HashNode(head));
    }

    public Node newNot(Node body) {
        return this.setFileNLine(new NotNode(body));
    }

    public Node newMAsgn(Node valueNode, Node argsNode) {
        return this.setFileNLine(new MAsgnNode(valueNode, argsNode));
    }

    public Node newGAsgn(String vid, Node valueNode) {
        return this.setFileNLine(new GAsgnNode(valueNode, this.ruby.getGlobalEntry(vid)));
    }

    public Node newLAsgn(String vid, Node valueNode) {
        return this.setFileNLine(new LAsgnNode(valueNode, this.ph.getLocalIndex(vid)));
    }

    public Node newDAsgn(String vid, Node valueNode) {
        return this.setFileNLine(new DAsgnNode(vid, valueNode));
    }

    public Node newDAsgnCurr(String vid, Node valueNode) {
        return this.setFileNLine(new DAsgnCurrNode(vid, valueNode));
    }

    public Node newIAsgn(String vid, Node valueNode) {
        return this.setFileNLine(new IAsgnNode(vid, valueNode));
    }

    public Node newCDecl(String vid, Node valueNode) {
        return this.setFileNLine(new CDeclNode(vid, valueNode));
    }

    public Node newCVAsgn(String vid, Node valueNode) {
        return this.setFileNLine(new CVAsgnNode(vid, valueNode));
    }

    public Node newCVDecl(String vid, Node valueNode) {
        return this.setFileNLine(new CVDeclNode(vid, valueNode));
    }

    public Node newOpAsgn1(Node recvNode, String mid, Node argsNode) {
        return this.setFileNLine(new OpAsgn1Node(recvNode, mid, argsNode));
    }

    public Node newOpAsgn2(Node recvNode, String vid, String mid, Node valueNode) {
        return this.setFileNLine(new OpAsgn2Node(recvNode, valueNode, vid, mid));
    }

    public Node newOpAsgnOr(Node head, Node valueNode) {
        return this.setFileNLine(new OpAsgnOrNode(head, valueNode, null));
    }

    public Node newOpAsgnAnd(Node head, Node valueNode) {
        return this.setFileNLine(new OpAsgnAndNode(head, valueNode));
    }

    public Node newGVar(String id) {
        return this.setFileNLine(new GVarNode(this.ruby.getGlobalEntry(id)));
    }

    public Node newLVar(String vid) {
        return this.setFileNLine(new LVarNode(this.ph.getLocalIndex(vid)));
    }

    public Node newDVar(String vid) {
        return this.setFileNLine(new DVarNode(vid));
    }

    public Node newIVar(String vid) {
        return this.setFileNLine(new IVarNode(vid));
    }

    public Node newConst(String vid) {
        return this.setFileNLine(new ConstNode(vid));
    }

    public Node newCVar(String vid) {
        return this.setFileNLine(new CVarNode(vid));
    }

    public Node newCVar2(String vid) {
        return this.setFileNLine(new CVar2Node(vid));
    }

    public Node newNthRef(int nth) {
        return this.setFileNLine(new NthRefNode(nth));
    }

    public Node newBackRef(int nth) {
        return this.setFileNLine(new BackRefNode(nth));
    }

    public Node newMatch(Node head) {
        return this.setFileNLine(new MatchNode(head));
    }

    public Node newMatch2(Node recv, Node value) {
        return this.setFileNLine(new Match2Node(recv, value));
    }

    public Node newMatch3(Node recv, Node value) {
        return this.setFileNLine(new Match3Node(recv, value));
    }

    public Node newLit(RubyObject lit) {
        return this.setFileNLine(new LitNode(lit));
    }

    public Node newStr(RubyObject str) {
        return this.setFileNLine(new StrNode(str));
    }

    public Node newDStr(RubyObject str) {
        return this.setFileNLine(new DStrNode(str));
    }

    public Node newXStr(RubyObject str) {
        return this.setFileNLine(new XStrNode(str));
    }

    public Node newDXStr(RubyObject str) {
        return this.setFileNLine(new DXStrNode(str));
    }

    public Node newEVStr(String s, int len) {
        return this.setFileNLine(new EvStrNode(RubyString.newString(this.ruby, s, len)));
    }

    public Node newCall(Node recv, String mid, Node args) {
        return this.setFileNLine(new CallNode(recv, mid, args));
    }

    public Node newFCall(String mid, Node args) {
        return this.setFileNLine(new FCallNode(mid, args));
    }

    public Node newVCall(String mid) {
        return this.setFileNLine(new VCallNode(mid));
    }

    public Node newSuper(Node args) {
        return this.setFileNLine(new SuperNode(args));
    }

    public Node newZSuper() {
        return this.setFileNLine(new ZSuperNode());
    }

    public Node newArgs(Integer count, Node optNode, int rest) {
        return this.setFileNLine(new ArgsNode(optNode, rest, count != null ? count : 0));
    }

    public Node newArgsCat(Node head, Node body) {
        return this.setFileNLine(new ArgsCatNode(head, body));
    }

    public Node newArgsPush(Node head, Node body) {
        return this.setFileNLine(new ArgsPushNode(head, body));
    }

    public Node newRestArgs(Node head) {
        return this.setFileNLine(new RestArgsNode(head));
    }

    public Node newBlockArg(String vid) {
        return this.setFileNLine(new BlockArgNode(this.ph.getLocalIndex(vid)));
    }

    public Node newBlockPass(Node bodyNode) {
        return this.setFileNLine(new BlockPassNode(bodyNode));
    }

    public Node newAlias(String newId, String oldId) {
        return this.setFileNLine(new AliasNode(oldId, newId));
    }

    public Node newVAlias(String newId, String oldId) {
        return this.setFileNLine(new VAliasNode(oldId, newId));
    }

    public Node newUndef(String mid) {
        return this.setFileNLine(new UndefNode(mid));
    }

    public Node newClass(String cnameId, Node body, Node superNode) {
        return this.setFileNLine(new ClassNode(cnameId, this.newScope(body), superNode));
    }

    public Node newSClass(Node receiverNode, Node body) {
        return this.setFileNLine(new SClassNode(receiverNode, this.newScope(body)));
    }

    public Node newModule(String moduleName, Node body) {
        return this.setFileNLine(new ModuleNode(moduleName, this.newScope(body)));
    }

    public Node newColon2(Node head, String mid) {
        return this.setFileNLine(new Colon2Node(head, mid));
    }

    public Node newColon3(String mid) {
        return this.setFileNLine(new Colon3Node(mid));
    }

    public Node newDot2(Node begin, Node end) {
        return this.setFileNLine(new DotNode(begin, end, false));
    }

    public Node newDot3(Node begin, Node end) {
        return this.setFileNLine(new DotNode(begin, end, true));
    }

    public Node newAttrSet(String vid) {
        return this.setFileNLine(new AttrSetNode(vid));
    }

    public Node newSelf() {
        return this.setFileNLine(new SelfNode());
    }

    public Node newNil() {
        return this.setFileNLine(new NilNode());
    }

    public Node newTrue() {
        return this.setFileNLine(new TrueNode());
    }

    public Node newFalse() {
        return this.setFileNLine(new FalseNode());
    }

    public Node newDefined(Node head) {
        return this.setFileNLine(new DefinedNode(head));
    }

    public NewlineNode newNewline(Node nextNode) {
        return (NewlineNode)this.setFileNLine(new NewlineNode(nextNode));
    }

    public Node newPreExe(Node body) {
        return this.newScope(body);
    }

    public Node newPostExe() {
        return this.setFileNLine(new PostExeNode());
    }
}

