/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RetryException;
import org.jruby.exceptions.TypeError;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;
import org.jruby.nodes.util.ArgsUtil;
import org.jruby.runtime.RubyBlock;
import org.jruby.util.RubyPointer;

public class RescueNode
extends Node {
    public RescueNode(Node headNode, Node rescueNode, Node elseNode) {
        super(18, (Object)headNode, (Object)rescueNode, (Object)elseNode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RubyObject eval(Ruby ruby, RubyObject self) {
        Object var7_6;
        RubyObject rubyObject;
        try {
            block6: while (true) {
                Node body;
                RaiseException raExcptn2;
                block13: {
                    block11: {
                        try {
                            RubyObject result = this.getHeadNode().eval(ruby, self);
                            if (this.getElseNode() != null) {
                                rubyObject = this.getElseNode().eval(ruby, self);
                                var7_6 = null;
                                break block11;
                            }
                            rubyObject = result;
                            break;
                        }
                        catch (RaiseException raExcptn2) {
                            ruby.setGlobalVar("$!", raExcptn2.getActException());
                            ruby.setSourceLine(this.getLine());
                            body = this.getResqNode();
                            break block13;
                        }
                    }
                    ruby.setGlobalVar("$!", ruby.getNil());
                    return rubyObject;
                }
                while (true) {
                    if (body == null) {
                        throw raExcptn2;
                    }
                    if (this.isRescueHandled(ruby, raExcptn2.getActException(), self, body)) {
                        RubyObject rubyObject2;
                        try {
                            rubyObject2 = body.eval(ruby, self);
                            var7_6 = null;
                        }
                        catch (RetryException rExcptn) {
                            ruby.setGlobalVar("$!", ruby.getNil());
                            var7_6 = null;
                            ruby.setGlobalVar("$!", ruby.getNil());
                            continue block6;
                        }
                        ruby.setGlobalVar("$!", ruby.getNil());
                        return rubyObject2;
                    }
                    body = body.getHeadNode();
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ruby.setGlobalVar("$!", ruby.getNil());
            throw throwable;
        }
        var7_6 = null;
        ruby.setGlobalVar("$!", ruby.getNil());
        return rubyObject;
    }

    private boolean isRescueHandled(Ruby ruby, RubyException actExcptn, RubyObject self, Node node) {
        if (node.getArgsNode() == null) {
            return actExcptn.kind_of(ruby.getExceptions().getStandardError()).isTrue();
        }
        RubyBlock tmpBlock = ArgsUtil.beginCallArgs(ruby);
        RubyPointer args = ArgsUtil.setupArgs(ruby, self, node.getArgsNode());
        ArgsUtil.endCallArgs(ruby, tmpBlock);
        int i = 0;
        while (i < args.size()) {
            if (args.getRuby(i).kind_of(ruby.getClasses().getModuleClass()).isFalse()) {
                throw new TypeError(ruby, "class or module required for rescue clause");
            }
            if (actExcptn.kind_of((RubyModule)args.getRuby(i)).isTrue()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitRescueNode(this);
    }
}

