/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;
import org.jruby.nodes.ScopeNode;

public class SClassNode
extends Node {
    public SClassNode(Node recvNode, Node bodyNode) {
        super(82, (Object)recvNode, (Object)bodyNode, null);
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        RubyClass rubyClass = (RubyClass)this.getRecvNode().eval(ruby, self);
        if (rubyClass.isSpecialConst()) {
            throw new TypeError(ruby, "no virtual class for " + rubyClass.getRubyClass().toName());
        }
        if (ruby.getSafeLevel() >= 4 && !rubyClass.isTaint()) {
            throw new RubySecurityException(ruby, "Insecure: can't extend object");
        }
        if (rubyClass.getRubyClass().isSingleton()) {
            // empty if block
        }
        ruby.setRubyClass(rubyClass.getSingletonClass());
        if (ruby.getWrapper() != null) {
            rubyClass.getSingletonClass().includeModule(ruby.getWrapper());
            rubyClass.includeModule(ruby.getWrapper());
        }
        return ((ScopeNode)this.getBodyNode()).setupModule(ruby, rubyClass);
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitSClassNode(this);
    }
}

