/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.ReturnException;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.nodes.CRefNode;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;
import org.jruby.nodes.types.AssignableNode;
import org.jruby.nodes.types.CallableNode;
import org.jruby.runtime.RubyVarmap;
import org.jruby.util.RubyPointer;
import org.jruby.util.collections.DelegateList;

public class ScopeNode
extends Node
implements CallableNode {
    public ScopeNode(List table, CRefNode refValue, Node nextNode) {
        super(3, (Object)table, (Object)refValue, (Object)nextNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject eval(Ruby ruby, RubyObject self) {
        RubyObject rubyObject;
        CRefNode savedCRef = null;
        ruby.getRubyFrame().tmpPush();
        ruby.getScope().push();
        CRefNode lRefValue = this.getRefValue();
        if (lRefValue != null) {
            savedCRef = ruby.getCRef();
            ruby.setCRef(lRefValue);
            ruby.getRubyFrame().setCbase(lRefValue);
        }
        if (this.getTable() != null) {
            ruby.getScope().setLocalValues(new ArrayList<RubyObject>(Collections.nCopies(this.getTable().size(), ruby.getNil())));
            ruby.getScope().setLocalNames(this.getTable());
        }
        try {
            rubyObject = this.getNextNode().eval(ruby, self);
            Object var7_6 = null;
            ruby.getScope().pop();
        }
        catch (Throwable throwable) {
            block5: {
                Object var7_7 = null;
                ruby.getScope().pop();
                ruby.getRubyFrame().tmpPop();
                if (savedCRef == null) break block5;
                ruby.setCRef(savedCRef);
            }
            throw throwable;
        }
        ruby.getRubyFrame().tmpPop();
        if (savedCRef != null) {
            ruby.setCRef(savedCRef);
        }
        return rubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject setupModule(Ruby ruby, RubyModule module) {
        RubyObject rubyObject;
        String file = ruby.getSourceFile();
        int line = ruby.getSourceLine();
        ruby.getRubyFrame().tmpPush();
        ruby.pushClass();
        ruby.setRubyClass(module);
        ruby.setCBase(module);
        ruby.getScope().push();
        RubyVarmap.push(ruby);
        if (this.getTable() != null) {
            ruby.getScope().setLocalValues(new ArrayList<RubyObject>(Collections.nCopies(this.getTable().size(), ruby.getNil())));
            ruby.getScope().setLocalNames(this.getTable());
        } else {
            ruby.getScope().setLocalValues(null);
            ruby.getScope().setLocalNames(null);
        }
        ruby.getCRef().push(module);
        ruby.getRubyFrame().setCbase(ruby.getCRef());
        try {
            rubyObject = ruby.getRubyClass().eval(this.getNextNode());
            Object var7_6 = null;
            ruby.getCRef().pop();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ruby.getCRef().pop();
            RubyVarmap.pop(ruby);
            ruby.getScope().pop();
            ruby.popClass();
            ruby.getRubyFrame().tmpPop();
            throw throwable;
        }
        RubyVarmap.pop(ruby);
        ruby.getScope().pop();
        ruby.popClass();
        ruby.getRubyFrame().tmpPop();
        return rubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RubyObject call(Ruby ruby, RubyObject recv, String id, RubyPointer args, boolean noSuper) {
        RubyObject i22;
        if (args == null) {
            args = new RubyPointer();
        }
        CRefNode savedCref = null;
        ArrayList<RubyObject> valueList = null;
        ruby.getScope().push();
        CRefNode lRefValue = this.getRefValue();
        if (lRefValue != null) {
            savedCref = ruby.getCRef();
            ruby.setCRef(lRefValue);
            ruby.getRubyFrame().setCbase(lRefValue);
        }
        if (this.getTable() != null) {
            valueList = new ArrayList<RubyObject>(Collections.nCopies(this.getTable().size(), ruby.getNil()));
            ruby.getScope().setLocalValues(valueList);
            ruby.getScope().setLocalNames(this.getTable());
        } else {
            valueList = null;
            ruby.getScope().setLocalValues(null);
            ruby.getScope().setLocalNames(null);
        }
        Node callBody = this.getNextNode();
        Node callNode = null;
        if (callBody.getType() == 67) {
            callNode = callBody;
            callBody = null;
        } else if (callBody.getType() == 4) {
            callNode = callBody.getHeadNode();
            callBody = callBody.getNextNode();
        }
        RubyVarmap.push(ruby);
        try {
            try {
                block22: {
                    int i22;
                    block23: {
                        if (callNode == null) break block22;
                        i22 = callNode.getCount();
                        if (i22 > (args != null ? args.size() : 0)) {
                            int size = 0;
                            if (args == null) throw new RubyArgumentException(ruby, this.getFile() + ":" + this.getLine() + "wrong # of arguments(" + size + " for " + i22 + ")");
                            size = args.size();
                            throw new RubyArgumentException(ruby, this.getFile() + ":" + this.getLine() + "wrong # of arguments(" + size + " for " + i22 + ")");
                        }
                        if (callNode.getRest() != -1) break block23;
                        int opt = i22;
                        Node optNode = callNode.getOptNode();
                        while (true) {
                            block24: {
                                if (optNode != null) break block24;
                            }
                            ++opt;
                            optNode = optNode.getNextNode();
                        }
                        if (opt < (args != null ? args.size() : 0)) {
                            throw new RubyArgumentException(ruby, "wrong # of arguments(" + args.size() + " for " + opt + ")");
                        }
                        ruby.getRubyFrame().setArgs(valueList != null ? new DelegateList(valueList, 2, valueList.size()) : null);
                    }
                    if (valueList != null) {
                        if (i22 > 0) {
                            int j = 0;
                            while (j < i22) {
                                valueList.set(j + 2, (RubyObject)args.get(j));
                                ++j;
                            }
                        }
                        args.inc(i22);
                        if (callNode.getOptNode() != null) {
                            Node optNode = callNode.getOptNode();
                            while (true) {
                                if (optNode == null || args.size() == 0) {
                                    recv.eval(optNode);
                                    break;
                                }
                                ((AssignableNode)((Object)optNode.getHeadNode())).assign(ruby, recv, args.getRuby(0), true);
                                args.inc(1);
                                optNode = optNode.getNextNode();
                            }
                        }
                        if (callNode.getRest() >= 0) {
                            RubyArray array = null;
                            array = args.size() > 0 ? RubyArray.newArray(ruby, args) : RubyArray.newArray(ruby, 0L);
                            valueList.set(callNode.getRest(), array);
                        }
                    }
                }
                i22 = recv.eval(callBody);
                Object var15_20 = null;
            }
            catch (ReturnException rExcptn) {
                RubyObject rubyObject = rExcptn.getReturnValue();
                Object var15_21 = null;
                RubyVarmap.pop(ruby);
                ruby.getScope().pop();
                if (savedCref == null) return rubyObject;
                ruby.setCRef(savedCref);
                return rubyObject;
            }
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            RubyVarmap.pop(ruby);
            ruby.getScope().pop();
            if (savedCref == null) throw throwable;
            ruby.setCRef(savedCref);
            throw throwable;
        }
        RubyVarmap.pop(ruby);
        ruby.getScope().pop();
        if (savedCref == null) return i22;
        ruby.setCRef(savedCref);
        return i22;
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitScopeNode(this);
    }
}

