/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.nodes.Node;
import org.jruby.runtime.RubyFrame;
import org.jruby.runtime.RubyVarmap;
import org.jruby.runtime.Scope;

public class RubyBlock {
    public static final int BLOCK_D_SCOPE = 1;
    public static final int BLOCK_DYNAMIC = 2;
    public static final int BLOCK_ORPHAN = 4;
    public Node var;
    public Node body;
    public RubyObject self;
    public RubyFrame frame;
    public Scope scope;
    public RubyModule klass;
    public int iter;
    public int vmode;
    public int flags;
    public RubyVarmap dynamicVars;
    public RubyObject origThread;
    public RubyBlock prev;
    private Ruby ruby;

    public RubyBlock(Ruby ruby) {
        this.ruby = ruby;
    }

    protected RubyBlock(Node var, Node body, RubyObject self, RubyFrame frame, Scope scope, RubyModule klass, int iter, int vmode, int flags, RubyVarmap dynamicVars, RubyObject origThread, RubyBlock prev, Ruby ruby) {
        this(ruby);
        this.var = var;
        this.body = body;
        this.self = self;
        this.frame = frame;
        this.scope = scope;
        this.klass = klass;
        this.iter = iter;
        this.vmode = vmode;
        this.flags = flags;
        this.dynamicVars = dynamicVars;
        this.origThread = origThread;
        this.prev = prev;
    }

    public void push(Node v, Node b, RubyObject newSelf) {
        RubyBlock oldBlock = new RubyBlock(this.var, this.body, this.self, this.frame, this.scope, this.klass, this.iter, this.vmode, this.flags, this.dynamicVars, this.origThread, this.prev, this.ruby);
        this.var = v;
        this.body = b;
        this.self = newSelf;
        this.frame = this.ruby.getRubyFrame();
        this.klass = this.ruby.getRubyClass();
        this.frame.setFile(this.ruby.getSourceFile());
        this.frame.setLine(this.ruby.getSourceLine());
        this.scope = (Scope)this.ruby.getScope().getTop();
        this.prev = oldBlock;
        this.iter = this.ruby.getIter().getIter();
        this.vmode = this.ruby.getActMethodScope();
        this.flags = 1;
        this.dynamicVars = this.ruby.getDynamicVars();
    }

    public void pop() {
        if (this.prev == null) {
            this.ruby.getRuntime().printBug("Try to pop block from empty stack.");
            return;
        }
        this.var = this.prev.var;
        this.body = this.prev.body;
        this.self = this.prev.self;
        this.frame = this.prev.frame;
        this.scope = this.prev.scope;
        this.klass = this.prev.klass;
        this.iter = this.prev.iter;
        this.vmode = this.prev.vmode;
        this.flags = this.prev.flags;
        this.dynamicVars = this.prev.dynamicVars;
        this.origThread = this.prev.origThread;
        this.prev = this.prev.prev;
    }

    public RubyBlock getTmp() {
        return new RubyBlock(this.var, this.body, this.self, this.frame, this.scope, this.klass, this.iter, this.vmode, this.flags, this.dynamicVars, this.origThread, this.prev, this.ruby);
    }

    public RubyBlock cloneBlock() {
        return new RubyBlock(this.var, this.body, this.self, this.frame, this.scope, this.klass, this.iter, this.vmode, this.flags, this.dynamicVars, this.origThread, this.prev, this.ruby);
    }

    public void setTmp(RubyBlock block) {
        this.var = block.var;
        this.body = block.body;
        this.self = block.self;
        this.frame = block.frame;
        this.scope = block.scope;
        this.klass = block.klass;
        this.iter = block.iter;
        this.vmode = block.vmode;
        this.flags = block.flags;
        this.dynamicVars = block.dynamicVars;
        this.origThread = block.origThread;
        this.prev = block.prev;
    }

    static {
        BLOCK_D_SCOPE = 1;
        BLOCK_DYNAMIC = 2;
        BLOCK_ORPHAN = 4;
    }
}

