/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyClass;

public class RubyExceptions {
    private RubyClass systemExit = null;
    private RubyClass fatal = null;
    private RubyClass interrupt = null;
    private RubyClass signalException = null;
    private RubyClass standardError = null;
    private RubyClass typeError = null;
    private RubyClass argumentError = null;
    private RubyClass indexError = null;
    private RubyClass rangeError = null;
    private RubyClass scriptError = null;
    private RubyClass syntaxError = null;
    private RubyClass nameError = null;
    private RubyClass loadError = null;
    private RubyClass notImplementedError = null;
    private RubyClass runtimeError = null;
    private RubyClass securityError = null;
    private RubyClass noMemError = null;
    private RubyClass regexpError = null;
    private RubyClass ioError = null;
    private RubyClass eofError = null;
    private Ruby ruby = null;

    public RubyExceptions(Ruby ruby) {
        this.ruby = ruby;
    }

    public void initDefaultExceptionClasses() {
        RubyClass exceptionClass = this.ruby.getClasses().getExceptionClass();
        this.systemExit = this.ruby.defineClass("SystemExit", exceptionClass);
        this.fatal = this.ruby.defineClass("Fatal", exceptionClass);
        this.interrupt = this.ruby.defineClass("Interrupt", exceptionClass);
        this.signalException = this.ruby.defineClass("SignalException", exceptionClass);
        this.standardError = this.ruby.defineClass("StandardError", exceptionClass);
        this.typeError = this.ruby.defineClass("TypeError", this.standardError);
        this.argumentError = this.ruby.defineClass("ArgumentError", this.standardError);
        this.indexError = this.ruby.defineClass("IndexError", this.standardError);
        this.rangeError = this.ruby.defineClass("RangeError", this.standardError);
        this.scriptError = this.ruby.defineClass("ScriptError", exceptionClass);
        this.syntaxError = this.ruby.defineClass("SyntaxError", this.scriptError);
        this.nameError = this.ruby.defineClass("NameError", this.scriptError);
        this.loadError = this.ruby.defineClass("LoadError", this.scriptError);
        this.notImplementedError = this.ruby.defineClass("NotImplementedError", this.scriptError);
        this.runtimeError = this.ruby.defineClass("RuntimeError", this.standardError);
        this.securityError = this.ruby.defineClass("SecurityError", this.standardError);
        this.noMemError = this.ruby.defineClass("NoMemError", exceptionClass);
        this.regexpError = this.ruby.defineClass("RegexpError", this.standardError);
        this.ioError = this.ruby.defineClass("IOError", this.standardError);
        this.eofError = this.ruby.defineClass("EOFError", this.ioError);
    }

    public RubyClass getArgumentError() {
        return this.argumentError;
    }

    public RubyClass getFatal() {
        return this.fatal;
    }

    public RubyClass getIndexError() {
        return this.indexError;
    }

    public RubyClass getInterrupt() {
        return this.interrupt;
    }

    public RubyClass getLoadError() {
        return this.loadError;
    }

    public RubyClass getNameError() {
        return this.nameError;
    }

    public RubyClass getNoMemError() {
        return this.noMemError;
    }

    public RubyClass getNotImplementedError() {
        return this.notImplementedError;
    }

    public RubyClass getRangeError() {
        return this.rangeError;
    }

    public RubyClass getRuntimeError() {
        return this.runtimeError;
    }

    public RubyClass getScriptError() {
        return this.scriptError;
    }

    public RubyClass getSecurityError() {
        return this.securityError;
    }

    public RubyClass getSignalException() {
        return this.signalException;
    }

    public RubyClass getStandardError() {
        return this.standardError;
    }

    public RubyClass getSyntaxError() {
        return this.syntaxError;
    }

    public RubyClass getSystemExit() {
        return this.systemExit;
    }

    public RubyClass getTypeError() {
        return this.typeError;
    }

    public RubyClass getRegexpError() {
        return this.regexpError;
    }

    public RubyClass getIOError() {
        return this.ioError;
    }

    public RubyClass getEOFError() {
        return this.eofError;
    }
}

