/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.scanner;

import org.jruby.scanner.IToken;

public final class Token
implements IToken {
    private int type;
    private int line;
    private int column;
    private Object data;

    public Token(int type, int line, int column) {
        this(type, line, column, null);
    }

    public Token(int type, int line, int column, Object data) {
        this.type = type;
        this.line = line;
        this.column = column;
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public Object getData() {
        return this.data;
    }

    public int hashCode() {
        return this.getType() ^ this.getLine() ^ this.getColumn() ^ this.getData().hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof IToken) {
            return this.getType() == ((IToken)other).getType() && this.getLine() == ((IToken)other).getLine() && this.getColumn() == ((IToken)other).getColumn() && (this.getData() != null ? this.getData().equals(((IToken)other).getData()) : ((IToken)other).getData() == null);
        }
        return false;
    }

    public String toString() {
        return "Token: Type = " + this.getType() + "; Line = " + this.getLine() + "; Column = " + this.getColumn() + "; Data = \"" + String.valueOf(this.getData()) + "\"";
    }
}

