/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.AbstractList;
import java.util.List;

public class DelegateList
extends AbstractList {
    private List delegate = null;
    private int from = 0;
    private int to = 0;

    public DelegateList(List delegate, int from, int to) {
        this.delegate = delegate;
        if (from > to) {
            throw new IllegalArgumentException("from > to");
        }
        if (to > delegate.size()) {
            throw new IllegalArgumentException("to > delegate.size()");
        }
        this.from = from;
        this.to = to;
    }

    public Object get(int index) {
        if (index < this.from || index >= this.to) {
            throw new IndexOutOfBoundsException("index must be: from <= index < to");
        }
        return this.delegate.get(index + this.from);
    }

    public int size() {
        return this.to - this.from;
    }
}

