/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.ablaf.ast.INode;
import org.jruby.Ruby;
import org.jruby.RubyGlobal;
import org.jruby.RubyKernel;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThrowJump;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.ParserSupport;
import org.jruby.runtime.builtin.IRubyObject;

public class Main {
    private static Class sRegexpAdapter;
    private static ArrayList sLoadDirectories;
    private static String sScript;
    private static String sFileName;
    private static ArrayList sRequireFirst;
    private static boolean sYyDebug;
    private static boolean sBenchmarkMode;
    private static boolean sCheckOnly;
    private static boolean sDoLoop;
    private static boolean sDoPrint;
    private static boolean sDoLine;
    private static boolean sDoSplit;
    private static boolean warning;
    private static boolean version;
    static boolean sPrintedUsage;

    private static String grabValue(String[] args, String errorMessage, ArgIter ioIter) {
        if (++ioIter.idxChar < args[ioIter.idxArg].length()) {
            return args[ioIter.idxArg].substring(ioIter.idxChar);
        }
        if (++ioIter.idxArg < args.length) {
            return args[ioIter.idxArg];
        }
        System.err.println("invalid argument " + ioIter.idxArg);
        System.err.println(errorMessage);
        Main.printUsage();
        System.exit(1);
        return null;
    }

    private static String[] processArgs(String[] args) {
        int lenArg = args.length;
        StringBuffer lBuf = new StringBuffer();
        ArgIter lIter = new ArgIter();
        while (lIter.idxArg < lenArg) {
            if (args[lIter.idxArg].charAt(0) != '-') {
                if (lBuf.length() != 0) break;
                sFileName = args[lIter.idxArg++];
                break;
            }
            lIter.idxChar = 1;
            block22: while (lIter.idxChar < args[lIter.idxArg].length()) {
                switch (args[lIter.idxArg].charAt(lIter.idxChar)) {
                    case 'h': {
                        Main.printUsage();
                        break;
                    }
                    case 'I': {
                        sLoadDirectories.add(Main.grabValue(args, " -I must be followed by a directory name to add to lib path", lIter));
                        break block22;
                    }
                    case 'r': {
                        sRequireFirst.add(Main.grabValue(args, "-r must be followed by a package to require", lIter));
                        break block22;
                    }
                    case 'e': {
                        lBuf.append(Main.grabValue(args, " -e must be followed by an expression to evaluate", lIter)).append("\n");
                        break block22;
                    }
                    case 'b': {
                        sBenchmarkMode = true;
                        break;
                    }
                    case 'R': {
                        String lRegexpAdapter = Main.grabValue(args, " -R must be followed by an expression to evaluate", lIter);
                        try {
                            sRegexpAdapter = Class.forName(lRegexpAdapter);
                        }
                        catch (ClassNotFoundException cnfExcptn_0) {
                            try {
                                sRegexpAdapter = Class.forName("org.jruby.regexp." + lRegexpAdapter + "RegexpAdapter");
                            }
                            catch (ClassNotFoundException cnfExcptn_1) {
                                System.err.println("invalid argument " + lIter.idxArg);
                                System.err.println("failed to load RegexpAdapter: " + args[lIter.idxArg]);
                                System.err.println("defaulting to default RegexpAdapter: GNURegexpAdapter");
                            }
                        }
                        break block22;
                    }
                    case 'c': {
                        sCheckOnly = true;
                        break;
                    }
                    case 'y': {
                        sYyDebug = true;
                        break;
                    }
                    case 'p': {
                        sDoPrint = true;
                    }
                    case 'n': {
                        sDoLoop = true;
                        break;
                    }
                    case 'a': {
                        sDoSplit = true;
                        break;
                    }
                    case 'l': {
                        sDoLine = true;
                        break;
                    }
                    case 'v': {
                        System.out.println("ruby 1.6 () [java]");
                        warning = true;
                        break;
                    }
                    case 'w': {
                        warning = true;
                        break;
                    }
                    case '-': {
                        if (args[lIter.idxArg].equals("--version")) {
                            version = true;
                            break block22;
                        }
                    }
                    default: {
                        System.err.println("unknown option " + args[lIter.idxArg].charAt(lIter.idxChar));
                        System.exit(1);
                    }
                }
                ++lIter.idxChar;
            }
            ++lIter.idxArg;
        }
        sScript = lBuf.toString();
        String[] lRet = new String[lenArg - lIter.idxArg];
        System.arraycopy(args, lIter.idxArg, lRet, 0, lRet.length);
        return lRet;
    }

    public static void main(String[] args) {
        long now = -1L;
        String[] argv = Main.processArgs(args);
        if (version) {
            System.out.print("ruby ");
            System.out.print("1.6.7");
            System.out.print(" (");
            System.out.print("2002-08-08");
            System.out.print(") [");
            System.out.print("java");
            System.out.println("]");
            return;
        }
        if (sBenchmarkMode) {
            now = System.currentTimeMillis();
        }
        if (sScript.length() > 0) {
            Main.runInterpreter(new StringReader(sScript), "-e", argv);
        } else if (sFileName != null) {
            Main.runInterpreterOnFile(sFileName, argv);
        } else {
            System.err.println("nothing to interpret");
            Main.printUsage();
            return;
        }
        if (now != -1L) {
            System.out.println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
        }
    }

    protected static void printUsage() {
        if (!sPrintedUsage) {
            System.out.println("Usage: jruby [switches] [rubyfile.rb] [arguments]");
            System.out.println("    -e 'command'    one line of script. Several -e's allowed. Omit [programfile]");
            System.out.println("    -b              benchmark mode, times the script execution");
            System.out.println("    -Idirectory     specify $LOAD_PATH directory (may be used more than once)");
            System.out.println("    -R 'class'     The adapter class for the regexp engine, for now can be:");
            System.out.println("                    org.jruby.regexp.GNURegexpAdapter or org.jruby.regexp.JDKRegexpAdapter");
            System.out.println("    -c \t\t\t\tcheck syntax and dump parse tree");
            System.out.println("    -y \t\t\t\tactivate parser traces.");
            sPrintedUsage = true;
        }
    }

    protected static void runInterpreter(Reader iReader2Eval, String iFileName, String[] args) {
        Ruby ruby = Ruby.getDefaultInstance(sRegexpAdapter);
        IRubyObject lArgv = JavaUtil.convertJavaToRuby(ruby, args);
        ruby.setVerbose(warning);
        ruby.defineReadonlyVariable("$VERBOSE", warning ? ruby.getTrue() : ruby.getNil());
        ruby.defineGlobalConstant("ARGV", lArgv);
        ruby.defineReadonlyVariable("$-p", sDoPrint ? ruby.getTrue() : ruby.getNil());
        ruby.defineReadonlyVariable("$-n", sDoLoop ? ruby.getTrue() : ruby.getNil());
        ruby.defineReadonlyVariable("$-a", sDoSplit ? ruby.getTrue() : ruby.getNil());
        ruby.defineReadonlyVariable("$-l", sDoLine ? ruby.getTrue() : ruby.getNil());
        ruby.defineReadonlyVariable("$*", lArgv);
        ruby.defineVariable(new RubyGlobal.StringGlobalVariable(ruby, "$0", RubyString.newString(ruby, iFileName)));
        ruby.getLoadService().init(ruby, sLoadDirectories);
        int lNbRequire = sRequireFirst.size();
        try {
            int i = 0;
            while (i < lNbRequire) {
                RubyKernel.require(ruby.getTopSelf(), new RubyString(ruby, (String)sRequireFirst.get(i)));
                ++i;
            }
            INode lScript = ruby.parse(iReader2Eval, iFileName);
            if (sDoPrint) {
                lScript = new ParserSupport().appendPrintToBlock(lScript);
            }
            if (sDoLoop) {
                lScript = new ParserSupport().appendWhileLoopToBlock(lScript, sDoLine, sDoSplit);
            }
            if (!sCheckOnly) {
                ruby.eval(lScript);
            }
        }
        catch (RaiseException rExcptn) {
            ruby.getRuntime().printError(rExcptn.getException());
        }
        catch (ThrowJump throwJump) {
            ruby.getRuntime().printError(throwJump.getNameError());
        }
    }

    protected static void runInterpreterOnFile(String fileName, String[] args) {
        File rubyFile = new File(fileName);
        if (!rubyFile.canRead()) {
            System.out.println("Cannot read Rubyfile: \"" + fileName + "\"");
        } else {
            try {
                BufferedReader br = new BufferedReader(new FileReader(rubyFile));
                Main.runInterpreter(br, fileName, args);
                br.close();
            }
            catch (IOException ioExcptn) {
                System.out.println("Cannot read Rubyfile: \"" + fileName + "\"");
                System.out.println("IOEception: " + ioExcptn.getMessage());
            }
        }
    }

    static {
        sLoadDirectories = new ArrayList();
        sScript = null;
        sFileName = null;
        sRequireFirst = new ArrayList();
        sYyDebug = false;
        sBenchmarkMode = false;
        sCheckOnly = false;
        sDoLoop = false;
        sDoPrint = false;
        sDoLine = false;
        sDoSplit = false;
        warning = false;
        version = false;
        sPrintedUsage = false;
    }

    private static class ArgIter {
        int idxArg;
        int idxChar;

        private ArgIter() {
        }
    }
}

