/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.ablaf.internal.lexer.DefaultLexerPosition;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyClasses;
import org.jruby.RubyFixnum;
import org.jruby.RubyGlobal;
import org.jruby.RubyIncludedClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.TopSelfFactory;
import org.jruby.common.IRubyErrorHandler;
import org.jruby.common.RubyErrorHandler;
import org.jruby.exceptions.BreakJump;
import org.jruby.exceptions.RetryException;
import org.jruby.exceptions.ReturnJump;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.internal.runtime.builtin.ObjectFactory;
import org.jruby.internal.runtime.methods.IterateMethod;
import org.jruby.internal.runtime.methods.RubyMethodCache;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.Parser;
import org.jruby.runtime.AliasGlobalVariable;
import org.jruby.runtime.BlockStack;
import org.jruby.runtime.Callback;
import org.jruby.runtime.Frame;
import org.jruby.runtime.FrameStack;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.LastCallStatus;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.ReadonlyGlobalVariable;
import org.jruby.runtime.RubyExceptions;
import org.jruby.runtime.RubyRuntime;
import org.jruby.runtime.Scope;
import org.jruby.runtime.ScopeStack;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IObjectFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ILoadService;
import org.jruby.runtime.load.LoadServiceFactory;
import org.jruby.runtime.regexp.IRegexpAdapter;
import org.jruby.util.Asserts;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyStack;
import org.jruby.util.collections.IStack;

public final class Ruby {
    private ThreadLocal threadContext = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadContext(Ruby.this);
        }
    };
    private RubyMethodCache methodCache;
    public int stackTraces = 0;
    private RubyMap globalMap;
    public ObjectSpace objectSpace = new ObjectSpace();
    public final RubyFixnum[] fixnumCache = new RubyFixnum[256];
    public final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable();
    public long randomSeed = 0L;
    public Random random = new Random();
    private int safeLevel = 0;
    private IObjectFactory factory = new ObjectFactory(this);
    private IRubyObject nilObject;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    private RubyClasses classes;
    private RubyExceptions exceptions;
    private final RubyRuntime runtime = new RubyRuntime(this);
    private IRubyObject topSelf;
    private Scope topScope = null;
    private Frame topFrame;
    private Namespace namespace;
    private Namespace topNamespace;
    private ISourcePosition sourcePosition = new DefaultLexerPosition(null, 0, 0);
    private boolean isVerbose = false;
    private RubyModule wrapper;
    private RubyStack classStack = new RubyStack();
    private JavaSupport javaSupport;
    private Class regexpAdapterClass;
    private Parser parser = new Parser(this);
    private LastCallStatus lastCallStatus = new LastCallStatus();
    private ILoadService loadService = LoadServiceFactory.createLoadService(this);
    private IRubyErrorHandler errorHandler = new RubyErrorHandler(this);

    private Ruby(Class regexpAdapterClass) {
        this.regexpAdapterClass = regexpAdapterClass;
        this.globalMap = new RubyHashMap();
        this.nilObject = RubyObject.nilObject(this);
        this.trueObject = new RubyBoolean(this, true);
        this.falseObject = new RubyBoolean(this, false);
        this.javaSupport = new JavaSupport(this);
        this.methodCache = new RubyMethodCache(this);
    }

    public static Ruby getDefaultInstance(Class regexpAdapterClass) {
        if (regexpAdapterClass == null) {
            regexpAdapterClass = IRegexpAdapter.getAdapterClass();
        }
        Ruby ruby = new Ruby(regexpAdapterClass);
        ruby.init();
        return ruby;
    }

    public Object evalScript(String script, Class returnClass) {
        IRubyObject result = this.evalScript(script);
        return JavaUtil.convertRubyToJava(this, result, returnClass);
    }

    public IRubyObject evalScript(String script) {
        return this.eval(this.parse(script, "<script>"));
    }

    public IRubyObject eval(INode node) {
        return this.getCurrentContext().eval(this, node);
    }

    public Class getRegexpAdapterClass() {
        return this.regexpAdapterClass;
    }

    public RubyClasses getClasses() {
        return this.classes;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public RubyModule getRubyModule(String name) {
        return this.classes.getClass(name);
    }

    public RubyClass getRubyClass(String name) {
        return (RubyClass)this.classes.getClass(name);
    }

    public RubyClass defineClass(String name, RubyClass superClass) {
        if (superClass == null) {
            superClass = this.getClasses().getObjectClass();
        }
        RubyClass newClass = RubyClass.newClass(this, superClass);
        newClass.setName(name);
        newClass.makeMetaClass(superClass.getInternalClass());
        newClass.inheritedBy(superClass);
        this.classes.putClass(name, newClass);
        return newClass;
    }

    public RubyClass defineClass(String name, String superName) {
        RubyClass superClass = this.getRubyClass(superName);
        Asserts.assertTrue(superClass != null, "can't find superclass '" + superName + "'");
        return this.defineClass(name, superClass);
    }

    public RubyModule defineModule(String name) {
        RubyModule newModule = RubyModule.newModule(this);
        newModule.setName(name);
        this.getClasses().putClass(name, newModule);
        return newModule;
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setSafeLevel(int safeLevel) {
        this.safeLevel = safeLevel;
    }

    public void secure(int level) {
        if (level <= this.safeLevel) {
            throw new RubySecurityException(this, "Insecure operation '" + this.getCurrentFrame().getLastFunc() + "' at level " + this.safeLevel);
        }
    }

    public void defineGlobalConstant(String name, IRubyObject value) {
        this.getClasses().getObjectClass().defineConstant(name, value);
    }

    public IRubyObject getTopConstant(String name) {
        IRubyObject constant = this.getClasses().getClass(name);
        if (constant == null) {
            constant = this.getLoadService().autoload(name);
        }
        return constant;
    }

    public boolean isClassDefined(String name) {
        return this.classes.getClass(name) != null;
    }

    public Iterator globalVariableNames() {
        return this.globalMap.keySet().iterator();
    }

    public boolean isGlobalVarDefined(String name) {
        return this.globalMap.containsKey(name);
    }

    public void undefineGlobalVar(String name) {
        this.globalMap.remove(name);
    }

    public IRubyObject setGlobalVar(String name, IRubyObject value) {
        GlobalVariable global = (GlobalVariable)this.globalMap.get(name);
        if (global == null) {
            this.globalMap.put(name, new GlobalVariable(this, name, value));
            return value;
        }
        global.set(value);
        return value;
    }

    public IRubyObject getGlobalVar(String name) {
        GlobalVariable global = (GlobalVariable)this.globalMap.get(name);
        if (global == null) {
            this.globalMap.put(name, new GlobalVariable(this, name, this.getNil()));
            return this.getNil();
        }
        return global.get();
    }

    public void aliasGlobalVar(String oldName, String newName) {
        if (this.getSafeLevel() >= 4) {
            throw new RubySecurityException(this, "Insecure: can't alias global variable");
        }
        if (!this.globalMap.containsKey(oldName)) {
            this.globalMap.put(oldName, new GlobalVariable(this, oldName, this.getNil()));
        }
        GlobalVariable oldEntry = (GlobalVariable)this.globalMap.get(oldName);
        this.globalMap.put(newName, new AliasGlobalVariable(this, newName, oldEntry));
    }

    public IRubyObject yield(IRubyObject value) {
        return this.yield(value, null, null, false);
    }

    public IRubyObject yield(IRubyObject value, IRubyObject self, RubyModule klass, boolean checkArguments) {
        return this.getCurrentContext().yield(value, self, klass, checkArguments);
    }

    public Scope currentScope() {
        return this.getScope().current();
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject iterate(Callback iterateMethod, IRubyObject data1, Callback blockMethod, IRubyObject data2) {
        IRubyObject iRubyObject;
        this.getIterStack().push(Iter.ITER_PRE);
        this.getBlockStack().push(null, new IterateMethod(blockMethod, data2), this.getTopSelf());
        try {
            while (true) {
                try {
                    iRubyObject = iterateMethod.execute(data1, null);
                    Object var9_7 = null;
                }
                catch (BreakJump bExcptn) {
                    IRubyObject iRubyObject2 = this.getNil();
                    Object var9_8 = null;
                    this.getIterStack().pop();
                    this.getBlockStack().pop();
                    return iRubyObject2;
                }
                catch (ReturnJump rExcptn) {
                    IRubyObject iRubyObject3 = rExcptn.getReturnValue();
                    Object var9_9 = null;
                    this.getIterStack().pop();
                    this.getBlockStack().pop();
                    return iRubyObject3;
                }
                catch (RetryException rExcptn) {
                    continue;
                }
                break;
            }
            this.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.getIterStack().pop();
            this.getBlockStack().pop();
            throw throwable;
        }
        this.getBlockStack().pop();
        return iRubyObject;
    }

    private void init() {
        this.getIterStack().push(Iter.ITER_NOT);
        this.getFrameStack().push();
        this.topFrame = this.getCurrentFrame();
        this.getScope().push();
        this.topScope = this.currentScope();
        this.setCurrentVisibility(Visibility.PRIVATE);
        try {
            this.classes = new RubyClasses(this);
            this.classes.initCoreClasses();
            RubyGlobal.createGlobals(this);
            this.exceptions = new RubyExceptions(this);
            this.exceptions.initDefaultExceptionClasses();
            this.topSelf = TopSelfFactory.createTopSelf(this);
            this.classStack.push(this.getClasses().getObjectClass());
            this.getCurrentFrame().setSelf(this.topSelf);
            this.namespace = this.topNamespace = new Namespace(this.getClasses().getObjectClass());
            this.getCurrentFrame().setNamespace(this.namespace);
        }
        catch (Exception excptn) {
            excptn.printStackTrace();
        }
        this.getScope().pop();
        this.getScope().push(this.topScope);
    }

    public ScopeStack getScope() {
        return this.getCurrentContext().getScopeStack();
    }

    public RubyMethodCache getMethodCache() {
        return this.methodCache;
    }

    public String getSourceFile() {
        return this.sourcePosition.getFile();
    }

    public int getSourceLine() {
        return this.sourcePosition.getLine();
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public boolean isBlockGiven() {
        return this.getCurrentFrame().isBlockGiven();
    }

    public boolean isFBlockGiven() {
        Frame previous = this.getFrameStack().getPrevious();
        if (previous == null) {
            return false;
        }
        return previous.isBlockGiven();
    }

    public void pushClass(RubyModule newClass) {
        this.classStack.push(newClass);
    }

    public void popClass() {
        this.classStack.pop();
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
        this.errorHandler.setVerbose(verbose);
    }

    public Map getDynamicVars() {
        return this.getCurrentContext().getCurrentDynamicVars();
    }

    public IRubyObject getDynamicValue(String name) {
        IRubyObject result = (IRubyObject)this.getDynamicVars().get(name);
        if (result == null) {
            return this.getNil();
        }
        return result;
    }

    public RubyModule getRubyClass() {
        RubyModule rubyClass = (RubyModule)this.classStack.peek();
        if (rubyClass.isIncluded()) {
            return ((RubyIncludedClass)rubyClass).getDelegate();
        }
        return rubyClass;
    }

    public FrameStack getFrameStack() {
        return this.getCurrentContext().getFrameStack();
    }

    public Frame getCurrentFrame() {
        return this.getCurrentContext().getCurrentFrame();
    }

    public Frame getTopFrame() {
        return this.topFrame;
    }

    public void setTopFrame(Frame topFrame) {
        this.topFrame = topFrame;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace newNamespace) {
        this.namespace = newNamespace;
    }

    public Namespace getTopNamespace() {
        return this.topNamespace;
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public IStack getIterStack() {
        return this.getCurrentContext().getIterStack();
    }

    public Iter getCurrentIter() {
        return this.getCurrentContext().getCurrentIter();
    }

    public BlockStack getBlockStack() {
        return this.getCurrentContext().getBlockStack();
    }

    public RubyModule getCBase() {
        return this.getCurrentFrame().getNamespace().getNamespaceModule();
    }

    public Visibility getCurrentVisibility() {
        return this.currentScope().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.currentScope().setVisibility(visibility);
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(RubyModule wrapper) {
        this.wrapper = wrapper;
    }

    public RubyRuntime getRuntime() {
        Asserts.assertTrue(this.runtime != null, "runtime shouldn't be null");
        return this.runtime;
    }

    public RubyExceptions getExceptions() {
        return this.exceptions;
    }

    public void defineVariable(GlobalVariable variable) {
        this.globalMap.put(variable.name(), variable);
    }

    public void defineReadonlyVariable(String name, IRubyObject value) {
        this.globalMap.put(name, new ReadonlyGlobalVariable(this, name, value));
    }

    public INode parse(Reader content, String file) {
        return this.parser.parse(file, content);
    }

    public INode parse(String content, String file) {
        return this.parser.parse(file, content);
    }

    public IRubyObject getLastline() {
        if (this.getScope().hasLocalValues()) {
            return this.getScope().getValue(0);
        }
        return RubyString.nilString(this);
    }

    public void setLastline(IRubyObject value) {
        if (!this.getScope().hasLocalValues()) {
            this.getScope().setLocalNames(new ArrayList<String>(Arrays.asList("_", "~")));
        }
        this.getScope().setValue(0, value);
    }

    public IRubyObject getBackref() {
        if (this.getScope().hasLocalValues()) {
            return this.getScope().getValue(1);
        }
        return this.getNil();
    }

    public void setBackref(IRubyObject match) {
        if (!this.getScope().hasLocalValues()) {
            this.getScope().setLocalNames(new ArrayList<String>(Arrays.asList("_", "~")));
        }
        this.getScope().setValue(1, match);
    }

    public Parser getParser() {
        return this.parser;
    }

    public ThreadContext getCurrentContext() {
        return (ThreadContext)this.threadContext.get();
    }

    public ISourcePosition getPosition() {
        return new DefaultLexerPosition(this.getSourceFile(), this.getSourceLine(), 0);
    }

    public void setPosition(String file, int line) {
        this.setPosition(new DefaultLexerPosition(file, line, 0));
    }

    public void setPosition(ISourcePosition position) {
        this.sourcePosition = position;
    }

    public void pushDynamicVars() {
        this.getCurrentContext().pushDynamicVars();
    }

    public void popDynamicVars() {
        this.getCurrentContext().getDynamicVarsStack().pop();
    }

    public void setDynamicVariable(String name, IRubyObject value) {
        this.getDynamicVars().put(name, value);
    }

    public List getDynamicNames() {
        return new ArrayList(this.getDynamicVars().keySet());
    }

    public IObjectFactory getFactory() {
        return this.factory;
    }

    public LastCallStatus getLastCallStatus() {
        return this.lastCallStatus;
    }

    public ILoadService getLoadService() {
        return this.loadService;
    }

    public IRubyErrorHandler getErrorHandler() {
        return this.errorHandler;
    }
}

