/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Asserts;

public class RubyFixnum
extends RubyInteger
implements IndexCallable {
    private long value;
    private static final int BIT_SIZE = 63;
    private static final int M_TO_F = 1;
    private static final int M_TO_S = 2;
    private static final int M_OP_LSHIFT = 3;
    private static final int M_OP_RSHIFT = 4;
    private static final int M_OP_PLUS = 5;
    private static final int M_OP_MINUS = 6;
    private static final int M_OP_MUL = 7;
    private static final int M_OP_DIV = 8;
    private static final int M_OP_MOD = 9;
    private static final int M_OP_POW = 10;
    private static final int M_EQUAL = 11;
    private static final int M_OP_CMP = 12;
    private static final int M_OP_GT = 13;
    private static final int M_OP_GE = 14;
    private static final int M_OP_LT = 15;
    private static final int M_OP_LE = 16;
    private static final int M_OP_AND = 17;
    private static final int M_SIZE = 20;
    private static final int M_HASH = 100;
    private static final int M_ID2NAME = 101;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$org$jruby$RubyInteger;

    public RubyFixnum(Ruby ruby) {
        this(ruby, 0L);
    }

    public RubyFixnum(Ruby ruby, long value) {
        super(ruby, ruby.getClasses().getFixnumClass());
        this.value = value;
    }

    public static RubyClass createFixnumClass(Ruby ruby) {
        RubyClass fixnumClass = ruby.defineClass("Fixnum", ruby.getClasses().getIntegerClass());
        fixnumClass.includeModule(ruby.getClasses().getPrecisionModule());
        fixnumClass.defineSingletonMethod("induced_from", CallbackFactory.getSingletonMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "induced_from", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyFixnum.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        fixnumClass.defineMethod("to_f", IndexedCallback.create(1, 0));
        fixnumClass.defineMethod("to_s", IndexedCallback.create(2, 0));
        fixnumClass.defineMethod("to_str", IndexedCallback.create(2, 0));
        fixnumClass.defineMethod("taint", CallbackFactory.getSelfMethod(0));
        fixnumClass.defineMethod("freeze", CallbackFactory.getSelfMethod(0));
        fixnumClass.defineMethod("<<", IndexedCallback.create(3, 1));
        fixnumClass.defineMethod(">>", IndexedCallback.create(4, 1));
        fixnumClass.defineMethod("+", IndexedCallback.create(5, 1));
        fixnumClass.defineMethod("-", IndexedCallback.create(6, 1));
        fixnumClass.defineMethod("*", IndexedCallback.create(7, 1));
        fixnumClass.defineMethod("/", IndexedCallback.create(8, 1));
        fixnumClass.defineMethod("%", IndexedCallback.create(9, 1));
        fixnumClass.defineMethod("**", IndexedCallback.create(10, 1));
        fixnumClass.defineMethod("==", IndexedCallback.create(11, 1));
        fixnumClass.defineMethod("eql?", IndexedCallback.create(11, 1));
        fixnumClass.defineMethod("equal?", IndexedCallback.create(11, 1));
        fixnumClass.defineMethod("<=>", IndexedCallback.create(12, 1));
        fixnumClass.defineMethod(">", IndexedCallback.create(13, 1));
        fixnumClass.defineMethod(">=", IndexedCallback.create(14, 1));
        fixnumClass.defineMethod("<", IndexedCallback.create(15, 1));
        fixnumClass.defineMethod("<=", IndexedCallback.create(16, 1));
        fixnumClass.defineMethod("&", IndexedCallback.create(17, 1));
        fixnumClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_or", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyFixnum.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        fixnumClass.defineMethod("^", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "op_xor", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyFixnum.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        fixnumClass.defineMethod("size", IndexedCallback.create(20, 0));
        fixnumClass.defineMethod("[]", CallbackFactory.getMethod(class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyFixnum.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum, "aref", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyFixnum.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        fixnumClass.defineMethod("hash", IndexedCallback.create(100, 0));
        fixnumClass.defineMethod("id2name", IndexedCallback.create(101, 0));
        return fixnumClass;
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 1: {
                return this.to_f();
            }
            case 2: {
                return this.to_s();
            }
            case 3: {
                return this.op_lshift(args[0]);
            }
            case 4: {
                return this.op_rshift(args[0]);
            }
            case 5: {
                return this.op_plus(args[0]);
            }
            case 6: {
                return this.op_minus(args[0]);
            }
            case 7: {
                return this.op_mul(args[0]);
            }
            case 8: {
                return this.op_div(args[0]);
            }
            case 9: {
                return this.op_mod(args[0]);
            }
            case 10: {
                return this.op_pow(args[0]);
            }
            case 11: {
                return this.equal(args[0]);
            }
            case 12: {
                return this.op_cmp(args[0]);
            }
            case 13: {
                return this.op_gt(args[0]);
            }
            case 14: {
                return this.op_ge(args[0]);
            }
            case 15: {
                return this.op_lt(args[0]);
            }
            case 16: {
                return this.op_le(args[0]);
            }
            case 17: {
                return this.op_and(args[0]);
            }
            case 20: {
                return this.size();
            }
            case 100: {
                return this.hash();
            }
            case 101: {
                return this.id2name();
            }
        }
        Asserts.assertNotReached();
        return null;
    }

    public Class getJavaClass() {
        return Long.TYPE;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public long getLongValue() {
        return this.value;
    }

    public static RubyFixnum zero(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, 0L);
    }

    public static RubyFixnum one(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, 1L);
    }

    public static RubyFixnum minus_one(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, -1L);
    }

    protected int compareValue(RubyNumeric other) {
        if (other instanceof RubyBignum) {
            return -((RubyBignum)other).compareValue(this);
        }
        if (other instanceof RubyFloat) {
            double otherVal = other.getDoubleValue();
            return (double)this.value > otherVal ? 1 : ((double)this.value < otherVal ? -1 : 0);
        }
        long otherVal = other.getLongValue();
        return this.value > otherVal ? 1 : (this.value < otherVal ? -1 : 0);
    }

    public RubyFixnum hash() {
        return this.newFixnum((int)this.value ^ (int)(this.value >> 32));
    }

    public static RubyFixnum newFixnum(Ruby ruby, long value) {
        RubyFixnum fixnum;
        if (value >= 0L && value < (long)ruby.fixnumCache.length) {
            fixnum = ruby.fixnumCache[(int)value];
            if (fixnum == null) {
                ruby.fixnumCache[(int)value] = fixnum = new RubyFixnum(ruby, value);
            }
        } else {
            fixnum = new RubyFixnum(ruby, value);
        }
        return fixnum;
    }

    public RubyFixnum newFixnum(long value) {
        return RubyFixnum.newFixnum(this.runtime, value);
    }

    public static RubyInteger induced_from(IRubyObject recv, IRubyObject number) {
        if (number instanceof RubyFixnum) {
            return (RubyFixnum)number;
        }
        if (number instanceof RubyFloat) {
            return ((RubyFloat)number).to_i();
        }
        if (number instanceof RubyBignum) {
            return RubyFixnum.newFixnum(recv.getRuntime(), ((RubyBignum)number).getLongValue());
        }
        return (RubyFixnum)number.convertToType("Fixnum", "to_int", true);
    }

    public RubyNumeric op_plus(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return ((RubyFloat)other).op_plus(this);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_plus(this);
        }
        long otherValue = other.getLongValue();
        long result = this.value + otherValue;
        if (this.value < 0L && otherValue < 0L && result > 0L || this.value > 0L && otherValue > 0L && result < 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_plus(other);
        }
        return this.newFixnum(result);
    }

    public RubyNumeric op_minus(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_minus(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(other);
        }
        long otherValue = other.getLongValue();
        long result = this.value - otherValue;
        if (this.value < 0L && otherValue > 0L && result > 0L || this.value > 0L && otherValue < 0L && result < 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(other);
        }
        return this.newFixnum(result);
    }

    public RubyNumeric op_mul(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_mul(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_mul(other);
        }
        long otherValue = other.getLongValue();
        long result = this.value * otherValue;
        if (result / otherValue == this.value) {
            return this.newFixnum(result);
        }
        return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_mul(other);
    }

    public RubyNumeric op_div(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_div(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_div(other);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue() / other.getLongValue());
    }

    public RubyNumeric op_mod(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_mod(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_mod(other);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue() % other.getLongValue());
    }

    public RubyNumeric op_pow(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_pow(other);
        }
        if (other.getLongValue() == 0L) {
            return RubyFixnum.newFixnum(this.getRuntime(), 1L);
        }
        if (other.getLongValue() == 1L) {
            return this;
        }
        if (other.getLongValue() > 1L) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_pow(other);
        }
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_pow(other);
    }

    public RubyBoolean equal(IRubyObject other) {
        if (!(other instanceof RubyNumeric)) {
            return this.getRuntime().getFalse();
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue((RubyNumeric)other) == 0);
    }

    public RubyNumeric op_cmp(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFixnum.newFixnum(this.getRuntime(), this.compareValue(other));
    }

    public RubyBoolean op_gt(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) > 0);
    }

    public RubyBoolean op_ge(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) >= 0);
    }

    public RubyBoolean op_lt(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) < 0);
    }

    public RubyBoolean op_le(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) <= 0);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuntime(), String.valueOf(this.getLongValue()));
    }

    public RubyFloat to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    public RubyInteger op_lshift(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        long width = other.getLongValue();
        if (width < 0L) {
            return this.op_rshift(other.op_uminus());
        }
        if (width > 63L || this.value >>> (int)(63L - width) > 0L) {
            RubyBignum lBigValue = new RubyBignum(this.runtime, RubyBignum.bigIntValue(this));
            return lBigValue.op_lshift(other);
        }
        return this.newFixnum(this.value << (int)width);
    }

    public RubyInteger op_rshift(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        long width = other.getLongValue();
        if (width < 0L) {
            return this.op_lshift(other.op_uminus());
        }
        return this.newFixnum(this.value >>> (int)width);
    }

    public RubyNumeric op_and(IRubyObject other) {
        RubyNumeric otherNumeric = RubyNumeric.numericValue(other);
        long otherLong = otherNumeric.getTruncatedLongValue();
        return this.newFixnum(this.value & otherLong);
    }

    public RubyInteger op_or(RubyInteger other) {
        if (other instanceof RubyBignum) {
            return (RubyInteger)other.callMethod("|", this);
        }
        return this.newFixnum(this.value | other.getLongValue());
    }

    public RubyInteger op_xor(RubyInteger other) {
        if (other instanceof RubyBignum) {
            return (RubyInteger)other.callMethod("^", this);
        }
        return this.newFixnum(this.value ^ other.getLongValue());
    }

    public RubyFixnum size() {
        return this.newFixnum(4L);
    }

    public RubyFixnum aref(RubyInteger pos) {
        long mask = 1 << (int)pos.getLongValue();
        return this.newFixnum((this.value & mask) == 0L ? 0L : 1L);
    }

    public RubySymbol id2name() {
        return RubySymbol.getSymbol(this.runtime, this.value);
    }

    public void marshalTo(MarshalStream output) throws IOException {
        if (this.value <= Integer.MAX_VALUE) {
            output.write(105);
            output.dumpInt((int)this.value);
        } else {
            output.dumpObject(RubyBignum.newBignum(this.runtime, this.value));
        }
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubyFixnum.newFixnum(input.getRuntime(), input.unmarshalInt());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BIT_SIZE = 63;
        M_TO_F = 1;
        M_TO_S = 2;
        M_OP_LSHIFT = 3;
        M_OP_RSHIFT = 4;
        M_OP_PLUS = 5;
        M_OP_MINUS = 6;
        M_OP_MUL = 7;
        M_OP_DIV = 8;
        M_OP_MOD = 9;
        M_OP_POW = 10;
        M_EQUAL = 11;
        M_OP_CMP = 12;
        M_OP_GT = 13;
        M_OP_GE = 14;
        M_OP_LT = 15;
        M_OP_LE = 16;
        M_OP_AND = 17;
        M_SIZE = 20;
        M_HASH = 100;
        M_ID2NAME = 101;
    }
}

