/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.exceptions.RubyIndexException;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyMatchData
extends RubyObject {
    private String str;
    private int[] begin;
    private int[] end;
    static /* synthetic */ Class class$org$jruby$RubyMatchData;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;

    public RubyMatchData(Ruby ruby, String str, int[] begin, int[] end) {
        super(ruby, ruby.getClasses().getMatchDataClass());
        this.str = str;
        this.begin = begin;
        this.end = end;
    }

    public static RubyClass createMatchDataClass(Ruby ruby) {
        RubyClass matchDataClass = ruby.defineClass("MatchData", ruby.getClasses().getObjectClass());
        ruby.defineGlobalConstant("MatchingData", matchDataClass);
        matchDataClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "rbClone"));
        matchDataClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "size"));
        matchDataClass.defineMethod("length", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "size"));
        matchDataClass.defineMethod("offset", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "offset", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyMatchData.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        matchDataClass.defineMethod("begin", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "begin", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyMatchData.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        matchDataClass.defineMethod("end", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "end", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyMatchData.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        matchDataClass.defineMethod("to_a", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "to_a"));
        matchDataClass.defineMethod("[]", CallbackFactory.getOptMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "aref"));
        matchDataClass.defineMethod("pre_match", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "pre_match"));
        matchDataClass.defineMethod("post_match", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "post_match"));
        matchDataClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "to_s"));
        matchDataClass.defineMethod("string", CallbackFactory.getMethod(class$org$jruby$RubyMatchData == null ? (class$org$jruby$RubyMatchData = RubyMatchData.class$("org.jruby.RubyMatchData")) : class$org$jruby$RubyMatchData, "string"));
        matchDataClass.getInternalClass().undefMethod("new");
        return matchDataClass;
    }

    public RubyArray subseq(long beg, long len) {
        if (beg > this.getSize()) {
            return RubyArray.nilArray(this.getRuntime());
        }
        if (beg < 0L || len < 0L) {
            return RubyArray.nilArray(this.getRuntime());
        }
        if (beg + len > this.getSize()) {
            len = this.getSize() - beg;
        }
        if (len < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return RubyArray.newArray(this.getRuntime());
        }
        RubyArray arr = RubyArray.newArray(this.getRuntime(), 0L);
        long i = beg;
        while (i < beg + len) {
            arr.append(this.group(i));
            ++i;
        }
        return arr;
    }

    public long getSize() {
        return this.begin.length;
    }

    public IRubyObject group(long n) {
        if (n < 0L || n >= this.getSize()) {
            return this.getRuntime().getNil();
        }
        return RubyString.newString(this.getRuntime(), this.str.substring(this.begin[(int)n], this.end[(int)n]));
    }

    public int matchStartPosition() {
        return this.begin[0];
    }

    public int matchEndPosition() {
        return this.end[0];
    }

    private boolean outOfBounds(RubyFixnum index) {
        long n = index.getLongValue();
        return n < 0L || n >= this.getSize();
    }

    public IRubyObject aref(IRubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        if (argc == 2) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            if (beg < 0L) {
                beg += this.getSize();
            }
            return this.subseq(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            return this.group(RubyNumeric.fix2long(args[0]));
        }
        if (args[0] instanceof RubyBignum) {
            throw new RubyIndexException(this.getRuntime(), "index too big");
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getSize(), true, false);
            if (begLen != null) {
                return this.getRuntime().getNil();
            }
            return this.subseq(begLen[0], begLen[1]);
        }
        return this.group(RubyNumeric.num2long(args[0]));
    }

    public IRubyObject begin(RubyFixnum index) {
        if (this.outOfBounds(index)) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.begin[(int)index.getLongValue()]);
    }

    public IRubyObject end(RubyFixnum index) {
        if (this.outOfBounds(index)) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.end[(int)index.getLongValue()]);
    }

    public RubyFixnum size() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.getSize());
    }

    public IRubyObject offset(RubyFixnum index) {
        if (this.outOfBounds(index)) {
            return this.getRuntime().getNil();
        }
        return RubyArray.newArray(this.getRuntime(), new IRubyObject[]{this.begin(index), this.end(index)});
    }

    public RubyString pre_match() {
        return RubyString.newString(this.getRuntime(), this.str.substring(0, this.begin[0]));
    }

    public RubyString post_match() {
        return RubyString.newString(this.getRuntime(), this.str.substring(this.end[0]));
    }

    public RubyString string() {
        return RubyString.newString(this.getRuntime(), this.str);
    }

    public RubyArray to_a() {
        return this.subseq(0L, this.begin.length);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuntime(), this.str.substring(this.begin[0], this.end[0]));
    }

    public IRubyObject rbClone() {
        int len = (int)this.getSize();
        int[] begin_p = new int[len];
        int[] end_p = new int[len];
        System.arraycopy(this.begin, 0, begin_p, 0, len);
        System.arraycopy(this.end, 0, end_p, 0, len);
        return new RubyMatchData(this.getRuntime(), this.str, begin_p, end_p);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

