/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.ArgumentError;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.Iter;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class RubyProc
extends RubyObject
implements IndexCallable {
    private Block block = null;
    private RubyModule wrapper = null;
    private static final int M_CALL = 1;
    private static final int M_AREF = 2;
    static /* synthetic */ Class class$org$jruby$RubyProc;

    public RubyProc(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createProcClass(Ruby ruby) {
        RubyClass procClass = ruby.defineClass("Proc", ruby.getClasses().getObjectClass());
        procClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyProc == null ? (class$org$jruby$RubyProc = RubyProc.class$("org.jruby.RubyProc")) : class$org$jruby$RubyProc, "newInstance"));
        procClass.defineMethod("call", IndexedCallback.createOptional(1));
        procClass.defineMethod("[]", IndexedCallback.createOptional(2));
        return procClass;
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 1: {
                return this.call(args);
            }
            case 2: {
                return this.call(args);
            }
        }
        Asserts.assertNotReached();
        return null;
    }

    public Block getBlock() {
        return this.block;
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public static RubyProc newInstance(IRubyObject receiver, IRubyObject[] args) {
        RubyProc proc = RubyProc.newProc(receiver.getRuntime(), receiver.getRuntime().getClasses().getProcClass());
        proc.callInit(args);
        return proc;
    }

    public static RubyProc newProc(Ruby ruby, RubyClass rubyClass) {
        if (!ruby.isBlockGiven() && !ruby.isFBlockGiven()) {
            throw new ArgumentError(ruby, "tried to create Proc object without a block");
        }
        RubyProc newProc = new RubyProc(ruby, rubyClass);
        newProc.block = ruby.getBlockStack().getCurrent().cloneBlock();
        newProc.wrapper = ruby.getWrapper();
        newProc.block.setIter(newProc.block.getNext() != null ? Iter.ITER_PRE : Iter.ITER_NOT);
        return newProc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(IRubyObject[] args) {
        RubyModule oldWrapper = this.getRuntime().getWrapper();
        this.getRuntime().setWrapper(this.wrapper);
        try {
            IRubyObject iRubyObject = this.block.call(args);
            Object var5_4 = null;
            this.getRuntime().setWrapper(oldWrapper);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getRuntime().setWrapper(oldWrapper);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        M_CALL = 1;
        M_AREF = 2;
    }
}

