/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyThread
extends RubyObject {
    protected Thread jvmThread;
    protected static boolean static_abort_on_exception;
    protected boolean abort_on_exception;
    static /* synthetic */ Class class$org$jruby$RubyThread;
    static /* synthetic */ Class class$org$jruby$RubyString;
    static /* synthetic */ Class class$org$jruby$RubyBoolean;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;
    static /* synthetic */ Class class$org$jruby$RubyException;

    public static RubyClass createThreadClass(Ruby ruby) {
        RubyClass threadClass = ruby.defineClass("Thread", ruby.getClasses().getObjectClass());
        threadClass.defineSingletonMethod("abort_on_exception", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "abort_on_exception", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyThread.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        threadClass.defineSingletonMethod("abort_on_exception=", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "abort_on_exception_set", class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyThread.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean));
        threadClass.defineSingletonMethod("critical", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "critical"));
        threadClass.defineSingletonMethod("critical=", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "critical_set", class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyThread.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean));
        threadClass.defineSingletonMethod("current", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "current"));
        threadClass.defineSingletonMethod("exit", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "exit"));
        threadClass.defineSingletonMethod("fork", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "newInstance"));
        threadClass.defineSingletonMethod("kill", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "kill", class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread));
        threadClass.defineSingletonMethod("list", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "list"));
        threadClass.defineSingletonMethod("main", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "main"));
        threadClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "newInstance"));
        threadClass.defineSingletonMethod("pass", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "pass"));
        threadClass.defineSingletonMethod("start", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "start"));
        threadClass.defineSingletonMethod("stop", CallbackFactory.getSingletonMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "stop"));
        threadClass.defineMethod("[]", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "aref", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyThread.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        threadClass.defineMethod("[]=", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "aset", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyThread.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject, class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyThread.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        threadClass.defineMethod("abort_on_exception", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "abort_on_exception"));
        threadClass.defineMethod("abort_on_exception=", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "abort_on_exception_set", class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyThread.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean));
        threadClass.defineMethod("alive?", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "is_alive"));
        threadClass.defineMethod("exit", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "exit"));
        threadClass.defineMethod("join", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "join"));
        threadClass.defineMethod("key?", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "has_key", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyThread.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        threadClass.defineMethod("kill", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "exit"));
        threadClass.defineMethod("priority", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "priority"));
        threadClass.defineMethod("priority=", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "priority_set", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyThread.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        threadClass.defineMethod("raise", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "raise", class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyThread.class$("org.jruby.RubyException")) : class$org$jruby$RubyException));
        threadClass.defineMethod("run", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "run"));
        threadClass.defineMethod("safe_level", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "safe_level"));
        threadClass.defineMethod("status", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "status"));
        threadClass.defineMethod("stop?", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "is_stopped"));
        threadClass.defineMethod("value", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "value"));
        threadClass.defineMethod("wakeup", CallbackFactory.getMethod(class$org$jruby$RubyThread == null ? (class$org$jruby$RubyThread = RubyThread.class$("org.jruby.RubyThread")) : class$org$jruby$RubyThread, "wakeup"));
        return threadClass;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        return RubyThread.startThread(recv, args, true);
    }

    public static RubyThread start(IRubyObject recv, IRubyObject[] args) {
        return RubyThread.startThread(recv, args, false);
    }

    protected static RubyThread startThread(final IRubyObject recv, final IRubyObject[] args, boolean callInit) {
        if (!recv.getRuntime().isBlockGiven()) {
            System.out.println("No block given to thread!");
        }
        final RubyThread result = new RubyThread(recv.getRuntime(), (RubyClass)recv);
        if (callInit) {
            result.callInit(args);
        }
        final RubyProc proc = RubyProc.newProc(recv.getRuntime(), recv.getRuntime().getClasses().getProcClass());
        final Frame currentFrame = recv.getRuntime().getCurrentFrame();
        final Block currentBlock = recv.getRuntime().getBlockStack().getCurrent();
        result.jvmThread = new Thread(new Runnable(){

            public void run() {
                recv.getRuntime().getFrameStack().push(currentFrame);
                recv.getRuntime().getBlockStack().setCurrent(currentBlock);
                recv.getRuntime().getCurrentContext().setCurrentThread(result);
                proc.call(args);
            }
        });
        result.jvmThread.start();
        return result;
    }

    protected RubyThread(Ruby ruby) {
        this(ruby, ruby.getClasses().getThreadClass());
    }

    protected RubyThread(Ruby ruby, RubyClass type) {
        super(ruby, type);
    }

    public static RubyBoolean abort_on_exception(IRubyObject recv) {
        return static_abort_on_exception ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static RubyBoolean abort_on_exception_set(IRubyObject recv, RubyBoolean val) {
        static_abort_on_exception = val.isTrue();
        return val;
    }

    public static RubyBoolean critical(IRubyObject recv) {
        throw new NotImplementedError();
    }

    public static RubyBoolean critical_set(IRubyObject recv, RubyBoolean val) {
        throw new NotImplementedError();
    }

    public static RubyThread current(IRubyObject recv) {
        return recv.getRuntime().getCurrentContext().getCurrentThread();
    }

    public static RubyArray list(IRubyObject recv) {
        ArrayList list = new ArrayList();
        Iterator iter = recv.getRuntime().objectSpace.iterator(recv.getRuntime().getClasses().getThreadClass());
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return RubyArray.newArray(recv.getRuntime(), list);
    }

    public IRubyObject aref(IRubyObject key) {
        if (!(key instanceof RubySymbol) || !(key instanceof RubyString)) {
            throw new ArgumentError(this.getRuntime(), key.inspect() + " is not a symbol");
        }
        IRubyObject result = (IRubyObject)this.runtime.getCurrentContext().getLocalVariables().get(key);
        if (result == null) {
            result = this.getRuntime().getNil();
        }
        return result;
    }

    public IRubyObject aset(IRubyObject key, IRubyObject val) {
        if (!(key instanceof RubySymbol) || !(key instanceof RubyString)) {
            throw new ArgumentError(this.getRuntime(), key.inspect() + " is not a symbol");
        }
        this.runtime.getCurrentContext().getLocalVariables().put(key, val);
        return val;
    }

    public RubyBoolean abort_on_exception() {
        return this.abort_on_exception ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyBoolean abort_on_exception_set(RubyBoolean val) {
        this.abort_on_exception = val.isTrue();
        return val;
    }

    public RubyBoolean is_alive() {
        return this.jvmThread.isAlive() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyThread join() {
        try {
            this.jvmThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }

    public RubyBoolean has_key(IRubyObject key) {
        return this.runtime.getCurrentContext().getLocalVariables().containsKey(key) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public RubyFixnum priority() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.jvmThread.getPriority());
    }

    public RubyFixnum priority_set(RubyFixnum priority) {
        this.jvmThread.setPriority((int)priority.getLongValue());
        return priority;
    }

    public void raise(RubyException exc) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class RubyThreadRunner
    implements Runnable {
        private IRubyObject[] args;
        private Ruby ruby;

        public RubyThreadRunner(Ruby ruby, IRubyObject[] args) {
            this.ruby = ruby;
            this.args = args;
        }

        public void run() {
            try {
                if (this.ruby == null) {
                    throw new RuntimeException("ruby is null!");
                }
                if (this.ruby.isBlockGiven()) {
                    System.out.println("THE BLOCK HAS PROPOGATED!!!");
                    this.ruby.yield(RubyArray.newArray(this.ruby, new ArrayList<IRubyObject>(Arrays.asList(this.args))));
                } else {
                    System.out.println("THE BLOCK HAS NOT PROPOGATED :(");
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t.toString());
            }
        }
    }
}

