/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.util;

import java.util.ArrayList;
import java.util.Iterator;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.ExpandArrayNode;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Iter;
import org.jruby.runtime.builtin.IRubyObject;

public final class ArgsUtil {
    public static final Block beginCallArgs(Ruby ruby) {
        Block currentBlock = ruby.getBlockStack().getCurrent();
        if (ruby.getCurrentIter().isPre()) {
            ruby.getBlockStack().pop();
        }
        ruby.getIterStack().push(Iter.ITER_NOT);
        return currentBlock;
    }

    public static final void endCallArgs(Ruby ruby, Block currentBlock) {
        if (currentBlock != null) {
            ruby.getBlockStack().push(currentBlock);
        }
        ruby.getIterStack().pop();
    }

    public static IRubyObject[] setupArgs(Ruby ruby, EvaluateVisitor visitor, INode node) {
        if (node == null) {
            return new IRubyObject[0];
        }
        ISourcePosition position = ruby.getPosition();
        if (node instanceof ArrayNode) {
            int size = ((ArrayNode)node).size();
            ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(size);
            Iterator iterator = ((ArrayNode)node).iterator();
            int i = 0;
            while (i < size) {
                INode next = (INode)iterator.next();
                if (next instanceof ExpandArrayNode) {
                    list.addAll(((RubyArray)visitor.eval(next)).getList());
                } else {
                    list.add(visitor.eval(next));
                }
                ++i;
            }
            ruby.setPosition(position);
            return list.toArray(new IRubyObject[list.size()]);
        }
        IRubyObject args = visitor.eval(node);
        ruby.setPosition(position);
        if (args instanceof RubyArray) {
            return ((RubyArray)args).toJavaArray();
        }
        return new IRubyObject[]{args};
    }
}

