/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.common;

import org.ablaf.common.ISourcePosition;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.common.IRubyErrorHandler;
import org.jruby.parser.SyntaxErrorState;

public class RubyErrorHandler
implements IRubyErrorHandler {
    private Ruby runtime;
    private boolean verbose = false;

    public RubyErrorHandler(Ruby runtime) {
        this.runtime = runtime;
    }

    public boolean isHandled(int type) {
        if (type == 2 || type == 5) {
            return this.verbose;
        }
        return true;
    }

    public void handleError(int type, ISourcePosition position, String message, Object args) {
        if (this.isHandled(type)) {
            if (type == 1 || type == 2) {
                message = "warning: " + message;
            }
            if (position != null) {
                message = position.getFile() + ": [" + position.getLine() + ", " + position.getColumn() + "] " + message;
            }
            this.runtime.getGlobalVar("$stderr").callMethod("write", RubyString.newString(this.runtime, message + "\n"));
            if (type == 10) {
                this.runtime.getGlobalVar("$stderr").callMethod("write", RubyString.newString(this.runtime, "\tExpecting:"));
                String[] lExpected = new String[]{};
                String lFound = "";
                if (args instanceof String[]) {
                    lExpected = (String[])args;
                } else if (args instanceof SyntaxErrorState) {
                    lExpected = ((SyntaxErrorState)args).expected();
                    lFound = ((SyntaxErrorState)args).found();
                }
                int i = 0;
                while (i < lExpected.length) {
                    String msg = lExpected[i];
                    this.runtime.getGlobalVar("$stderr").callMethod("write", RubyString.newString(this.runtime, " " + msg));
                    ++i;
                }
                this.runtime.getGlobalVar("$stderr").callMethod("write", RubyString.newString(this.runtime, " but found " + lFound + " instead\n"));
            }
        }
    }

    public void handleError(int type, ISourcePosition position, String message) {
        this.handleError(type, position, message, null);
    }

    public void handleError(int type, String message) {
        this.handleError(type, null, message, null);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void warn(String message) {
        this.handleError(1, this.runtime.getPosition(), message);
    }

    public void warning(String message) {
        this.handleError(2, this.runtime.getPosition(), message);
    }
}

