/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.load;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.exceptions.LoadError;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.runtime.load.ILoadService;

public class LoadService
implements ILoadService {
    private ArrayList loadPath = new ArrayList();
    private ArrayList loadedFeatures = new ArrayList();
    private Map autoloadMap = new HashMap();
    private Ruby runtime;

    public LoadService(Ruby runtime) {
        this.runtime = runtime;
    }

    public void init(Ruby runtime, List additionalDirectories) {
        Iterator iter = additionalDirectories.iterator();
        while (iter.hasNext()) {
            this.loadPath.add(RubyString.newString(runtime, (String)iter.next()));
        }
        if (runtime.getSafeLevel() == 0) {
            this.loadPath.add(RubyString.newString(runtime, System.getProperty("jruby.lib")));
        }
        String rubyDir = System.getProperty("jruby.home") + File.separatorChar + "lib" + File.separatorChar + "ruby" + File.separatorChar;
        this.loadPath.add(RubyString.newString(runtime, rubyDir + "site_ruby" + File.separatorChar + "1.6"));
        this.loadPath.add(RubyString.newString(runtime, rubyDir + "site_ruby" + File.separatorChar + "1.6" + File.separatorChar + "java"));
        this.loadPath.add(RubyString.newString(runtime, rubyDir + "site_ruby"));
        this.loadPath.add(RubyString.newString(runtime, rubyDir + "1.6"));
        this.loadPath.add(RubyString.newString(runtime, rubyDir + "1.6" + File.separatorChar + "java"));
        if (runtime.getSafeLevel() == 0) {
            this.loadPath.add(RubyString.newString(runtime, "."));
        }
    }

    public boolean load(String file) {
        if (file.endsWith(".jar")) {
            return false;
        }
        if (!file.endsWith(".rb")) {
            file = file + ".rb";
        }
        this.runtime.getRuntime().loadFile(this.findFile(file), false);
        return true;
    }

    public boolean require(String file) {
        RubyString name = RubyString.newString(this.runtime, file);
        if (!this.loadedFeatures.contains(name) && this.load(file)) {
            this.loadedFeatures.add(name);
            return true;
        }
        return false;
    }

    public ArrayList getLoadPath() {
        return this.loadPath;
    }

    public ArrayList getLoadedFeatures() {
        return this.loadedFeatures;
    }

    public boolean isAutoloadDefined(String name) {
        return this.autoloadMap.containsKey(name);
    }

    public IRubyObject autoload(String name) {
        IAutoloadMethod loadMethod = (IAutoloadMethod)this.autoloadMap.get(name);
        if (loadMethod != null) {
            return loadMethod.load(this.runtime, name);
        }
        return null;
    }

    public void addAutoload(String name, IAutoloadMethod loadMethod) {
        this.autoloadMap.put(name, loadMethod);
    }

    private File findFile(String name) {
        File current;
        int i = 0;
        int size = this.loadPath.size();
        while (i < size) {
            current = new File(this.loadPath.get(i).toString(), name);
            if (current.exists()) {
                return current;
            }
            ++i;
        }
        current = new File(name);
        if (current.exists()) {
            return current;
        }
        throw new LoadError(this.runtime, "No such file to load -- " + name);
    }
}

