/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.util.collections;

import java.util.Iterator;
import org.jruby.internal.util.Utils;
import org.jruby.internal.util.collections.LinkedObject;
import org.jruby.internal.util.collections.LinkedObjectIterator;
import org.jruby.util.collections.IStack;
import org.jruby.util.collections.StackEmptyException;

public class Stack
implements IStack {
    private static final LinkedObject EMPTY = new LinkedObject(null);
    protected LinkedObject top = EMPTY;

    public boolean isEmpty() {
        return this.top == EMPTY;
    }

    public Object peek() {
        return this.top.data;
    }

    public Object pop() {
        if (this.isEmpty()) {
            throw new StackEmptyException("Stack is empty.");
        }
        Object data = this.top.data;
        this.top = this.top.next;
        return data;
    }

    public IStack push(Object anObject) {
        this.top = new LinkedObject(anObject, this.top);
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof Stack && Utils.isEquals(this.top, ((Stack)obj).top);
    }

    public int hashCode() {
        return Utils.getHashcode(this.top);
    }

    public String toString() {
        LinkedObject next = this.top;
        StringBuffer sb = new StringBuffer(100);
        sb.append('[');
        while (next != null) {
            sb.append(next);
            if (next.next != null) {
                sb.append(", ");
            }
            next = next.next;
        }
        sb.append(']');
        return super.toString();
    }

    public Iterator iterator() {
        return new LinkedObjectIterator(this.top);
    }
}

