/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.jruby.RubyClass;
import org.jruby.RubyJavaObject;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Callback;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaConstructor
implements Callback {
    private Constructor[] constructors = null;

    public JavaConstructor(Constructor[] constructors) {
        this.constructors = constructors;
    }

    public int getArity() {
        return -1;
    }

    public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
        Constructor constructor = this.findMatchingConstructor(args);
        if (constructor == null) {
            throw new ArgumentError(recv.getRuntime(), "wrong arguments.");
        }
        int argsLength = args != null ? args.length : 0;
        Object[] newArgs = new Object[argsLength];
        int i = 0;
        while (i < argsLength) {
            newArgs[i] = JavaUtil.convertRubyToJava(recv.getRuntime(), args[i], constructor.getParameterTypes()[i]);
            ++i;
        }
        try {
            Object javaValue = constructor.newInstance(newArgs);
            RubyJavaObject javaObject = new RubyJavaObject(recv.getRuntime(), (RubyClass)recv, javaValue);
            javaObject.callInit(args);
            return javaObject;
        }
        catch (IllegalAccessException ex) {
            throw new RaiseException(recv.getRuntime(), "RuntimeError", ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new RaiseException(recv.getRuntime(), "RuntimeError", ex.getMessage());
        }
        catch (IllegalArgumentException ex) {
            throw new RaiseException(recv.getRuntime(), "RuntimeError", ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            recv.getRuntime().getJavaSupport().handleNativeException((Exception)ex.getTargetException());
            return recv.getRuntime().getNil();
        }
    }

    private Constructor findMatchingConstructor(IRubyObject[] args) {
        ArrayList<Constructor> executeConstructors = new ArrayList<Constructor>(this.constructors.length);
        int i = 0;
        while (i < this.constructors.length) {
            Constructor constructor = this.constructors[i];
            if (JavaConstructor.hasMatchingArguments(constructor, args)) {
                executeConstructors.add(constructor);
            }
            ++i;
        }
        if (executeConstructors.isEmpty()) {
            return null;
        }
        return (Constructor)executeConstructors.get(0);
    }

    private static boolean hasMatchingArgumentCount(Constructor constructor, int expected) {
        return constructor.getParameterTypes().length == expected;
    }

    private static boolean hasMatchingArguments(Constructor constructor, IRubyObject[] args) {
        int expectedLength;
        int n = expectedLength = args != null ? args.length : 0;
        if (!JavaConstructor.hasMatchingArgumentCount(constructor, expectedLength)) {
            return false;
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            if (!JavaUtil.isCompatible(args[i], parameterTypes[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

