/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Method;
import java.util.Set;
import org.jruby.RubyJavaInterface;
import org.jruby.RubyMethod;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.runtime.Callback;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaInterfaceMethod
implements Callback {
    private String methodName;
    private Set methodList;

    public JavaInterfaceMethod(String methodName, Set methodList) {
        this.methodName = methodName;
        this.methodList = methodList;
    }

    public int getArity() {
        return -1;
    }

    public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
        RubyProc proc = null;
        RubyMethod method = null;
        IRubyObject sendRecv = null;
        RubyString sendMethod = null;
        if (recv.getRuntime().isBlockGiven()) {
            proc = RubyProc.newProc(recv.getRuntime(), recv.getRuntime().getClasses().getProcClass());
        } else if (args.length == 2) {
            sendRecv = args[0];
            sendMethod = (RubyString)args[1];
        } else if (args.length == 1) {
            if (args[0] instanceof RubyProc) {
                proc = (RubyProc)args[0];
            } else if (args[0] instanceof RubyMethod) {
                method = (RubyMethod)args[0];
            } else {
                sendRecv = args[0];
                sendMethod = RubyString.newString(recv.getRuntime(), this.methodName);
            }
        }
        Method interfaceMethod = (Method)this.methodList.iterator().next();
        if (this.methodList.size() <= 1 || proc != null || method != null) {
            // empty if block
        }
        if (proc != null) {
            return RubyJavaInterface.newJavaInterface(recv.getRuntime(), interfaceMethod, proc);
        }
        if (method != null) {
            return RubyJavaInterface.newJavaInterface(recv.getRuntime(), interfaceMethod, method);
        }
        return RubyJavaInterface.newJavaInterface(recv.getRuntime(), interfaceMethod, sendRecv, sendMethod);
    }
}

