/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaEachMethod;
import org.jruby.javasupport.JavaFieldReader;
import org.jruby.javasupport.JavaFieldWriter;
import org.jruby.javasupport.JavaInterfaceConstructor;
import org.jruby.javasupport.JavaInterfaceMethod;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaSupport {
    private Ruby ruby;
    private Map loadedJavaClasses = new HashMap();
    private List importedPackages = new ArrayList();
    private Map renamedJavaClasses = new HashMap();
    private Map exceptionHandlers = new HashMap();
    private ClassLoader javaClassLoader = ClassLoader.getSystemClassLoader();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Exception;

    public JavaSupport(Ruby ruby) {
        this.ruby = ruby;
    }

    public RubyModule loadClass(Class javaClass, String rubyName) {
        if (javaClass == (class$java$lang$Object == null ? (class$java$lang$Object = JavaSupport.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.ruby.getClasses().getJavaObjectClass();
        }
        if (this.loadedJavaClasses.containsKey(javaClass)) {
            return (RubyModule)this.loadedJavaClasses.get(javaClass);
        }
        if (rubyName == null) {
            String javaName = javaClass.getName();
            rubyName = javaName.substring(javaName.lastIndexOf(46) + 1);
        }
        if (javaClass.isInterface()) {
            return this.createRubyInterface(javaClass, rubyName);
        }
        return this.createRubyClass(javaClass, rubyName);
    }

    private RubyClass createRubyClass(Class javaClass, String rubyName) {
        RubyClass superClass = (RubyClass)this.loadClass(javaClass.getSuperclass(), null);
        RubyClass rubyClass = this.ruby.defineClass(rubyName, superClass);
        this.loadedJavaClasses.put(javaClass, rubyClass);
        this.defineWrapperMethods(javaClass, rubyClass, true);
        this.defineConstants(javaClass, rubyClass);
        this.defineFields(javaClass, rubyClass);
        this.addDefaultModules(rubyClass);
        return rubyClass;
    }

    private RubyModule createRubyInterface(Class javaInterface, String rubyName) {
        RubyModule newInterface = this.ruby.defineModule(rubyName);
        Map methods = JavaSupport.getMethodsByName(javaInterface);
        Iterator iter = methods.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            newInterface.defineModuleFunction((String)entry.getKey(), new JavaInterfaceMethod((String)entry.getKey(), (Set)entry.getValue()));
        }
        newInterface.defineModuleFunction("new" + rubyName, new JavaInterfaceConstructor(javaInterface));
        return newInterface;
    }

    private static Map getMethodsByName(Class javaClass) {
        Method[] methods = javaClass.getMethods();
        List<Method> methodList = Arrays.asList(methods);
        HashMap result = new HashMap(methods.length);
        Iterator<Method> iter = methodList.iterator();
        while (iter.hasNext()) {
            Method method = iter.next();
            String name = method.getName();
            if (!result.containsKey(name)) {
                result.put(name, new HashSet());
            }
            ((Set)result.get(name)).add(method);
        }
        return result;
    }

    private void defineConstants(Class javaClass, RubyClass rubyClass) {
        Field[] fields = javaClass.getFields();
        int i = 0;
        while (i < fields.length) {
            int modifiers = fields[i].getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers)) {
                try {
                    String name = fields[i].getName();
                    name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                    rubyClass.defineConstant(name, JavaUtil.convertJavaToRuby(this.ruby, fields[i].get(null)));
                }
                catch (IllegalAccessException iaExcptn) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    private void defineFields(Class javaClass, RubyClass rubyClass) {
        Field[] fields = javaClass.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers)) {
                String name = field.getName();
                if (!rubyClass.isMethodDefined(name)) {
                    this.ruby.getMethodCache().clearByName(name);
                    rubyClass.defineMethod(name, new JavaFieldReader(field));
                }
                if (!rubyClass.isMethodDefined(name + "=")) {
                    this.ruby.getMethodCache().clearByName(name + "=");
                    rubyClass.defineMethod(name + "=", new JavaFieldWriter(field));
                }
            }
            ++i;
        }
    }

    private void defineWrapperMethods(Class javaClass, RubyClass rubyClass, boolean searchSuper) {
        HashMap methodMap = new HashMap();
        HashMap singletonMethodMap = new HashMap();
        Method[] methods = javaClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            String methodName = methods[i].getName();
            if (Modifier.isStatic(methods[i].getModifiers())) {
                if (singletonMethodMap.get(methodName) == null) {
                    singletonMethodMap.put(methodName, new LinkedList());
                }
                ((List)singletonMethodMap.get(methodName)).add(methods[i]);
            } else {
                if (methodMap.get(methodName) == null) {
                    methodMap.put(methodName, new LinkedList());
                }
                ((List)methodMap.get(methodName)).add(methods[i]);
            }
            ++i;
        }
        if (javaClass.getConstructors().length > 0) {
            rubyClass.defineSingletonMethod("new", new JavaConstructor(javaClass.getConstructors()));
        } else {
            rubyClass.getSingletonClass().undefMethod("new");
        }
        Iterator iter = methodMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            methods = ((List)entry.getValue()).toArray(new Method[((List)entry.getValue()).size()]);
            String javaName = (String)entry.getKey();
            String rubyName = this.toRubyName(javaName);
            rubyClass.defineMethod(javaName, new JavaMethod(methods, searchSuper));
            if (rubyClass.isMethodDefined(rubyName)) continue;
            rubyClass.defineAlias(rubyName, javaName);
        }
        iter = singletonMethodMap.entrySet().iterator();
        RubyClass singletonClass = rubyClass.getSingletonClass();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            methods = ((List)entry.getValue()).toArray(new Method[((List)entry.getValue()).size()]);
            String javaName = (String)entry.getKey();
            String rubyName = this.toRubyName(javaName);
            rubyClass.defineSingletonMethod(javaName, new JavaMethod(methods, searchSuper, true));
            if (singletonClass.isMethodDefined(rubyName)) continue;
            singletonClass.defineAlias(rubyName, javaName);
        }
    }

    private String toRubyName(String javaName) {
        if (javaName.equals("get")) {
            return "[]";
        }
        if (javaName.equals("set")) {
            return "[]=";
        }
        if (javaName.equals("getElementAt")) {
            return "[]";
        }
        if (javaName.equals("getValueAt")) {
            return "[]";
        }
        if (javaName.equals("setValueAt")) {
            return "[]=";
        }
        if (javaName.startsWith("get")) {
            return Character.toLowerCase(javaName.charAt(3)) + javaName.substring(4);
        }
        if (javaName.startsWith("is")) {
            return Character.toLowerCase(javaName.charAt(2)) + javaName.substring(3) + "?";
        }
        if (javaName.startsWith("can")) {
            return javaName + "?";
        }
        if (javaName.startsWith("has")) {
            return javaName + "?";
        }
        if (javaName.startsWith("set")) {
            return Character.toLowerCase(javaName.charAt(3)) + javaName.substring(4) + "=";
        }
        if (javaName.equals("compareTo")) {
            return "<=>";
        }
        return javaName;
    }

    private void addDefaultModules(RubyClass rubyClass) {
        if (rubyClass.isMethodDefined("hasNext") && rubyClass.isMethodDefined("next")) {
            rubyClass.includeModule(this.ruby.getClasses().getEnumerableModule());
            rubyClass.defineMethod("each", new JavaEachMethod("hasNext", "next"));
        } else if (rubyClass.isMethodDefined("hasNext") && rubyClass.isMethodDefined("next")) {
            rubyClass.includeModule(this.ruby.getClasses().getEnumerableModule());
            rubyClass.defineMethod("each", new JavaEachMethod("hasMoreElements", "nextElement"));
        }
        if (rubyClass.isMethodDefined("compareTo")) {
            rubyClass.includeModule(this.ruby.getClasses().getComparableModule());
            if (!rubyClass.isMethodDefined("<=>")) {
                rubyClass.defineAlias("<=>", "compareTo");
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public Class loadJavaClass(String className) {
        try {
            return this.javaClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException cnfExcptn) {
            iter = this.importedPackages.iterator();
            ** while (iter.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            packageName = (String)iter.next();
            try {
                return this.javaClassLoader.loadClass(packageName + "." + className);
            }
            catch (ClassNotFoundException cnfExcptn_) {
                // empty catch block
            }
            continue;
        }
lbl12:
        // 1 sources

        throw new NameError(this.ruby, "cannot load Java class: " + className);
    }

    public void addImportPackage(String packageName) {
        this.importedPackages.add(packageName);
    }

    public String getJavaName(String rubyName) {
        return (String)this.renamedJavaClasses.get(rubyName);
    }

    public void rename(String rubyName, String javaName) {
        this.renamedJavaClasses.put(rubyName, javaName);
    }

    public Class getJavaClass(RubyClass type) {
        Iterator iter = this.loadedJavaClasses.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getValue() != type) continue;
            return (Class)entry.getKey();
        }
        return null;
    }

    public void defineExceptionHandler(String exceptionClass, RubyProc handler) {
        this.exceptionHandlers.put(exceptionClass, handler);
    }

    public void handleNativeException(Exception excptn) {
        Class<?> excptnClass = excptn.getClass();
        RubyProc handler = (RubyProc)this.exceptionHandlers.get(excptnClass.getName());
        while (handler == null && excptnClass != (class$java$lang$Exception == null ? JavaSupport.class$("java.lang.Exception") : class$java$lang$Exception)) {
            excptnClass = excptnClass.getSuperclass();
        }
        if (handler == null) {
            StringWriter stackTrace = new StringWriter();
            excptn.printStackTrace(new PrintWriter(stackTrace));
            StringBuffer sb = new StringBuffer();
            sb.append("Native Exception: '");
            sb.append(excptn.getClass()).append("'; Message: ");
            sb.append(excptn.getMessage());
            sb.append("; StackTrace: ");
            sb.append(stackTrace.getBuffer().toString());
            throw new RaiseException(this.ruby, "RuntimeError", sb.toString());
        }
        handler.call(new IRubyObject[]{JavaUtil.convertJavaToRuby(this.ruby, excptn)});
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

