/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.javasupport.RubyConversion;
import org.jruby.javasupport.RubyInvocationHandler;
import org.jruby.javasupport.RubyProxy;
import org.jruby.javasupport.RubyToJavaClassMap;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyProxyFactory {
    private Ruby ruby = null;
    private RubyToJavaClassMap classMap = null;
    private RubyConversion conversion = null;
    static /* synthetic */ Class class$org$jruby$javasupport$RubyProxy;

    public RubyProxyFactory(Ruby ruby, RubyToJavaClassMap classMap) {
        this.ruby = ruby;
        this.classMap = classMap;
        this.conversion = new RubyConversion(this);
    }

    public Ruby getRuby() {
        return this.ruby;
    }

    public RubyProxy newProxyObject(Class javaInterface) {
        return this.newProxyObject(javaInterface, new Object[0]);
    }

    public RubyProxy newProxyObject(Class javaInterface, Object[] args) {
        IRubyObject[] rubyArgs;
        RubyClass rubyClass = this.getRubyClassForJavaClass(javaInterface);
        IRubyObject obj = rubyClass.newInstance(rubyArgs = this.convertJavaToRuby(args));
        if (obj != null) {
            return this.getProxyForObject(obj, javaInterface);
        }
        return null;
    }

    public RubyProxy getProxyForGlobal(String globalVar) {
        return this.getProxyForGlobal(globalVar, null);
    }

    public RubyProxy getProxyForGlobal(String globalVar, Class javaInterface) {
        IRubyObject obj = this.getRuby().getGlobalVar(globalVar);
        if (obj != null && !obj.isNil()) {
            return this.getProxyForObject(obj, javaInterface);
        }
        return null;
    }

    public RubyProxy getProxyForObject(IRubyObject obj) {
        return this.getProxyForObject(obj, null);
    }

    public RubyProxy getProxyForObject(IRubyObject obj, Class javaInterface) {
        if (javaInterface == null) {
            javaInterface = this.getJavaClassForRubyClass(obj.getInternalClass());
        }
        return (RubyProxy)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{javaInterface, class$org$jruby$javasupport$RubyProxy == null ? (class$org$jruby$javasupport$RubyProxy = RubyProxyFactory.class$("org.jruby.javasupport.RubyProxy")) : class$org$jruby$javasupport$RubyProxy}, (InvocationHandler)new RubyInvocationHandler(this, obj));
    }

    protected RubyClass getRubyClassForJavaClass(Class javaClass) {
        String className = this.classMap.getRubyClassNameForJavaClass(javaClass);
        return this.getRuby().getRubyClass(className);
    }

    protected Class getJavaClassForRubyClass(RubyClass rubyClass) {
        return this.classMap.getJavaClassForRubyClass(rubyClass);
    }

    public IRubyObject[] convertJavaToRuby(Object[] obj) {
        return this.conversion.convertJavaToRuby(obj);
    }

    public Object convertRubyToJava(IRubyObject obj, Class type) {
        return this.conversion.convertRubyToJava(obj, type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

