/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.ablaf.common.ISourcePosition;
import org.jruby.RubyModule;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.builtin.IRubyObject;

public class Frame {
    private IRubyObject self = null;
    private IRubyObject[] args = null;
    private String lastFunc = null;
    private RubyModule lastClass = null;
    private Namespace namespace = null;
    private Frame tmp = null;
    private ISourcePosition position;
    private Iter iter = Iter.ITER_NOT;

    public Frame(IRubyObject self, IRubyObject[] args, String lastFunc, RubyModule lastClass, Namespace namespace, Frame tmp, ISourcePosition position, Iter iter) {
        this.self = self;
        this.args = args;
        this.lastFunc = lastFunc;
        this.lastClass = lastClass;
        this.namespace = namespace;
        this.tmp = tmp;
        this.position = position;
        this.iter = iter;
    }

    public Frame(Frame frame) {
        this(frame.self, frame.args, frame.lastFunc, frame.lastClass, frame.namespace, frame.tmp, frame.position, frame.iter);
    }

    public IRubyObject[] getArgs() {
        return this.args;
    }

    public void setArgs(IRubyObject[] args) {
        this.args = args;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public ISourcePosition getPosition() {
        return this.position;
    }

    public String getFile() {
        return this.position.getFile();
    }

    public Iter getIter() {
        return this.iter;
    }

    public void setIter(Iter iter) {
        this.iter = iter;
    }

    public boolean isBlockGiven() {
        return this.iter.isBlockGiven();
    }

    public RubyModule getLastClass() {
        return this.lastClass;
    }

    public void setLastClass(RubyModule lastClass) {
        this.lastClass = lastClass;
    }

    public String getLastFunc() {
        return this.lastFunc;
    }

    public void setLastFunc(String lastFunc) {
        this.lastFunc = lastFunc;
    }

    public int getLine() {
        return this.position.getLine();
    }

    public IRubyObject getSelf() {
        return this.self;
    }

    public void setSelf(IRubyObject self) {
        this.self = self;
    }

    public Frame getTmp() {
        return this.tmp;
    }

    public void setTmp(Frame tmp) {
        this.tmp = tmp;
    }

    public void tmpPush() {
        Frame tmpFrame;
        this.tmp = tmpFrame = new Frame(this.self, this.args, this.lastFunc, this.lastClass, this.namespace, this.tmp, this.position, this.iter);
    }

    public void tmpPop() {
        this.self = this.tmp.self;
        this.args = this.tmp.args;
        this.lastFunc = this.tmp.lastFunc;
        this.lastClass = this.tmp.lastClass;
        this.namespace = this.tmp.namespace;
        this.position = this.tmp.position;
        this.iter = this.tmp.iter;
        this.tmp = this.tmp.tmp;
    }
}

