/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.exceptions.ArgumentError;
import org.jruby.runtime.Callback;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.builtin.IRubyObject;

public class IndexedCallback
implements Callback {
    private final int index;
    private final int arity;

    private IndexedCallback(int index, int arity) {
        this.index = index;
        this.arity = arity;
    }

    public static IndexedCallback create(int index, int arity) {
        return new IndexedCallback(index, arity);
    }

    public static IndexedCallback createOptional(int index) {
        return new IndexedCallback(index, -1);
    }

    public static IndexedCallback createOptional(int index, int required) {
        return new IndexedCallback(index, -(1 + required));
    }

    public IRubyObject execute(IRubyObject recv, IRubyObject[] args) {
        this.checkArity(recv.getRuntime(), args);
        return ((IndexCallable)((Object)recv)).callIndexed(this.index, args);
    }

    public int getArity() {
        return this.arity;
    }

    private void checkArity(Ruby ruby, IRubyObject[] args) {
        if (this.arity >= 0) {
            if (this.arity != args.length) {
                throw new ArgumentError(ruby, "wrong # of arguments(" + args.length + " for " + this.arity + ")");
            }
        } else {
            int required = -(1 + this.arity);
            if (args.length < required) {
                throw new ArgumentError(ruby, "wrong # of arguments(at least " + required + ")");
            }
        }
    }
}

