/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.NameError;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRuntime {
    private static final int TRACE_HEAD = 8;
    private static final int TRACE_TAIL = 5;
    private static final int TRACE_MAX = 18;
    private Ruby ruby;
    private RubyProc traceFunction;
    private boolean tracing = false;

    public RubyRuntime(Ruby ruby) {
        this.ruby = ruby;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject callSuper(IRubyObject[] args) {
        IRubyObject iRubyObject;
        if (this.ruby.getCurrentFrame().getLastClass() == null) {
            throw new NameError(this.ruby, "superclass method '" + this.ruby.getCurrentFrame().getLastFunc() + "' must be enabled by enableSuper().");
        }
        this.ruby.getIterStack().push(this.ruby.getCurrentIter().isNot() ? Iter.ITER_NOT : Iter.ITER_PRE);
        try {
            iRubyObject = this.ruby.getCurrentFrame().getLastClass().getSuperClass().call(this.ruby.getCurrentFrame().getSelf(), this.ruby.getCurrentFrame().getLastFunc(), args, CallType.SUPER);
            Object var4_3 = null;
            this.ruby.getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.ruby.getIterStack().pop();
            throw throwable;
        }
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScript(RubyString scriptName, RubyString source, boolean wrap) {
        IRubyObject self = this.ruby.getTopSelf();
        Namespace savedNamespace = this.ruby.getNamespace();
        this.ruby.pushDynamicVars();
        RubyModule wrapper = this.ruby.getWrapper();
        this.ruby.setNamespace(this.ruby.getTopNamespace());
        if (!wrap) {
            this.ruby.secure(4);
            this.ruby.pushClass(this.ruby.getClasses().getObjectClass());
            this.ruby.setWrapper(null);
        } else {
            this.ruby.setWrapper(RubyModule.newModule(this.ruby));
            this.ruby.pushClass(this.ruby.getWrapper());
            self = this.ruby.getTopSelf().rbClone();
            self.extendObject(this.ruby.getRubyClass());
            this.ruby.setNamespace(new Namespace(this.ruby.getWrapper(), this.ruby.getNamespace()));
        }
        String last_func = this.ruby.getCurrentFrame().getLastFunc();
        this.ruby.getFrameStack().push();
        this.ruby.getCurrentFrame().setLastFunc(null);
        this.ruby.getCurrentFrame().setLastClass(null);
        this.ruby.getCurrentFrame().setSelf(self);
        this.ruby.getCurrentFrame().setNamespace(new Namespace(this.ruby.getRubyClass(), null));
        this.ruby.getScope().push();
        this.ruby.setCurrentVisibility(Visibility.PRIVATE);
        try {
            INode node = this.ruby.parse(source.toString(), scriptName.getValue());
            self.eval(node);
            Object var10_9 = null;
            this.ruby.getCurrentFrame().setLastFunc(last_func);
            this.ruby.setNamespace(savedNamespace);
            this.ruby.getScope().pop();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.ruby.getCurrentFrame().setLastFunc(last_func);
            this.ruby.setNamespace(savedNamespace);
            this.ruby.getScope().pop();
            this.ruby.getFrameStack().pop();
            this.ruby.popClass();
            this.ruby.popDynamicVars();
            this.ruby.setWrapper(wrapper);
            throw throwable;
        }
        this.ruby.getFrameStack().pop();
        this.ruby.popClass();
        this.ruby.popDynamicVars();
        this.ruby.setWrapper(wrapper);
    }

    /*
     * WARNING - void declaration
     */
    public void loadFile(File iFile, boolean wrap) {
        if (iFile == null) {
            throw new RuntimeException("No such file to load");
        }
        try {
            String line;
            StringBuffer source = new StringBuffer((int)iFile.length());
            BufferedReader br = new BufferedReader(new FileReader(iFile));
            while ((line = br.readLine()) != null) {
                void var5_6;
                source.append((String)var5_6).append('\n');
            }
            br.close();
            this.loadScript(new RubyString(this.ruby, iFile.getPath()), new RubyString(this.ruby, source.toString()), wrap);
        }
        catch (IOException ioExcptn) {
            throw IOError.fromException(this.ruby, ioExcptn);
        }
    }

    public void loadFile(RubyString fname, boolean wrap) {
        this.loadFile(new File(fname.getValue()), wrap);
    }

    public synchronized void callTraceFunction(String event, ISourcePosition position, IRubyObject self, String name, IRubyObject type) {
        this.callTraceFunction(event, position.getFile(), position.getLine(), self, name, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void callTraceFunction(String event, String file, int line, IRubyObject self, String name, IRubyObject type) {
        if (!this.tracing && this.traceFunction != null) {
            this.tracing = true;
            if (file == null) {
                file = "(ruby)";
            }
            if (type == null) {
                type = this.ruby.getFalse();
            }
            this.ruby.getFrameStack().push();
            try {
                this.traceFunction.call(new IRubyObject[]{RubyString.newString(this.ruby, event), RubyString.newString(this.ruby, file), RubyFixnum.newFixnum(this.ruby, line), RubySymbol.newSymbol(this.ruby, name), self, type});
                Object var8_7 = null;
                this.ruby.getFrameStack().pop();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.ruby.getFrameStack().pop();
                this.tracing = false;
                throw throwable;
            }
            this.tracing = false;
            {
            }
        }
    }

    public void printError(RubyException excp) {
        if (excp == null || excp.isNil()) {
            return;
        }
        RubyArray backtrace = (RubyArray)excp.callMethod("backtrace");
        if (backtrace.isNil()) {
            if (this.ruby.getSourceFile() != null) {
                this.getErrorStream().print(this.ruby.getSourceFile() + ':' + this.ruby.getSourceLine());
            } else {
                this.getErrorStream().print(this.ruby.getSourceLine());
            }
        } else if (backtrace.getLength() == 0) {
            this.printErrorPos();
        } else {
            IRubyObject mesg = backtrace.entry(0L);
            if (mesg.isNil()) {
                this.printErrorPos();
            } else {
                this.getErrorStream().print(mesg);
            }
        }
        RubyClass type = excp.getInternalClass();
        String info = excp.toString();
        if (type == this.ruby.getExceptions().getRuntimeError() && (info == null || info.length() == 0)) {
            this.getErrorStream().print(": unhandled exception\n");
        } else {
            String path = type.getClassPath().toString();
            if (info.length() == 0) {
                this.getErrorStream().print(": " + path + '\n');
            } else {
                if (path.startsWith("#")) {
                    path = null;
                }
                String tail = null;
                if (info.indexOf("\n") != -1) {
                    tail = info.substring(info.indexOf("\n") + 1);
                    info = info.substring(0, info.indexOf("\n"));
                }
                this.getErrorStream().print(": " + info);
                if (path != null) {
                    this.getErrorStream().print(" (" + path + ")\n");
                }
                if (tail != null) {
                    this.getErrorStream().print(tail + '\n');
                }
            }
        }
        if (!backtrace.isNil()) {
            IRubyObject[] elements = backtrace.toJavaArray();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof RubyString) {
                    this.getErrorStream().print("\tfrom " + elements[i] + '\n');
                }
                if (i == 8 && elements.length > 18) {
                    this.getErrorStream().print("\t ... " + (elements.length - 8 - 5) + "levels...\n");
                    i = elements.length - 5;
                }
                ++i;
            }
        }
    }

    private void printErrorPos() {
        if (this.ruby.getSourceFile() != null) {
            if (this.ruby.getCurrentFrame().getLastFunc() != null) {
                this.getErrorStream().print(this.ruby.getSourceFile() + ':' + this.ruby.getSourceLine());
                this.getErrorStream().print(":in '" + this.ruby.getCurrentFrame().getLastFunc() + '\'');
            } else if (this.ruby.getSourceLine() != 0) {
                this.getErrorStream().print(this.ruby.getSourceFile() + ':' + this.ruby.getSourceLine());
            } else {
                this.getErrorStream().print(this.ruby.getSourceFile());
            }
        }
    }

    public PrintStream getErrorStream() {
        return new PrintStream(((RubyIO)this.ruby.getGlobalVar("$stderr")).getOutStream());
    }

    public void setErrorStream(PrintStream errorStream) {
        this.ruby.setGlobalVar("$stderr", RubyIO.stderr(this.ruby, this.ruby.getClasses().getIoClass(), errorStream));
    }

    public InputStream getInputStream() {
        return ((RubyIO)this.ruby.getGlobalVar("$stdin")).getInStream();
    }

    public void setInputStream(InputStream inputStream) {
        this.ruby.setGlobalVar("$stdin", RubyIO.stdin(this.ruby, this.ruby.getClasses().getIoClass(), inputStream));
    }

    public PrintStream getOutputStream() {
        return new PrintStream(((RubyIO)this.ruby.getGlobalVar("$stdout")).getOutStream());
    }

    public void setOutputStream(PrintStream outStream) {
        IRubyObject stdout = RubyIO.stdout(this.ruby, this.ruby.getClasses().getIoClass(), outStream);
        if (this.ruby.getGlobalVar("$stdout") == this.ruby.getGlobalVar("$>")) {
            this.ruby.setGlobalVar("$>", stdout);
        }
        this.ruby.setGlobalVar("$stdout", stdout);
    }

    public RubyProc getTraceFunction() {
        return this.traceFunction;
    }

    public void setTraceFunction(RubyProc traceFunction) {
        this.traceFunction = traceFunction;
    }

    static {
        TRACE_HEAD = 8;
        TRACE_TAIL = 5;
        TRACE_MAX = 18;
    }
}

