/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.collections.StackElement;

public class Scope
implements StackElement {
    private Ruby ruby;
    private IRubyObject superObject = null;
    private int flags = 0;
    private List localNames = null;
    private List localValues = null;
    private Visibility visibility = Visibility.PUBLIC;
    private Scope next = null;

    public Scope(Ruby ruby) {
        this.ruby = ruby;
    }

    public StackElement getNext() {
        return this.next;
    }

    public void setNext(StackElement newNext) {
        this.next = (Scope)newNext;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public IRubyObject getSuperObject() {
        return this.superObject;
    }

    public void setSuperObject(IRubyObject superObject) {
        this.superObject = superObject;
    }

    List getLocalNames() {
        return this.localNames;
    }

    public void setLocalNames(List localNames) {
        this.localNames = localNames;
        if (localNames != null) {
            this.localValues = new ArrayList<IRubyObject>(Collections.nCopies(localNames.size(), this.ruby.getNil()));
        }
    }

    List getLocalValues() {
        return this.localValues;
    }

    public IRubyObject getValue(int count) {
        return (IRubyObject)this.localValues.get(count);
    }

    public void setValue(int count, IRubyObject value) {
        this.localValues.set(count, value);
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }
}

