/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;

public class TestJavaUtil
extends TestCase {
    private Ruby ruby;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class array$Ljava$lang$String;

    public TestJavaUtil(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = Ruby.getDefaultInstance(null);
    }

    public void testConvertJavaToRuby() {
        Assert.assertEquals((Object)JavaUtil.convertJavaToRuby(this.ruby, null).getType().toName(), (Object)"NilClass");
        Assert.assertEquals((Object)JavaUtil.convertJavaToRuby(this.ruby, new Integer(1000)).getType().toName(), (Object)"Fixnum");
        Assert.assertEquals((Object)JavaUtil.convertJavaToRuby(this.ruby, new Double(1.0)).getType().toName(), (Object)"Float");
        Assert.assertEquals((Object)JavaUtil.convertJavaToRuby(this.ruby, Boolean.TRUE).getType().toName(), (Object)"TrueClass");
        Assert.assertEquals((Object)JavaUtil.convertJavaToRuby(this.ruby, Boolean.FALSE).getType().toName(), (Object)"FalseClass");
        Assert.assertEquals((Object)JavaUtil.convertJavaToRuby(this.ruby, "AString").getType().toName(), (Object)"String");
    }

    public void testCompatible() {
        Assert.assertTrue((boolean)JavaUtil.isCompatible(RubyString.newString(this.ruby, "hello"), class$java$lang$String == null ? (class$java$lang$String = TestJavaUtil.class$("java.lang.String")) : class$java$lang$String));
        Assert.assertTrue((boolean)JavaUtil.isCompatible(RubyHash.newHash(this.ruby), class$java$util$Map == null ? (class$java$util$Map = TestJavaUtil.class$("java.util.Map")) : class$java$util$Map));
        Assert.assertTrue((boolean)JavaUtil.isCompatible(RubyArray.newArray(this.ruby), class$java$util$List == null ? (class$java$util$List = TestJavaUtil.class$("java.util.List")) : class$java$util$List));
        Assert.assertTrue((boolean)JavaUtil.isCompatible(RubyArray.newArray(this.ruby), array$Ljava$lang$String == null ? (array$Ljava$lang$String = TestJavaUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String));
        RubyArray array = RubyArray.newArray(this.ruby);
        array.append(RubyString.newString(this.ruby, "hello"));
        Assert.assertTrue((boolean)JavaUtil.isCompatible(array, array$Ljava$lang$String == null ? (array$Ljava$lang$String = TestJavaUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String));
        array.append(RubyHash.newHash(this.ruby));
        Assert.assertTrue((!JavaUtil.isCompatible(array, array$Ljava$lang$String == null ? (array$Ljava$lang$String = TestJavaUtil.class$("[Ljava.lang.String;")) : array$Ljava$lang$String) ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

