/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.util.ArrayList;
import junit.framework.Assert;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.test.TestRubyBase;

public class TestKernel
extends TestRubyBase {
    public TestKernel(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = Ruby.getDefaultInstance(null);
        this.ruby.getLoadService().init(this.ruby, new ArrayList());
    }

    public void testLoad() throws Exception {
        Assert.assertEquals((Object)"0", (Object)this.eval("load 'test/loadTest'"));
        Assert.assertEquals((String)"load did not load the same file several times", (Object)"1", (Object)this.eval("load 'test/loadTest'"));
    }

    public void testRequire() throws Exception {
        this.eval("$loadTest = nil");
        Assert.assertEquals((String)"failed to load the file test/loadTest", (Object)"0", (Object)this.eval("require 'test/loadTest'"));
        Assert.assertEquals((String)"incorrectly reloaded the file test/loadTest", (Object)"", (Object)this.eval("require 'test/loadTest'"));
        Assert.assertEquals((String)"incorrect value for $\" variable", (Object)"test/loadTest", (Object)this.eval("print $\""));
    }

    public void testPrintf() throws Exception {
        Assert.assertEquals((Object)"hello", (Object)this.eval("printf(\"%s\", \"hello\")"));
        Assert.assertEquals((Object)"", (Object)this.eval("printf(\"%s\", nil)"));
    }

    private void assertTrue(IRubyObject iObj) {
        Assert.assertTrue((boolean)iObj.isTrue());
    }

    public void tearDown() {
        super.tearDown();
    }
}

