/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.util.ArrayList;
import junit.framework.Assert;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.test.TestRubyBase;

public class TestRuby
extends TestRubyBase {
    private String oldHomeProperty;
    private String oldLibProperty;

    public TestRuby(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = Ruby.getDefaultInstance(null);
        this.oldHomeProperty = System.getProperty("jruby.home");
        this.oldLibProperty = System.getProperty("jruby.lib");
    }

    public void tearDown() {
        super.tearDown();
        if (this.oldHomeProperty != null) {
            System.setProperty("jruby.home", this.oldHomeProperty);
        }
        if (this.oldLibProperty != null) {
            System.setProperty("jruby.lib", this.oldLibProperty);
        }
    }

    public void testVarAndMet() throws Exception {
        this.ruby.getLoadService().init(this.ruby, new ArrayList());
        this.eval("load './test/testVariableAndMethod.rb'");
        Assert.assertEquals((Object)"Hello World", (Object)this.eval("puts($a)"));
        Assert.assertEquals((Object)"dlroW olleH", (Object)this.eval("puts $b"));
        Assert.assertEquals((Object)"Hello World", (Object)this.eval("puts $d.reverse, $c, $e.reverse"));
        Assert.assertEquals((Object)"135 20 3", (Object)this.eval("puts $f, \" \", $g, \" \",  $h"));
    }

    private void assertTrue(IRubyObject iObj) {
        Assert.assertTrue((boolean)iObj.isTrue());
    }
}

