/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyNil;
import org.jruby.runtime.builtin.IRubyObject;

public class TestRubyNil
extends TestCase {
    private Ruby ruby;
    private IRubyObject rubyNil;

    public TestRubyNil(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = Ruby.getDefaultInstance(null);
        this.rubyNil = this.ruby.getNil();
    }

    public void testIsNil() {
        Assert.assertTrue((boolean)this.rubyNil.isNil());
    }

    public void testIsFalseOrTrue() {
        Assert.assertTrue((!this.rubyNil.isTrue() ? 1 : 0) != 0);
    }

    public void testToI() {
        Assert.assertEquals((Object)RubyFixnum.zero(this.ruby), (Object)RubyNil.to_i(this.rubyNil));
    }

    public void testToS() {
        Assert.assertEquals((Object)"", (Object)RubyNil.to_s(this.rubyNil).getValue());
    }

    public void testToA() {
        Assert.assertEquals(new ArrayList(), (Object)RubyNil.to_a(this.rubyNil).getList());
    }

    public void testInspect() {
        Assert.assertEquals((Object)"nil", (Object)RubyNil.inspect(this.rubyNil).getValue());
    }

    public void testType() {
        Assert.assertEquals((Object)"NilClass", (Object)RubyNil.type(this.rubyNil).name().toString());
    }

    public void testOpAnd() {
        Assert.assertTrue((boolean)RubyNil.op_and(this.rubyNil, this.rubyNil).isFalse());
    }

    public void testOpOr() {
        Assert.assertTrue((boolean)RubyNil.op_or(this.rubyNil, this.ruby.getTrue()).isTrue());
        Assert.assertTrue((boolean)RubyNil.op_or(this.rubyNil, this.ruby.getFalse()).isFalse());
    }

    public void testOpXOr() {
        Assert.assertTrue((boolean)RubyNil.op_xor(this.rubyNil, this.ruby.getTrue()).isTrue());
        Assert.assertTrue((boolean)RubyNil.op_xor(this.rubyNil, this.ruby.getFalse()).isFalse());
    }
}

