#!./miniruby -s

#require "ftools"

version = RUBY_VERSION

RUBY_VERSION.scan(/(\d+)\.(\d+)\.(\d+)/) {
  $version_major = $1
  $version_minor = $2
  $version_teeny = $3
}
Java::import "java.lang"
Java::name "java.io.File", "JavaFile"
$bindir = JavaFile.new(System.getProperty("jruby.home")).getCanonicalPath();
$bindir.gsub!(/\\/, '/')
$ruby_install_name = System.getProperty("jruby.script");
$osname = System.getProperty("os.name");
config = open("#{System.getProperty('jruby.home')}/lib/ruby/#$version_major.#$version_minor/java/rbconfig.rb", "w")
$> = config

fast = {'prefix'=>TRUE, 'ruby_install_name'=>TRUE, 'INSTALL'=>TRUE, 'EXEEXT'=>TRUE}
print <<END
#
# This file was generated by the mkconfig.rb tool.
#

module Config

  RUBY_VERSION == "#{version}" or
    raise "ruby lib version (#{version}) doesn't match executable version (\#{RUBY_VERSION})"

END

print "  DESTDIR = '' if not defined? DESTDIR\n  CONFIG = {}\n"
v_fast = []
v_others = []
has_srcdir = false




v_fast << "  CONFIG[\"bindir\"] = \"#$bindir\"\n"
v_fast << "  CONFIG[\"RUBY_INSTALL_NAME\"] = \"#$ruby_install_name\"\n"


###

#if not has_srcdir
#  v_fast << "  CONFIG[\"srcdir\"] = \"" + File.expand_path(srcdir || '.') + "\"\n"
#end


print "  CONFIG[\"MAJOR\"] = \"#$version_major\"\n"
print "  CONFIG[\"MINOR\"] = \"#$version_minor\"\n"
print "  CONFIG[\"TEENY\"] = \"#$version_teeny\"\n"

v_fast.collect! do |x|
  if /"prefix"/ === x
    prefix = Regexp.quote('/lib/ruby/' + RUBY_VERSION.sub(/\.\d+$/, '') + '/' + RUBY_PLATFORM)
    puts "  TOPDIR = File.dirname(__FILE__).sub!(%r'#{prefix}\\Z', '')"
    x.sub(/= (.*)/, '= (TOPDIR || DESTDIR + \1)')
  else
    x
  end
end

if $install_name
  v_fast << "  CONFIG[\"ruby_install_name\"] = \"" + $install_name + "\"\n"
  v_fast << "  CONFIG[\"RUBY_INSTALL_NAME\"] = \"" + $install_name + "\"\n"
end
if $so_name
  v_fast << "  CONFIG[\"RUBY_SO_NAME\"] = \"" + $so_name + "\"\n"
end

#this works for "Windows 2000" I don't know what are the other possible values
if $osname =~ /Windows/
  v_fast << '  CONFIG["EXEEXT"] = ".exe"' << "\n"
end


print v_fast, v_others
print <<EOS
  CONFIG["ruby_version"] = "$(MAJOR).$(MINOR)"
  CONFIG["rubylibdir"] = "$(libdir)/ruby/$(ruby_version)"
  CONFIG["archdir"] = "$(rubylibdir)/$(arch)"
  CONFIG["sitelibdir"] = "$(sitedir)/$(ruby_version)"
  CONFIG["sitearchdir"] = "$(sitelibdir)/$(arch)"
  MAKEFILE_CONFIG = {}
  CONFIG.each{|k,v| MAKEFILE_CONFIG[k] = v.dup}
  def Config::expand(val)
    val.gsub!(/\\$\\(([^()]+)\\)/) do |var|
      key = $1
      if CONFIG.key? key
        Config::expand(CONFIG[key])
      else
	var
      end
    end
    val
  end
  CONFIG.each_value do |val|
    Config::expand(val)
  end
end
EOS
config.close

# vi:set sw=2:
