/*
 * RescueNode.java - description
 * Created on 01.03.2002, 23:52:26
 * 
 * Copyright (C) 2001, 2002 Jan Arne Petersen
 * Jan Arne Petersen <jpetersen@uni-bonn.de>
 *
 * JRuby - http://jruby.sourceforge.net
 * 
 * This file is part of JRuby
 * 
 * JRuby is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * JRuby is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with JRuby; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */
package org.jruby.ast;

import org.ablaf.ast.*;
import org.ablaf.common.*;

import org.jruby.ast.types.*;
import org.jruby.ast.visitor.*;
import org.ablaf.ast.visitor.INodeVisitor;

/**
 *
 * @author  jpetersen
 * @version $Revision: 1.3 $
 */
public class RescueNode extends AbstractNode {
    private INode bodyNode;
    private IListNode rescueNodes;
    private INode elseNode;
    
    public RescueNode(ISourcePosition position, INode bodyNode, IListNode rescueNodes, INode elseNode) {
        super(position);
        
        this.bodyNode = bodyNode;
        this.rescueNodes = rescueNodes;
        this.elseNode = elseNode;
    }

    /**
     * Accept for the visitor pattern.
     * @param iVisitor the visitor
     **/
    public void accept(INodeVisitor iVisitor) {
        ((NodeVisitor)iVisitor).visitRescueNode(this);
    }

    /**
     * Gets the bodyNode.
     * @return Returns a INode
     */
    public INode getBodyNode() {
        return bodyNode;
    }

    /**
     * Sets the bodyNode.
     * @param bodyNode The bodyNode to set
     */
    public void setBodyNode(INode bodyNode) {
        this.bodyNode = bodyNode;
    }

    /**
     * Gets the elseNode.
     * @return Returns a INode
     */
    public INode getElseNode() {
        return elseNode;
    }

    /**
     * Sets the elseNode.
     * @param elseNode The elseNode to set
     */
    public void setElseNode(INode elseNode) {
        this.elseNode = elseNode;
    }

    /**
     * Gets the rescueNodes.
     * @return Returns a IListNode
     */
    public IListNode getRescueNodes() {
        return rescueNodes;
    }

    /**
     * Sets the rescueNodes.
     * @param rescueNodes The rescueNodes to set
     */
    public void setRescueNodes(IListNode rescueNodes) {
        this.rescueNodes = rescueNodes;
    }

}
