/***************************************************************************
                                 msn.h
                             -------------------
    begin                : Sat Dec 23 2000
    copyright            : (C) 2000 by Olaf Lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by  the Free Software Foundation; either version 2 of the   *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef MSN_H
#define MSN_H
#include <qobject.h>
#include <qsocket.h>
#include <time.h>
#include <kstringhandler.h>
#include <qlist.h>

enum CState {md5,connected,idle,proto,calc,syn,cha,auth};
enum State {BSY,IDL,BRB,AWY,PHN,LUN,HDN,NLN,FLN};

class SwitchBoard;
class MSNUser;

class NewUserImpl;

//!The base class for MSN connections
/*!
 This class incorporates some of the basic functionality
 of MSN. It complies with a draft Microsoft once put on
 the internet.
 \author Olaf Lueg
*/
class MSN : public QObject{
Q_OBJECT

public:
  //!Constructor
  /*!
   This constructor simply initiates the object. It doesn't
   attempt to connect with the MSN service!
  */
        MSN();
  //!Destructor
  /*!
   This destructor does not disconnect with the MSN messenger
   service. It simply cleans up the mess.
  */
        ~MSN();

	int sockfd,timer_id,socket_timer;
  //!Reflects the current state
  /*!
  This variable contains the current state of the client.
  */
        CState cstate;
	State state;
	time_t md5_tr;
	QSocket *qsocket;
	bool connecting;
	KStringHandler kstr;
	QString msgHandle;
	bool isConnected;
	SwitchBoard *switchboard;
protected:
        QString hashRes;
        QString userHandle, userPassword;
        NewUserImpl *newUser;
        MSNUser *msnUser;
        QList <MSNUser>userList;
	void parseNewMail(QString str);
        void searchUserInList(QString handle, QString shortHandle);
        void addUserToBlockList(QString handle,QString shortHandle);
        void addUserToList(QString handle,QString shortHandle);
        void unBlockUser(QString handle);
public:
  //! Sets the chosen user
  /*!
   This method \b needs to be called before you try
   \c slotConnect()
   \param user The user \b without the @hotmail.com prefix
   \param password The user's password
   */
	void setUser(QString user,QString password);
  //!
  QStrList getBlockedUsers();

  /** This method returns the public name from an MSN user*/
  QString getPublicName(QString handle);
  void syncronize();
  /**  */
  void Authenticate();
  /**  */
  void getServerPolicy();
  /**  */
  void setProtocol();
  /**  */
  void calcMD5();
  /**  */
  void slotList();
  /**  */
  void Lister();
  /**  */
  void timerEvent(QTimerEvent*);
  /**  */
  void newConnect(QString str);
  /**  */
  void parseCommand(QString str);
  /**  */
  void connectToSwitchboard(QString str);
  void startSwitchboard(QString str);
public slots: // Public slots
protected: // Protected attributes
  /** version of properties chached from client */
  QString strSerial;
protected: // Protected methods
  /**  */
public slots:
  /**  */
  void slotConnect();
  void slotData();
  /**  */
  void slotRemoveUser(QString handle);
    /**  */
  void slotAddUser(QString handle,QString shortHandle);
  /** */
  void slotAllowUser(QString handle,QString shortHandle);
  void slotBlockUser(QString handle,QString shortHandle);
  void slotUnBlockUser(QString handle);

  /**  */
  void wantSwitchboard(QString handle);
  /**  */
  void slotSocketClose();
  /**  */
  void slotDisconnect();
  /**  */
  void changeState(int status);
  /**  */
  void slotSendTypeMessage(QString handle);
signals: // Signals
  /**  */
  void userStateChange(QString str,QString str1,QString str2);
//  void userFound(QString str,QString str1,QString str2);
  void userSetOffline(QString str);
  void userTypingMessage(QString str); // send if a user writing	
  /**  */
  void connectedToMsn(bool);
  /**  */
  //void searchUserInList(QString handle,QString shortHandle);
  /**  */
  //void addUserToList(QString handle,QString shortHandle);
  /** */
  void newUserFound(QString,QString);
  void newMail();
  void startChat(SwitchBoard *board);
};

#endif
