/***************************************************************************
                          switchboard.h  -  description
                             -------------------
    begin                : Tue May 1 2001
    copyright            : (C) 2001 by Olaf Lueg
    email                : olaf.lueg@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by  the Free Software Foundation; either version 2 of the   *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/
#ifndef SWITCHBOARD_H
#define SWITCHBOARD_H

#include <qobject.h>
#include <kstringhandler.h>
#include <qstrlist.h>

class QSocket;
class MSN;

class SwitchBoard : public QObject{
Q_OBJECT

public:
	SwitchBoard();
	~SwitchBoard();
	QStrList userList;
	QSocket *msgSocket;
	QString msgHandle;
	KStringHandler kstr;
        MSN *msn;

protected:
	QString userHandle;
// functions
public:
	void connectToSwitchBoard(QString str);
	void callUser();
	void setHandle(QString handle){userHandle = handle;}
        void updateUserChatList(QString handle, bool f);
// slots	
public slots:
	void slotDataReceived();
	void slotSendMsgData(QString message);
	void slotSocketClosed();
	void slotCloseConnection();
	void slotInviteUser(QString handle);
        void slotSendWriteMessage();
// signals	
signals:
        void messageReceived(QString ,QString );
	void startChat(SwitchBoard* switchoard);
        void userTypingMessage(QString);
        void messageDelivery(QString);
        void userInChat(QString);
};
#endif
