/*
 * libEtPan! -- a mail stuff library
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: maildriver.h,v 1.16 2002/06/24 23:55:43 hoa Exp $
 */

#ifndef MAILDRIVER_H

#define MAILDRIVER_H

#include "mail.h"
#include "maildriver_types.h"

#include "imapdriver.h"
#include "mboxdriver.h"
#include "mhdriver.h"
#include "nntpdriver.h"
#include "pop3driver.h"

#include "mboxdriver_cached.h"
#include "mhdriver_cached.h"
#include "imapdriver_cached.h"
#include "pop3driver_cached.h"
#include "nntpdriver_cached.h"

/* mailsession */

mailsession * mailsession_new(maildriver * driver);

void mailsession_free(mailsession * session);

int mailsession_parameters(mailsession * session,
			   int id, void * value);

int mailsession_connect_stream(mailsession * session, mailstream * s);

int mailsession_connect_path(mailsession * session, char * path);

int mailsession_starttls(mailsession * session);

int mailsession_login(mailsession * session,
		      char * userid, char * password);

int mailsession_logout(mailsession * session);

int mailsession_noop(mailsession * session);

int mailsession_build_folder_name(mailsession * session, char * mb,
				  char * name, char ** result);

int mailsession_create_folder(mailsession * session, char * mb);

int mailsession_delete_folder(mailsession * session, char * mb);

int mailsession_rename_folder(mailsession * session,
			      char * mb, char * new_name);

int mailsession_check_folder(mailsession * session);

int mailsession_examine_folder(mailsession * session, char * mb);

int mailsession_select_folder(mailsession * session, char * mb);

int mailsession_expunge_folder(mailsession * session);

int mailsession_messages_number(mailsession * session, char * mb,
				uint32_t * result);

int mailsession_recent_number(mailsession * session,
			      char * mb, uint32_t * result);

int mailsession_unseen_number(mailsession * session, char * mb,
			      uint32_t * result);

int mailsession_list_folders(mailsession * session, char * mb,
			     struct mail_list ** result);

int mailsession_lsub_folders(mailsession * session, char * mb,
			     struct mail_list ** result);

int mailsession_subscribe_folder(mailsession * session, char * mb);

int mailsession_unsubscribe_folder(mailsession * session, char * mb);

int mailsession_append_message(mailsession * session,
			       char * message, size_t size);

int mailsession_copy_message(mailsession * session,
			     uint32_t num, char * mb);

int mailsession_move_message(mailsession * session,
			     uint32_t num, char * mb);

int mailsession_fetch_message(mailsession * session, uint32_t num,
			      char ** result, size_t * result_len);

int mailsession_fetch_message_header(mailsession * session, uint32_t num,
				     char ** result, size_t * result_len);

int mailsession_fetch_message_body(mailsession * session, uint32_t num,
				   char ** result, size_t * result_len);

int mailsession_fetch_message_size(mailsession * session, uint32_t num,
				   size_t * result);

int mailsession_fetch_message_bodystructure(mailsession * session,
					    uint32_t num,
					    struct mailmime ** result);

int mailsession_fetch_message_section(mailsession * session, uint32_t num,
				      struct mailmime * mime,
				      char ** result, size_t * result_len);

int
mailsession_fetch_message_section_header(mailsession * session,
					 uint32_t num,
					 struct mailmime * mime,
					 char ** result, size_t * result_len);
     
int
mailsession_fetch_message_section_mime_header(mailsession * session,
					      uint32_t num,
					      struct mailmime * mime,
					      char ** result,
					      size_t * result_len);

int
mailsession_fetch_message_section_body(mailsession * session,
				       uint32_t num,
				       struct mailmime * mime,
				       char ** result, size_t * result_len);

void mailsession_fetch_bodystructure_free(mailsession * session,
					  struct mailmime * mime);

void mailsession_fetch_result_free(mailsession * session,
				   char * fetch_data);

int mailsession_get_messages_list(mailsession * session,
				  struct mail_envelopes_list ** result);

int mailsession_get_envelopes_list(mailsession * session,
				   struct mail_envelopes_list * result);

int mailsession_remove_message(mailsession * session, uint32_t num);

int mailsession_search_messages(mailsession * session, char * charset,
				struct mail_search_key * key,
				struct mail_search_result ** result);

int mailsession_get_message_flags(mailsession * session, uint32_t num,
				  uint32_t * result);

int mailsession_set_message_flags(mailsession * session, uint32_t num,
				  uint32_t flags);

/*
int mailsession_send_message(mailsession * session,
			     struct mail_destination * dest,
			     char * message, size_t size);
*/

#endif
