/*
 * libEtPan! -- a mail stuff library
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef MAILDRIVER_TYPES_H

#define MAILDRIVER_TYPES_H

/* #include <glib.h> */
#include "mail.h"
#include "mailstream.h"
#include "mailimf.h"
#include "mailmime.h"
#include "carray.h"

struct mail_envelopes_tree {
  struct mail_envelopes_tree * parent;
  char * msgid;
  time_t date;
  struct mail_info * info;
  clist * children;

  /* private */
  int is_reply;
  char * base_subject;
  uint32_t index;
};


struct mail_envelopes_list {
  carray * tab; /* elements are (struct mail_info *) */
};

struct mail_envelopes_list * mail_envelopes_list_new(carray * tab
						     /*clist * list */);
void mail_envelopes_list_free(struct mail_envelopes_list * env_list);

struct mail_list {
  clist * list; /* elements are (char *) */
};

struct mail_list * mail_list_new(clist * list);
void mail_list_free(struct mail_list * resp);

struct mail_info {
  int cached;
  uint32_t index;
  struct mailimf_fields * fields;
  size_t size;
};

struct mail_info *
mail_info_new(uint32_t index, struct mailimf_fields * fields, uint32_t size);
void mail_info_free(struct mail_info * info);

uint32_t mailimf_date_time_comp(struct mailimf_date_time * date1,
				struct mailimf_date_time * date2);

enum {
  MAIL_SEARCH_KEY_ALL,
  MAIL_SEARCH_KEY_ANSWERED,
  MAIL_SEARCH_KEY_BCC,
  MAIL_SEARCH_KEY_BEFORE,
  MAIL_SEARCH_KEY_BODY,
  MAIL_SEARCH_KEY_CC,
  MAIL_SEARCH_KEY_DELETED,
  MAIL_SEARCH_KEY_FLAGGED,
  MAIL_SEARCH_KEY_FROM,
  MAIL_SEARCH_KEY_NEW,
  MAIL_SEARCH_KEY_OLD,
  MAIL_SEARCH_KEY_ON,
  MAIL_SEARCH_KEY_RECENT,
  MAIL_SEARCH_KEY_SEEN,
  MAIL_SEARCH_KEY_SINCE,
  MAIL_SEARCH_KEY_SUBJECT,
  MAIL_SEARCH_KEY_TEXT,
  MAIL_SEARCH_KEY_TO,
  MAIL_SEARCH_KEY_UNANSWERED,
  MAIL_SEARCH_KEY_UNDELETED,
  MAIL_SEARCH_KEY_UNFLAGGED,
  MAIL_SEARCH_KEY_UNSEEN,
  MAIL_SEARCH_KEY_HEADER,
  MAIL_SEARCH_KEY_LARGER,
  MAIL_SEARCH_KEY_NOT,
  MAIL_SEARCH_KEY_OR,
  MAIL_SEARCH_KEY_SMALLER,
  MAIL_SEARCH_KEY_MULTIPLE
};

struct mail_search_key {
  int type;
  char * bcc;
  struct mailimf_date_time * before;
  char * body;
  char * cc;
  char * from;
  struct mailimf_date_time * on;
  struct mailimf_date_time * since;
  char * subject;
  char * text;
  char * to;
  char * header_name;
  char * header_value;
  size_t larger;
  struct mail_search_key * not;
  struct mail_search_key * or1;
  struct mail_search_key * or2;
  size_t smaller;
  clist * multiple; /* list of (struct mailimap_search_key *) */
};


struct mail_search_key *
mail_search_key_new(int type,
		    char * bcc,
		    struct mailimf_date_time * before,
		    char * body,
		    char * cc,
		    char * from,
		    struct mailimf_date_time * on,
		    struct mailimf_date_time * since,
		    char * subject,
		    char * text,
		    char * to,
		    char * header_name,
		    char * header_value,
		    size_t larger,
		    struct mail_search_key * not,
		    struct mail_search_key * or1,
		    struct mail_search_key * or2,
		    size_t smaller,
		    clist * multiple);

void mail_search_key_free(struct mail_search_key * key);

struct mail_search_result {
  clist * list;
};

struct mail_search_result * mail_search_result_new(clist * list);

void mail_search_result_free(struct mail_search_result * search_result);

/*
struct mail_destination;
*/


















struct maildriver;
typedef struct maildriver maildriver;

struct mailsession;
typedef struct mailsession mailsession;


struct maildriver {
  char * name;

  /*
    size_t progr_rate, progress_function * progr_fun
    will be parameter for the driver
  */

  void * (* initialize)(void);
  void (* uninitialize)(void * data);

  int (* parameters)(mailsession * session,
		     int id, void * value);

  int (* connect_stream)(mailsession * session, mailstream * s);
  int (* connect_path)(mailsession * session, char * path);

  int (* starttls)(mailsession * session);

  int (* login)(mailsession * session, char * userid, char * password);
  int (* logout)(mailsession * session);
  int (* noop)(mailsession * session);

  /* folders operations */

  int (* build_folder_name)(mailsession * session, char * mb,
			    char * name, char ** result);

  int (* create_folder)(mailsession * session, char * mb);
  int (* delete_folder)(mailsession * session, char * mb);
  int (* rename_folder)(mailsession * session, char * mb, char * new_name);
  int (* check_folder)(mailsession * session);
  int (* examine_folder)(mailsession * session, char * mb);
  int (* select_folder)(mailsession * session, char * mb);
  int (* expunge_folder)(mailsession * session);
  int (* messages_number)(mailsession * session, char * mb,
			  uint32_t * result);
  int (* recent_number)(mailsession * session, char * mb, uint32_t * result);
  int (* unseen_number)(mailsession * session, char * mb, uint32_t * result);

  int (* list_folders)(mailsession * session, char * mb,
		       struct mail_list ** result);
  int (* lsub_folders)(mailsession * session, char * mb,
		       struct mail_list ** result);

  int (* subscribe_folder)(mailsession * session, char * mb);
  int (* unsubscribe_folder)(mailsession * session, char * mb);

  /* messages operations */

  int (* append_message)(mailsession * session,
			 char * message, size_t size);
  int (* copy_message)(mailsession * session,
		       uint32_t num, char * mb);
  int (* move_message)(mailsession * session,
		       uint32_t num, char * mb);
  int (* fetch_message)(mailsession * session, uint32_t num,
			char ** result, size_t * result_len);
  int (* fetch_message_header)(mailsession * session, uint32_t num,
			       char ** result, size_t * result_len);
  int (* fetch_message_body)(mailsession * session, uint32_t num,
			     char ** result, size_t * result_len);
  int (* fetch_message_size)(mailsession * session, uint32_t num,
			     size_t * result);
  int (* fetch_message_bodystructure)(mailsession * session, uint32_t num,
				      struct mailmime ** result);

  int (* fetch_message_section)(mailsession * session,
				uint32_t num,
				struct mailmime * mime,
				char ** result, size_t * result_len);
  int (* fetch_message_section_header)(mailsession * session,
				       uint32_t num,
				       struct mailmime * mime,
				       char ** result, size_t * result_len);
  int (* fetch_message_section_mime_header)(mailsession * session,
					    uint32_t num,
					    struct mailmime * mime,
					    char ** result,
					    size_t * result_len);
  int (* fetch_message_section_body)(mailsession * session,
				     uint32_t num,
				     struct mailmime * mime,
				     char ** result, size_t * result_len);

  void (* fetch_bodystructure_free)(mailsession * session,
				    struct mailmime * mime);

  void (* fetch_result_free)(mailsession * session,
			     char * fetch_data);

  int (* get_messages_list)(mailsession * session,
			    struct mail_envelopes_list ** result);
  int (* get_envelopes_list)(mailsession * session,
			     struct mail_envelopes_list * env_list);
  int (* remove_message)(mailsession * session, uint32_t num);
  int (* search_messages)(mailsession * session, char * charset,
			  struct mail_search_key * key,
			  struct mail_search_result ** result);
  int (* set_message_flags)(mailsession * session, uint32_t num,
			    uint32_t flags);
  int (* get_message_flags)(mailsession * session, uint32_t num,
			    uint32_t * flags);

  /*
  gint (* send_message)(mailsession * f, struct mail_destination * dest,
			gchar * message, guint32 size);
  */
};

enum {
  MAIL_MESSAGE_PART_HEADER,
  MAIL_MESSAGE_PART_BODY,
  MAIL_MESSAGE_PART_MESSAGE
};

enum {
  MAIL_FLAG_NEW       = 1 << 0,
  MAIL_FLAG_READ      = 1 << 1,
  MAIL_FLAG_MARKED    = 1 << 2,
  MAIL_FLAG_DELETED   = 1 << 3,
  MAIL_FLAG_ANSWERED  = 1 << 4,
  MAIL_FLAG_FORWARDED = 1 << 5,
};

enum {
  MAIL_NO_ERROR = 0,
  MAIL_NO_ERROR_AUTHENTICATED,
  MAIL_NO_ERROR_NON_AUTHENTICATED,
  MAIL_ERROR_NOT_IMPLEMENTED,
  MAIL_ERROR_CONNECT,
  MAIL_ERROR_BAD_STATE,
  MAIL_ERROR_FILE,
  MAIL_ERROR_STREAM,
  MAIL_ERROR_LOGIN,
  MAIL_ERROR_CREATE,
  MAIL_ERROR_DELETE, /* 10 */
  MAIL_ERROR_LOGOUT,
  MAIL_ERROR_NOOP,
  MAIL_ERROR_RENAME,
  MAIL_ERROR_CHECK,
  MAIL_ERROR_EXAMINE,
  MAIL_ERROR_SELECT,
  MAIL_ERROR_MEMORY,
  MAIL_ERROR_STATUS,
  MAIL_ERROR_SUBSCRIBE,
  MAIL_ERROR_UNSUBSCRIBE, /* 20 */
  MAIL_ERROR_LIST,
  MAIL_ERROR_LSUB,
  MAIL_ERROR_APPEND,
  MAIL_ERROR_COPY,
  MAIL_ERROR_FETCH,
  MAIL_ERROR_STORE,
  MAIL_ERROR_SEARCH,
  MAIL_ERROR_DISKSPACE,
  MAIL_ERROR_MSG_NOT_FOUND,
  MAIL_ERROR_PARSE, /* 30 */
  MAIL_ERROR_INVAL,
  MAIL_ERROR_PART_NOT_FOUND,
  MAIL_ERROR_REMOVE,
  MAIL_ERROR_FOLDER_NOT_FOUND,
  MAIL_ERROR_MOVE,
  MAIL_ERROR_STARTTLS,
  MAIL_ERROR_CACHE_MISS,
  MAIL_ERROR_NO_TLS,
  MAIL_ERROR_EXPUNGE,
  /* misc errors */
  MAIL_ERROR_PROTOCOL,
  MAIL_ERROR_CAPABILITY,
  MAIL_ERROR_CLOSE,
  MAIL_ERROR_FATAL,
  MAIL_ERROR_READONLY,
  MAIL_ERROR_NO_APOP,
  MAIL_ERROR_COMMAND_NOT_SUPPORTED,
  MAIL_ERROR_NO_PERMISSION,
  MAIL_ERROR_PROGRAM_ERROR,
  MAIL_ERROR_SUBJECT_NOT_FOUND,
  MAIL_ERROR_CHAR_ENCODING_FAILED,
};

struct mailsession {
  int type;
  void * data;
  struct maildriver * driver;
};

struct mail_envelopes_tree * mail_envelopes_tree_new(char * msgid, time_t date,
						     struct mail_info * info);

void mail_envelopes_tree_free(struct mail_envelopes_tree * tree);

void mail_envelopes_tree_free_recursive(struct mail_envelopes_tree * tree);

char * maildriver_strerror(int err);

#endif
