/*
 * libEtPan! -- a mail stuff library
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: mailimap.h,v 1.10 2002/06/26 21:15:09 hoa Exp $
 */

#ifndef MAILIMAP_H

#define MAILIMAP_H

#include "mailimap_types.h"
#include "mailimap_types_helper.h"
#include "mailimap_helper.h"

#include "mailimap_socket.h"
#include "mailimap_ssl.h"

/*
  mailimap_connect

  This function will connect a given stream the IMAP session.

  @param session  the IMAP session
  @param s        stream to connect
*/

int mailimap_connect(mailimap * session, mailstream * s);

/*
  mailimap_append

  This function will append a given message to the given mailbox.

  @param session       the IMAP session
  @param mailbox       name of the mailbox
  @param flag_list     flags of the message
  @param date_time     timestamp of the message
  @param literal       content of the message
  @param literal_size  size of the message
*/

int mailimap_append(mailimap * session, char * mailbox,
		    struct mailimap_flag_list * flag_list,
		    struct mailimap_date_time * date_time,
		    char * literal, size_t literal_size);

int mailimap_noop(mailimap * session);

int mailimap_logout(mailimap * session);

int mailimap_capability(mailimap * session,
			struct mailimap_capability_data ** result);

int mailimap_check(mailimap * session);

int mailimap_close(mailimap * session);

int mailimap_expunge(mailimap * session);

int mailimap_copy(mailimap * session, struct mailimap_set * set, char * mb);

int mailimap_uid_copy(mailimap * session,
		      struct mailimap_set * set, char * mb);

int mailimap_create(mailimap * session, char * mb);

int mailimap_delete(mailimap * session, char * mb);

int mailimap_examine(mailimap * session, char * mb);

/*
  mailimap_fetch
  (* result) is a list of (struct mailimap_msg_att *)
*/

int
mailimap_fetch(mailimap * session, struct mailimap_set * set,
	       struct mailimap_fetch_type * fetch_type, clist ** result);

int
mailimap_uid_fetch(mailimap * session,
		   struct mailimap_set * set,
		   struct mailimap_fetch_type * fetch_type, clist ** result);

void mailimap_fetch_list_free(clist * fetch_list);

int mailimap_list(mailimap * session, char * mb,
		  char * list_mb, clist ** result);

int mailimap_login(mailimap * session, char * userid, char * password);

int mailimap_lsub(mailimap * session, char * mb,
		  char * list_mb, clist ** result);

void mailimap_list_result_free(clist * list);

int mailimap_rename(mailimap * session, char * mb, char * new_name);

int
mailimap_search(mailimap * session, char * charset,
		struct mailimap_search_key * key, clist ** result);

int
mailimap_uid_search(mailimap * session, char * charset,
		    struct mailimap_search_key * key, clist ** result);

void mailimap_search_result_free(clist * search_result);

int
mailimap_select(mailimap * session, char * mb);

int
mailimap_status(mailimap * session, char * mb,
		struct mailimap_status_att_list * status_att_list,
		struct mailimap_mailbox_data_status ** result);

int
mailimap_store(mailimap * session,
	       struct mailimap_set * set,
	       struct mailimap_store_att_flags * store_att_flags);

int
mailimap_uid_store(mailimap * session,
		   struct mailimap_set * set,
		   struct mailimap_store_att_flags * store_att_flags);

int mailimap_subscribe(mailimap * session, char * mb);

int mailimap_unsubscribe(mailimap * session, char * mb);

int mailimap_starttls(mailimap * session);

mailimap * mailimap_new(size_t progr_rate, progress_function * progr_fun);

void mailimap_free(mailimap * session);

#endif
