/*
 * libEtPan! -- a mail stuff library
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef MAILIMAP_TYPES_HELPER_H

#define MAILIMAP_TYPES_HELPER_H

#include "mailimap_types.h"

struct mailimap_set_item * mailimap_set_item_new_single(uint32_t index);

struct mailimap_set *
mailimap_set_new_single_item(struct mailimap_set_item * item);

struct mailimap_set * mailimap_set_new_interval(uint32_t first, uint32_t last);

struct mailimap_set * mailimap_set_new_single(uint32_t index);

struct mailimap_set * mailimap_set_new_empty();

int mailimap_set_add(struct mailimap_set * set,
		struct mailimap_set_item * set_item);

int mailimap_set_add_interval(struct mailimap_set * set,
		uint32_t first, uint32_t last);

int mailimap_set_add_single(struct mailimap_set * set,
			 uint32_t index);

#if 0
/* not correct */
struct mailimap_section * mailimap_section_new_empty();
#endif

struct mailimap_section * mailimap_section_new_header();

struct mailimap_section *
mailimap_section_new_header_fields(struct mailimap_header_list * header_list);

struct mailimap_section *
mailimap_section_new_header_fields_not(struct mailimap_header_list * header_list);

struct mailimap_section * mailimap_section_new_text();

struct mailimap_section *
mailimap_section_new_part(struct mailimap_section_part * part);

struct mailimap_section *
mailimap_section_new_part_mime(struct mailimap_section_part * part);

struct mailimap_section *
mailimap_section_new_part_header(struct mailimap_section_part * part);

struct mailimap_section *
mailimap_section_new_part_header_fields(struct mailimap_section_part *
					part,
					struct mailimap_header_list *
					header_list);

struct mailimap_section *
mailimap_section_new_part_header_fields_not(struct mailimap_section_part
					    * part,
					    struct mailimap_header_list
					    * header_list);

struct mailimap_section *
mailimap_section_new_part_text(struct mailimap_section_part * part);


struct mailimap_fetch_att *
mailimap_fetch_att_new_envelope();


struct mailimap_fetch_att *
mailimap_fetch_att_new_flags();

struct mailimap_fetch_att *
mailimap_fetch_att_new_internaldate();

struct mailimap_fetch_att *
mailimap_fetch_att_new_rfc822();

struct mailimap_fetch_att *
mailimap_fetch_att_new_rfc822_header();

struct mailimap_fetch_att *
mailimap_fetch_att_new_rfc822_size();

struct mailimap_fetch_att *
mailimap_fetch_att_new_rfc822_text();

struct mailimap_fetch_att *
mailimap_fetch_att_new_body();

struct mailimap_fetch_att *
mailimap_fetch_att_new_bodystructure();

struct mailimap_fetch_att *
mailimap_fetch_att_new_uid();

struct mailimap_fetch_att *
mailimap_fetch_att_new_body_section(struct mailimap_section * section);

struct mailimap_fetch_att *
mailimap_fetch_att_new_body_peek_section(struct mailimap_section * section);

struct mailimap_fetch_att *
mailimap_fetch_att_new_body_section_partial(struct mailimap_section * section,
					    uint32_t offset, uint32_t size);

struct mailimap_fetch_att *
mailimap_fetch_att_new_body_peek_section_partial(struct mailimap_section * section,
						 uint32_t offset, uint32_t size);

struct mailimap_fetch_type *
mailimap_fetch_type_new_all();

struct mailimap_fetch_type *
mailimap_fetch_type_new_full();

struct mailimap_fetch_type *
mailimap_fetch_type_new_fast();

struct mailimap_fetch_type *
mailimap_fetch_type_new_fetch_att(struct mailimap_fetch_att * fetch_att);

struct mailimap_fetch_type *
mailimap_fetch_type_new_fetch_att_list(clist * fetch_att_list);

struct mailimap_fetch_type *
mailimap_fetch_type_new_fetch_att_list_empty();

int
mailimap_fetch_type_new_fetch_att_list_add(struct mailimap_fetch_type *
					   fetch_type,
					   struct mailimap_fetch_att *
					   fetch_att);

struct mailimap_store_att_flags *
mailimap_store_att_flags_new_set_flags(struct mailimap_flag_list * flags);

struct mailimap_store_att_flags *
mailimap_store_att_flags_new_set_flags_silent(struct mailimap_flag_list *
					      flags);

struct mailimap_store_att_flags *
mailimap_store_att_flags_new_add_flags(struct mailimap_flag_list * flags);

struct mailimap_store_att_flags *
mailimap_store_att_flags_new_add_flags_silent(struct mailimap_flag_list *
					      flags);

struct mailimap_store_att_flags *
mailimap_store_att_flags_new_remove_flags(struct mailimap_flag_list * flags);

struct mailimap_store_att_flags *
mailimap_store_att_flags_new_remove_flags_silent(struct mailimap_flag_list *
						 flags);


struct mailimap_search_key *
mailimap_search_key_new_all();

struct mailimap_search_key *
mailimap_search_key_new_bcc(char * bcc);

struct mailimap_search_key *
mailimap_search_key_new_before(struct mailimap_date * before);

struct mailimap_search_key *
mailimap_search_key_new_body(char * body);

struct mailimap_search_key *
mailimap_search_key_new_cc(char * cc);

struct mailimap_search_key *
mailimap_search_key_new_from(char * from);

struct mailimap_search_key *
mailimap_search_key_new_keyword(char * keyword);

struct mailimap_search_key *
mailimap_search_key_new_on(struct mailimap_date * on);

struct mailimap_search_key *
mailimap_search_key_new_since(struct mailimap_date * since);

struct mailimap_search_key *
mailimap_search_key_new_subject(char * subject);

struct mailimap_search_key *
mailimap_search_key_new_text(char * text);

struct mailimap_search_key *
mailimap_search_key_new_to(char * to);

struct mailimap_search_key *
mailimap_search_key_new_unkeyword(char * unkeyword);

struct mailimap_search_key *
mailimap_search_key_new_header(char * header_name, char * header_value);

struct mailimap_search_key *
mailimap_search_key_new_larger(uint32_t larger);

struct mailimap_search_key *
mailimap_search_key_new_not(struct mailimap_search_key * not);

struct mailimap_search_key *
mailimap_search_key_new_or(struct mailimap_search_key * or1,
			   struct mailimap_search_key * or2);

struct mailimap_search_key *
mailimap_search_key_new_sentbefore(struct mailimap_date * sentbefore);

struct mailimap_search_key *
mailimap_search_key_new_senton(struct mailimap_date * senton);

struct mailimap_search_key *
mailimap_search_key_new_sentsince(struct mailimap_date * sentsince);

struct mailimap_search_key *
mailimap_search_key_new_smaller(uint32_t smaller);

struct mailimap_search_key *
mailimap_search_key_new_uid(struct mailimap_set * uid);

struct mailimap_search_key *
mailimap_search_key_new_set(struct mailimap_set * set);

struct mailimap_search_key *
mailimap_search_key_new_multiple(clist * keys);

struct mailimap_search_key *
mailimap_search_key_new_multiple_empty();

int
mailimap_search_key_multiple_add(struct mailimap_search_key * keys,
				 struct mailimap_search_key * key_item);

struct mailimap_flag_list *
mailimap_flag_list_new_empty();

int mailimap_flag_list_add(struct mailimap_flag_list * flag_list,
				struct mailimap_flag * f);

struct mailimap_flag * mailimap_flag_new_answered();

struct mailimap_flag * mailimap_flag_new_flagged();

struct mailimap_flag * mailimap_flag_new_deleted();

struct mailimap_flag * mailimap_flag_new_seen();

struct mailimap_flag * mailimap_flag_new_draft();

struct mailimap_flag * mailimap_flag_new_flag_keyword(char * flag_keyword);

struct mailimap_flag * mailimap_flag_new_flag_extension(char * flag_extension);

struct mailimap_status_att_list * mailimap_status_att_list_new_empty();

int
mailimap_status_att_list_add(struct mailimap_status_att_list * sa_list,
			     int status_att);


#endif
