/*
 * libEtPan! -- a mail stuff library
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: mailimf.h,v 1.17 2002/06/26 17:22:58 hoa Exp $
 */

#ifndef MAILIMF_H

#define MAILIMF_H

#include "mailimf_types.h"
#include "mailimf_write.h"
#include "mailimf_types_helper.h"

#include <inttypes.h>
#include <sys/types.h>

int mailimf_message_parse(char * message, size_t length,
			  size_t * index,
			  struct mailimf_message ** result);

int mailimf_body_parse(char * message, size_t length,
		       size_t * index,
		       struct mailimf_body ** result);

int mailimf_fields_parse(char * message, size_t length,
			 size_t * index,
			 struct mailimf_fields ** result);

#if 0
int
mailimf_unparsed_fields_parse(char * message, size_t length,
			      size_t * index,
			      struct mailimf_unparsed_fields ** result);
#endif

int
mailimf_mailbox_list_parse(char * message, size_t length,
			   size_t * index,
			   struct mailimf_mailbox_list ** result);

int
mailimf_address_list_parse(char * message, size_t length,
			   size_t * index,
			   struct mailimf_address_list ** result);

int mailimf_address_parse(char * message, size_t length,
			  size_t * index,
			  struct mailimf_address ** result);

int mailimf_mailbox_parse(char * message, size_t length,
			  size_t * index,
			  struct mailimf_mailbox ** result);

int mailimf_date_time_parse(char * message, size_t length,
			    size_t * index,
			    struct mailimf_date_time ** result);

int mailimf_envelope_fields_parse(char * message, size_t length,
				  size_t * index,
				  struct mailimf_fields ** result);

/* exported for MIME */

int mailimf_fws_parse(char * message, size_t length, size_t * index);

int mailimf_cfws_parse(char * message, size_t length,
		       size_t * index);

int mailimf_char_parse(char * message, size_t length,
		       size_t * index, char token);

int mailimf_unstrict_char_parse(char * message, size_t length,
				size_t * index, char token);

int mailimf_crlf_parse(char * message, size_t length, size_t * index);

int
mailimf_custom_string_parse(char * message, size_t length,
			    size_t * index, char ** result,
			    int (* is_custom_char)(char));

int
mailimf_token_case_insensitive_len_parse(char * message, size_t length,
					 size_t * index, char * token,
					 size_t token_length);

#define mailimf_token_case_insensitive_parse(message, length, index, token) \
    mailimf_token_case_insensitive_len_parse(message, length, index, token, \
					     sizeof(token) - 1)

int mailimf_quoted_string_parse(char * message, size_t length,
				size_t * index, char ** result);

int
mailimf_number_parse(char * message, size_t length,
		     size_t * index, uint32_t * result);

int mailimf_msg_id_parse(char * message, size_t length,
			 size_t * index,
			 char ** result);

int mailimf_msg_id_list_parse(char * message, size_t length,
			      size_t * index, clist ** result);

int mailimf_word_parse(char * message, size_t length,
		       size_t * index, char ** result);

int mailimf_atom_parse(char * message, size_t length,
		       size_t * index, char ** result);

int mailimf_fws_atom_parse(char * message, size_t length,
			   size_t * index, char ** result);

int mailimf_fws_word_parse(char * message, size_t length,
			   size_t * index, char ** result);

int mailimf_fws_quoted_string_parse(char * message, size_t length,
				    size_t * index, char ** result);

/* tools */

int mailimf_ignore_field_parse(char * message, size_t length,
			       size_t * index);

int
mailimf_envelope_and_optional_fields_parse(char * message, size_t length,
					   size_t * index,
					   struct mailimf_fields ** result);

int
mailimf_optional_fields_parse(char * message, size_t length,
			      size_t * index,
			      struct mailimf_fields ** result);

#endif
