/*
 * libEtPan! -- a mail stuff library
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


/*
 * $Id: mailimf_types.h,v 1.15 2002/06/26 19:48:12 hoa Exp $
 */

#ifndef MAILIMF_TYPES_H

#define MAILIMF_TYPES_H

/* #include <glib.h> */
#include "clist.h"

struct mailimf_date_time {
  int day;
  int month;
  int year;
  int hour;
  int min;
  int sec;
  int zone;
};

enum {
  MAILIMF_ADDRESS_ERROR,
  MAILIMF_ADDRESS_MAILBOX,
  MAILIMF_ADDRESS_GROUP
};

struct mailimf_address {
  int type;
  struct mailimf_mailbox * mailbox; /* can be NULL */
  struct mailimf_group * group;     /* can be NULL */
};

struct mailimf_mailbox {
  char * display_name; /* can be NULL */
  char * addr_spec;    /* != NULL */
};

struct mailimf_group {
  char * display_name; /* != NULL */
  struct mailimf_mailbox_list * mb_list; /* can be NULL */
};

struct mailimf_mailbox_list {
  clist * list; /* != NULL */
};

struct mailimf_address_list {
  clist * list; /* != NULL */
};

struct mailimf_body {
  char * text; /* != NULL */
  size_t size;
};

struct mailimf_message {
  struct mailimf_fields * fields; /* != NULL */
  struct mailimf_body * body;     /* != NULL */
};

struct mailimf_fields {
  clist * list; /* list of (struct mailimf_field *) */
                /* != NULL */
};

#if 0
struct mailimf_unparsed_fields {
  clist * list; /* list of (struct mailimf_optional_field *) */
                /* can be NULL */
};
#endif

enum {
  MAILIMF_RESENT_FIELD_NONE,
  MAILIMF_RESENT_FIELD_DATE,
  MAILIMF_RESENT_FIELD_FROM,
  MAILIMF_RESENT_FIELD_SENDER,
  MAILIMF_RESENT_FIELD_TO,
  MAILIMF_RESENT_FIELD_CC,
  MAILIMF_RESENT_FIELD_BCC,
  MAILIMF_RESENT_FIELD_MSG_ID
};

struct mailimf_resent_field {
  int type;
  struct mailimf_orig_date * resent_date;    /* can be NULL */
  struct mailimf_from * resent_from;         /* can be NULL */
  struct mailimf_sender * resent_sender;     /* can be NULL */
  struct mailimf_to * resent_to;             /* can be NULL */
  struct mailimf_cc * resent_cc;             /* can be NULL */
  struct mailimf_bcc * resent_bcc;           /* can be NULL */
  struct mailimf_message_id * resent_msg_id; /* can be NULL */
};

struct mailimf_resent_fields_list {
  clist * list; /* != NULL */
};

struct mailimf_trace_resent_fields {
  struct mailimf_return * return_path; /* can be NULL */
#if 0
  struct mailimf_trace * trace;
#endif
  struct mailimf_resent_fields_list * resent_fields; /* can be NULL */
  /* can't both be NULL */
};

struct mailimf_delivering_info {
  clist * received_fields; /* elt are (struct mailimf_trace_resent_fields *) */
};

enum {
  MAILIMF_FIELD_NONE,
  MAILIMF_FIELD_DELIVERING_INFO,
  MAILIMF_FIELD_ORIG_DATE,
  MAILIMF_FIELD_FROM,
  MAILIMF_FIELD_SENDER,
  MAILIMF_FIELD_REPLY_TO,
  MAILIMF_FIELD_TO,
  MAILIMF_FIELD_CC,
  MAILIMF_FIELD_BCC,
  MAILIMF_FIELD_MESSAGE_ID,
  MAILIMF_FIELD_IN_REPLY_TO,
  MAILIMF_FIELD_REFERENCES,
  MAILIMF_FIELD_SUBJECT,
  MAILIMF_FIELD_COMMENTS,
  MAILIMF_FIELD_KEYWORDS,
  MAILIMF_FIELD_OPTIONAL_FIELD
};

struct mailimf_field {
  int type;
  struct mailimf_delivering_info * delivering_info; /* can be NULL */
  struct mailimf_orig_date * orig_date;             /* can be NULL */
  struct mailimf_from * from;                       /* can be NULL */
  struct mailimf_sender * sender;                   /* can be NULL */
  struct mailimf_reply_to * reply_to;               /* can be NULL */
  struct mailimf_to * to;                           /* can be NULL */
  struct mailimf_cc * cc;                           /* can be NULL */
  struct mailimf_bcc * bcc;                         /* can be NULL */
  struct mailimf_message_id * message_id;           /* can be NULL */
  struct mailimf_in_reply_to * in_reply_to;         /* can be NULL */
  struct mailimf_references * references;           /* can be NULL */
  struct mailimf_subject * subject;                 /* can be NULL */
  struct mailimf_comments * comments;               /* can be NULL */
  struct mailimf_keywords * keywords;               /* can be NULL */
  struct mailimf_optional_field * optional_field;   /* can be NULL */
};

struct mailimf_orig_date {
  struct mailimf_date_time * date_time; /* != NULL */
};

struct mailimf_from {
  struct mailimf_mailbox_list * mb_list; /* != NULL */
};

struct mailimf_sender {
  struct mailimf_mailbox * mb; /* != NULL */
};

struct mailimf_reply_to {
  struct mailimf_address_list * addr_list; /* != NULL */
};

struct mailimf_to {
  struct mailimf_address_list * addr_list; /* != NULL */
};

struct mailimf_cc {
  struct mailimf_address_list * addr_list; /* != NULL */
};

struct mailimf_bcc {
  struct mailimf_address_list * addr_list; /* can be NULL */
};

struct mailimf_message_id {
  char * value; /* != NULL */
};

struct mailimf_in_reply_to {
  clist * msg_id_list; /* != NULL */
};

struct mailimf_references {
  clist * msg_id_list; /* != NULL */
};

struct mailimf_subject {
  char * value; /* != NULL */
};

struct mailimf_comments {
  char * value; /* != NULL */
};

struct mailimf_keywords {
  clist * list; /* != NULL */
};

#if 0
struct mailimf_resent_date {
  struct mailimf_date_time * date_time; /* can be NULL */
};
#endif

#if 0
struct mailimf_trace {
  struct mailimf_return * return_path;
  clist * received_list; /* mailimf_received */
};
#endif

struct mailimf_return {
  struct mailimf_path * path; /* != NULL */
};

struct mailimf_path {
  char * addr_spec; /* can be NULL */
};

#if 0
struct mailimf_received {
  struct mailimf_name_val_list * name_val_list;
  struct mailimf_date_time * date_time;
};

struct mailimf_name_val_list {
  clist * list; /* mailimf_name_val_pair */
};

struct mailimf_name_val_pair {
  char * item_name;
  struct mailimf_item_value * item_value;
};

enum {
  MAILIMF_ITEM_VALUE_ANGLE_ADDR_LIST,
  MAILIMF_ITEM_VALUE_ADDR_SPEC,
  MAILIMF_ITEM_VALUE_ATOM,
  MAILIMF_ITEM_VALUE_DOMAIN,
  MAILIMF_ITEM_VALUE_MSG_ID
};

struct mailimf_item_value {
  int type;
  clist * angle_addr_list;
  char * addr_spec;
  char * atom;
  char * domain;
  char * msg_id;
};
#endif

struct mailimf_optional_field {
  char * name;  /* != NULL */
  char * value; /* != NULL */
};


void mailimf_atom_free(char * atom);

void mailimf_dot_atom_free(char * dot_atom);

void mailimf_dot_atom_text_free(char * dot_atom);

void mailimf_quoted_string_free(char * quoted_string);

void mailimf_word_free(char * word);

void mailimf_phrase_free(char * phrase);

void mailimf_unstructured_free(char * unstructured);


struct mailimf_date_time *
mailimf_date_time_new(int day, int month, int year,
		      int hour, int min, int sec, int zone);

void mailimf_date_time_free(struct mailimf_date_time * date_time);


struct mailimf_address *
mailimf_address_new(int type, struct mailimf_mailbox * mailbox,
		    struct mailimf_group * group);

void mailimf_address_free(struct mailimf_address * address);


struct mailimf_mailbox *
mailimf_mailbox_new(char * display_name, char * addr_spec);

void mailimf_mailbox_free(struct mailimf_mailbox * mailbox);


void mailimf_angle_addr_free(char * angle_addr);


struct mailimf_group *
mailimf_group_new(char * display_name, struct mailimf_mailbox_list * mb_list);

void mailimf_group_free(struct mailimf_group * group);

void mailimf_display_name_free(char * display_name);


struct mailimf_mailbox_list *
mailimf_mailbox_list_new(clist * list);

void mailimf_mailbox_list_free(struct mailimf_mailbox_list * mb_list);



struct mailimf_address_list *
mailimf_address_list_new(clist * list);

void mailimf_address_list_free(struct mailimf_address_list * addr_list);


void mailimf_addr_spec_free(char * addr_spec);

void mailimf_local_part_free(char * local_part);

void mailimf_domain_free(char * domain);

void mailimf_domain_literal_free(char * domain);



struct mailimf_message * mailimf_message_new(struct mailimf_fields * fields,
					     struct mailimf_body * body);

void mailimf_message_free(struct mailimf_message * message);


struct mailimf_body * mailimf_body_new(char * text, size_t size);

void mailimf_body_free(struct mailimf_body * body);


struct mailimf_fields * mailimf_fields_new(clist * list);

void mailimf_fields_free(struct mailimf_fields * fields);


#if 0
struct mailimf_unparsed_fields * mailimf_unparsed_fields_new(clist * list);

void mailimf_unparsed_fields_free(struct mailimf_unparsed_fields * fields);
#endif


struct mailimf_resent_field *
mailimf_resent_field_new(int type, struct mailimf_orig_date * resent_date,
			 struct mailimf_from * resent_from,
			 struct mailimf_sender * resent_sender,
			 struct mailimf_to * resent_to,
			 struct mailimf_cc * resent_cc,
			 struct mailimf_bcc * resent_bcc,
			 struct mailimf_message_id * resent_msg_id);

void mailimf_resent_field_free(struct mailimf_resent_field * resent_field);


struct mailimf_resent_fields_list *
mailimf_resent_fields_list_new(clist * list);

void mailimf_resent_fields_list_free(struct mailimf_resent_fields_list *
				     resent_fields);



struct mailimf_trace_resent_fields *
mailimf_trace_resent_fields_new(/*struct mailimf_trace * trace, */
				struct mailimf_return * return_path,
				struct mailimf_resent_fields_list *
				resent_fields);

void mailimf_trace_resent_fields_free(struct mailimf_trace_resent_fields *
				      trace_resent_fields);



struct mailimf_delivering_info *
mailimf_delivering_info_new(clist * list);

void mailimf_delivering_info_free(struct mailimf_delivering_info *
				  info);

struct mailimf_field *
mailimf_field_new(int type,
		  struct mailimf_delivering_info * delivering_info,
		  struct mailimf_orig_date * orig_date,
		  struct mailimf_from * from,
		  struct mailimf_sender * sender,
		  struct mailimf_reply_to * reply_to,
		  struct mailimf_to * to,
		  struct mailimf_cc * cc,
		  struct mailimf_bcc * bcc,
		  struct mailimf_message_id * message_id,
		  struct mailimf_in_reply_to * in_reply_to,
		  struct mailimf_references * references,
		  struct mailimf_subject * subject,
		  struct mailimf_comments * comments,
		  struct mailimf_keywords * keywords,
		  struct mailimf_optional_field * optional_field);

void mailimf_field_free(struct mailimf_field * field);


struct mailimf_fields * mailimf_fields_new(clist * list);

void mailimf_fields_free(struct mailimf_fields * fields);


struct mailimf_orig_date * mailimf_orig_date_new(struct mailimf_date_time *
						 date_time);

void mailimf_orig_date_free(struct mailimf_orig_date * orig_date);

struct mailimf_from * mailimf_from_new(struct mailimf_mailbox_list * mb_list);

void mailimf_from_free(struct mailimf_from * from);

struct mailimf_sender * mailimf_sender_new(struct mailimf_mailbox * mb);

void mailimf_sender_free(struct mailimf_sender * sender);

struct mailimf_reply_to *
mailimf_reply_to_new(struct mailimf_address_list * addr_list);

void mailimf_reply_to_free(struct mailimf_reply_to * reply_to);

struct mailimf_to * mailimf_to_new(struct mailimf_address_list * addr_list);

void mailimf_to_free(struct mailimf_to * to);

struct mailimf_cc * mailimf_cc_new(struct mailimf_address_list * addr_list);

void mailimf_cc_free(struct mailimf_cc * cc);

struct mailimf_bcc * mailimf_bcc_new(struct mailimf_address_list * addr_list);

void mailimf_bcc_free(struct mailimf_bcc * bcc);

struct mailimf_message_id * mailimf_message_id_new(char * msg_id);

void mailimf_message_id_free(struct mailimf_message_id * message_id);

struct mailimf_in_reply_to * mailimf_in_reply_to_new(clist * msg_id_list);

void mailimf_in_reply_to_free(struct mailimf_in_reply_to * in_reply_to);

struct mailimf_references * mailimf_references_new(clist * msg_id_list);

void mailimf_references_free(struct mailimf_references * references);

void mailimf_msg_id_free(char * msg_id);

void mailimf_id_left_free(char * id_left);

void mailimf_id_right_free(char * id_right);

void mailimf_no_fold_quote_free(char * nfq);

void mailimf_no_fold_literal_free(char * nfl);

struct mailimf_subject * mailimf_subject_new(char * value);

void mailimf_subject_free(struct mailimf_subject * subject);

struct mailimf_comments * mailimf_comments_new(char * value);

void mailimf_comments_free(struct mailimf_comments * comments);

struct mailimf_keywords * mailimf_keywords_new(clist * list);

void mailimf_keywords_free(struct mailimf_keywords * keywords);

#if 0
struct mailimf_trace * mailimf_trace_new(struct mailimf_return * return_path,
					 clist * received_list);

void mailimf_trace_free(struct mailimf_trace * trace);
#endif

struct mailimf_return *
mailimf_return_new(struct mailimf_path * path);

void mailimf_return_free(struct mailimf_return * return_path);


struct mailimf_path * mailimf_path_new(char * addr_spec);

void mailimf_path_free(struct mailimf_path * path);

#if 0
struct mailimf_received *
mailimf_received_new(struct mailimf_name_val_list * name_val_list,
		     struct mailimf_date_time * date_time);

void mailimf_received_free(struct mailimf_received * received);

struct mailimf_name_val_list * mailimf_name_val_list_new(clist * list);

void mailimf_name_val_list_free(struct mailimf_name_val_list * name_val_list);

struct mailimf_name_val_pair *
mailimf_name_val_pair_new(char * item_name,
			  struct mailimf_item_value * item_value);

void mailimf_name_val_pair_free(struct mailimf_name_val_pair * name_val_pair);

void mailimf_item_name_free(char * item_name);

struct mailimf_item_value *
mailimf_item_value_new(int type,
		       clist * angle_addr_list,
		       char * addr_spec,
		       char * atom,
		       char * domain,
		       char * msg_id);

void mailimf_item_value_free(struct mailimf_item_value * item_value);
#endif

struct mailimf_optional_field *
mailimf_optional_field_new(char * name, char * value);

void mailimf_optional_field_free(struct mailimf_optional_field * opt_field);

void mailimf_field_name_free(char * field_name);

enum {
  MAILIMF_NO_ERROR = 0,
  MAILIMF_ERROR_PARSE,
  MAILIMF_ERROR_MEMORY,
  MAILIMF_ERROR_INVAL,
  MAILIMF_ERROR_FILE,
};

#endif
