/*
 * libEtPan! -- a mail stuff library
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef MAILIMF_TYPES_HELPER

#define MAILIMF_TYPES_HELPER

#include "mailimf_types.h"

struct mailimf_mailbox_list *
mailimf_mailbox_list_new_empty();

int mailimf_mailbox_list_add(struct mailimf_mailbox_list * mailbox_list,
			     struct mailimf_mailbox * mb);

int mailimf_mailbox_list_add_parse(struct mailimf_mailbox_list * mailbox_list,
				   char * mb_str);

int mailimf_mailbox_list_add_mb(struct mailimf_mailbox_list * mailbox_list,
				char * display_name, char * address);

struct mailimf_address_list *
mailimf_address_list_new_empty();

int mailimf_address_list_add(struct mailimf_address_list * address_list,
			     struct mailimf_address * addr);

int mailimf_address_list_add_parse(struct mailimf_address_list * address_list,
				   char * addr_str);

int mailimf_address_list_add_mb(struct mailimf_address_list * address_list,
				char * display_name, char * address);

struct mailimf_resent_fields_list *
mailimf_resent_fields_list_new_empty();

int mailimf_resent_fields_add(struct mailimf_resent_fields_list * fields,
			      struct mailimf_resent_field * field);

int
mailimf_resent_fields_list_add_data(struct mailimf_resent_fields_list *
				    resent_fields,
				    struct mailimf_date_time * resent_date,
				    struct mailimf_mailbox_list * resent_from,
				    struct mailimf_mailbox * resent_sender,
				    struct mailimf_address_list * resent_to,
				    struct mailimf_address_list * resent_cc,
				    struct mailimf_address_list * resent_bcc,
				    char * resent_msg_id);

struct mailimf_resent_fields_list *
mailimf_resent_fields_list_new_with_data(struct mailimf_date_time *
					 resent_date,
					 struct mailimf_mailbox_list *
					 resent_from,
					 struct mailimf_mailbox *
					 resent_sender,
					 struct mailimf_address_list *
					 resent_to,
					 struct mailimf_address_list *
					 resent_cc,
					 struct mailimf_address_list *
					 resent_bcc,
					 char * resent_msg_id);

struct mailimf_fields *
mailimf_fields_new_empty();

int mailimf_fields_add(struct mailimf_fields * fields,
		       struct mailimf_field * field);

int mailimf_fields_add_data(struct mailimf_fields * fields,
			    struct mailimf_date_time * date,
			    struct mailimf_mailbox_list * from,
			    struct mailimf_mailbox * sender,
			    struct mailimf_address_list * reply_to,
			    struct mailimf_address_list * to,
			    struct mailimf_address_list * cc,
			    struct mailimf_address_list * bcc,
			    char * msg_id,
			    clist * in_reply_to,
			    clist * references,
			    char * subject);

struct mailimf_fields *
mailimf_fields_new_with_data_all(struct mailimf_date_time * date,
				 struct mailimf_mailbox_list * from,
				 struct mailimf_mailbox * sender,
				 struct mailimf_address_list * reply_to,
				 struct mailimf_address_list * to,
				 struct mailimf_address_list * cc,
				 struct mailimf_address_list * bcc,
				 char * message_id,
				 clist * in_reply_to,
				 clist * references,
				 char * subject);

struct mailimf_fields *
mailimf_fields_new_with_data(struct mailimf_mailbox_list * from,
			     struct mailimf_mailbox * sender,
			     struct mailimf_address_list * reply_to,
			     struct mailimf_address_list * to,
			     struct mailimf_address_list * cc,
			     struct mailimf_address_list * bcc,
			     clist * in_reply_to,
			     clist * references,
			     char * subject);

char * mailimf_get_message_id();

struct mailimf_date_time * mailimf_get_current_date();

#endif
